/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.viewer;

import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.apps.ui.AppRegistry;
import org.eclipse.statet.r.apps.ui.RApp;

@NonNullByDefault
public class AppBrowserSession
extends BrowserSession {
    private final URL id;

    public AppBrowserSession(URL id) {
        this.id = id;
    }

    public URL getId() {
        return this.id;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getLabel());
        RApp app = this.getLatestApp();
        if (app != null) {
            Tool tool;
            IResource resource = app.getResource();
            if (resource != null) {
                if (sb.length() > 0) {
                    sb.append("\u2002\u2013\u2002");
                }
                sb.append(resource.getFullPath().toString());
            }
            if ((tool = app.getTool()) != null) {
                sb.append(" \u2502 ");
                sb.append(tool.getLabel(0));
            }
        }
        return sb.toString();
    }

    public @Nullable RApp getLatestApp() {
        return AppRegistry.getInstance().getApp(this.id);
    }
}

