/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import org.eclipse.statet.internal.rj.servi.LocalNodeFactory;
import org.eclipse.statet.internal.rj.servi.Messages;
import org.eclipse.statet.internal.rj.servi.NodeHandler;
import org.eclipse.statet.internal.rj.servi.RServiImpl;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.servi.RServi;
import org.eclipse.statet.rj.servi.node.RServiNodeFactory;
import org.eclipse.statet.rj.servi.node.RServiNodeManager;

@NonNullByDefault
public class LocalNodeManager
implements RServiNodeManager,
Disposable {
    private final String id;
    private final RMIRegistry registry;
    private final LocalNodeFactory factory;
    private @Nullable ThisNodeHandler handler;
    private boolean inUse;
    private long accessId;

    public LocalNodeManager(String id, RMIRegistry registry, LocalNodeFactory factory) {
        this.id = (String)ObjectUtils.nonNullAssert((Object)id);
        this.registry = (RMIRegistry)ObjectUtils.nonNullAssert((Object)registry);
        this.factory = (LocalNodeFactory)ObjectUtils.nonNullAssert((Object)factory);
        Utils.preLoad();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RServiNodeFactory getFactory() {
        return this.factory;
    }

    public void dispose() {
        this.stop();
    }

    @Override
    public synchronized void start() throws RjException {
        if (this.handler != null) {
            return;
        }
        try {
            ThisNodeHandler handler = new ThisNodeHandler();
            this.factory.createNode(handler);
            this.handler = handler;
            CommonsRuntime.getEnvironment().addStoppingListener((Disposable)this);
        }
        catch (Throwable e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.servi", Messages.StartNode_error_message, e));
            throw new RjInitFailedException(Messages.StartLocal_pub_error_message, e instanceof RjException ? e : null);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.handler == null) {
            return;
        }
        CommonsRuntime.getEnvironment().removeStoppingListener((Disposable)this);
        if (this.inUse) {
            this.returnRServi(this.accessId);
            if (this.handler == null) {
                return;
            }
        }
        ThisNodeHandler handler = (ThisNodeHandler)ObjectUtils.nonNullAssert((Object)this.handler);
        this.handler = null;
        this.factory.stopNode(handler);
    }

    @Override
    public synchronized RServi getRServi(String name) throws NoSuchElementException, RjException {
        if (this.handler == null) {
            this.start();
        }
        if (this.inUse) {
            throw new NoSuchElementException(Messages.GetRServi_NoInstance_pub_Single_message);
        }
        try {
            ThisNodeHandler handler = (ThisNodeHandler)ObjectUtils.nonNullAssert((Object)this.handler);
            handler.bindClient(name, "local");
            this.inUse = true;
            return new RServiImpl(this.accessId, handler, handler.getClientHandler());
        }
        catch (Throwable e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.servi", Messages.BindClient_error_message, e));
            throw new RjException(Messages.GetRServi_pub_error_message);
        }
    }

    private synchronized void returnRServi(long accessId) {
        if (this.handler == null) {
            return;
        }
        if (this.accessId != accessId) {
            throw new IllegalStateException("Access id no longer valid.");
        }
        try {
            ThisNodeHandler handler = (ThisNodeHandler)ObjectUtils.nonNullAssert((Object)this.handler);
            this.inUse = false;
            ++this.accessId;
            handler.unbindClient();
        }
        catch (Throwable e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.servi", Messages.UnbindClient_error_message, e));
            this.stop();
        }
    }

    private class ThisNodeHandler
    extends NodeHandler
    implements RServiImpl.PoolRef {
        private ThisNodeHandler() {
        }

        @Override
        public void returnObject(long accessId) throws RjException, RemoteException {
            LocalNodeManager.this.returnRServi(accessId);
        }
    }
}

