/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRawStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;

@NonNullByDefault
public class RRawFix64Store
extends AbstractRawStore
implements ExternalizableRStore {
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    private final byte[] @NonNull [] byteValues;

    public RRawFix64Store(long length) {
        this.length = length;
        this.byteValues = RRawFix64Store.new2dByteArray(length, 0x10000000);
    }

    public RRawFix64Store(byte[] @NonNull [] values) {
        this.length = RRawFix64Store.check2dArrayLength(values, 0x10000000);
        this.byteValues = values;
    }

    public RRawFix64Store(RJIO io, long length) throws IOException {
        this.length = length;
        this.byteValues = RRawFix64Store.new2dByteArray(length, 0x10000000);
        int i = 0;
        while (i < this.byteValues.length) {
            io.readByteData(this.byteValues[i], this.byteValues[i].length);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        int i = 0;
        while (i < this.byteValues.length) {
            io.writeByteData(this.byteValues[i], this.byteValues[i].length);
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public final boolean isNA(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public final boolean isNA(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public final boolean isMissing(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public final boolean isMissing(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public byte getRaw(int idx) {
        return this.byteValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public byte getRaw(long idx) {
        return this.byteValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public byte[] toRawArray() {
        int l = this.checkToArrayLength();
        byte[] array = new byte[l];
        int i = 0;
        int destIdx = 0;
        while (i < this.byteValues.length) {
            byte[] raws = this.byteValues[i];
            System.arraycopy(raws, 0, array, destIdx, raws.length);
            destIdx += raws.length;
            ++i;
        }
        return array;
    }

    @Override
    public void setRaw(int idx, byte value) {
        this.byteValues[idx / 0x10000000][idx % 0x10000000] = value;
    }

    @Override
    public void setRaw(long idx, byte value) {
        this.byteValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = value;
    }

    @Override
    public Byte get(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.byteValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public Byte get(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.byteValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public @NonNull Byte[] toArray() {
        int l = this.checkToArrayLength();
        Byte[] array = new Byte[l];
        int i = 0;
        int destIdx = 0;
        while (i < this.byteValues.length) {
            byte[] raws = this.byteValues[i];
            int j = 0;
            while (j < raws.length) {
                array[destIdx] = raws[j];
                ++j;
                ++destIdx;
            }
            ++i;
        }
        return array;
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        if ((integer & 0xFFFFFF00) != 0) {
            return -1L;
        }
        byte raw = (byte)(integer & 0xFF);
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.byteValues.length) {
            byte[] raws = this.byteValues[i];
            while (j < raws.length) {
                if (raws[i] != raw) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

