/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.dsl.dcf.core.source.ast.Field;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrSourceUnitModelInfo;
import org.eclipse.statet.r.core.source.util.RPkgDescrHeuristicTokenScanner;

@NonNullByDefault
public class RPkgDescrAssistInvocationContext
extends AssistInvocationContext {
    private @Nullable RPkgDescrHeuristicTokenScanner scanner;

    private static String checkProposalContentType(String contentType, SourceEditor editor, int offset) {
        try {
            if (contentType == "RPkgDescr.Default" && editor.getViewer().getDocument().getLineInformationOfOffset(offset).getOffset() == offset) {
                return "RPkgDescr.FieldName";
            }
        }
        catch (BadLocationException e) {
            RUIPlugin.logUncriticalError(e);
        }
        return contentType;
    }

    public RPkgDescrAssistInvocationContext(SourceEditor editor, int offset, DocContentSections documentContentInfo, String contentType, boolean isProposal, IProgressMonitor monitor) {
        super(editor, offset, documentContentInfo, isProposal ? RPkgDescrAssistInvocationContext.checkProposalContentType(contentType, editor, offset) : contentType, isProposal ? 2 : 0, monitor);
    }

    public RPkgDescrAssistInvocationContext(AssistInvocationContext base, boolean isProposal, IProgressMonitor monitor) {
        super(base, isProposal ? 2 : 0, monitor);
    }

    protected String getModelTypeId() {
        return "RPkg.Descr";
    }

    public RCoreAccess getRCoreAccess() {
        return RCore.getContextAccess((IAdaptable)this.getSourceUnit());
    }

    public int getTabWidth() {
        return this.getRCoreAccess().getRCodeStyle().getTabWidth();
    }

    public final RPkgDescrHeuristicTokenScanner getHeuristicTokenScanner() {
        RPkgDescrHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = new RPkgDescrHeuristicTokenScanner(this.getDocumentContentInfo());
        }
        return scanner;
    }

    public @Nullable RPkgDescrSourceUnitModelInfo getModelInfo() {
        return (RPkgDescrSourceUnitModelInfo)super.getModelInfo();
    }

    public @Nullable DslAstNode getInvocationDescrAstNode() {
        AstNode node = this.getInvocationAstSelection().getCovering();
        if (node == null) {
            node = this.getAstInfo().getRoot();
        }
        while (node != null) {
            if (node instanceof DslAstNode) {
                return (DslAstNode)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public @Nullable Field getInvocationDescrFieldNode() {
        DslAstNode node = this.getInvocationDescrAstNode();
        while (node != null && node.getNodeType() != NodeType.KEY_VALUE_ENTRY) {
            node = node.getDslParent();
        }
        return (Field)node;
    }

    public @Nullable DslAstNode getSelectionDescrAstNode() {
        AstNode node = this.getAstSelection().getCovering();
        return node instanceof DslAstNode ? (DslAstNode)node : null;
    }

    protected @Nullable String computeIdentifierPrefix(int offset) throws BadPartitioningException, BadLocationException {
        IDocument document = this.getDocument();
        if (this.getInvocationContentType() == "RPkgDescr.FieldName") {
            ITypedRegion partition = TextUtils.getPartition((IDocument)document, (DocContentSections)this.getDocumentContentInfo(), (int)offset, (boolean)true);
            if (partition.getType() == "RPkgDescr.FieldName") {
                int startOffset = partition.getOffset();
                return document.get(startOffset, offset - startOffset);
            }
            return "";
        }
        return super.computeIdentifierPrefix(offset);
    }
}

