/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.rtools.Messages;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.ui.ElementNameProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class RElementNameVariableResolver
implements IDynamicVariableResolver {
    public static final String R_OBJECT_NAME_NAME = "r_object_name";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        IWorkbenchPart part = UIAccess.getActiveWorkbenchPart((boolean)false);
        if (part != null) {
            ISelection selection;
            IWorkbenchPartSite site = part.getSite();
            ISelectionProvider selectionProvider = site.getSelectionProvider();
            if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
                Object element;
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (selection.isEmpty()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_EmptySelection_message, (Object)R_OBJECT_NAME_NAME)));
                }
                if (structuredSelection.size() == 1 && (element = structuredSelection.getFirstElement()) instanceof RElement) {
                    Object elementName = selection instanceof ElementNameProvider ? ((ElementNameProvider)selection).getElementName(selection instanceof ITreeSelection ? ((ITreeSelection)selection).getPaths()[0] : element) : ((RElement)element).getElementName();
                    return this.checkName((ElementName)elementName);
                }
                LtkModelElement[] elements = LTKSelectionUtils.getSelectedElements((IStructuredSelection)((IStructuredSelection)selection));
                if (elements != null && elements.length == 1 && elements[0].getModelTypeId() == "R") {
                    return this.checkName(elements[0].getElementName());
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_NoSingleRElement_message, (Object)R_OBJECT_NAME_NAME)));
            }
            SourceEditor editor = (SourceEditor)part.getAdapter(SourceEditor.class);
            if (editor instanceof RSourceEditor) {
                try {
                    DocContentSections documentContentInfo = editor.getDocumentContentInfo();
                    Point range = editor.getViewer().getSelectedRange();
                    String contentType = TextUtils.getContentType((IDocument)editor.getViewer().getDocument(), (DocContentSections)documentContentInfo, (int)range.x, (range.y == 0 ? 1 : 0) != 0);
                    RAssistInvocationContext context = new RAssistInvocationContext(editor, (TextRegion)JFaceTextRegion.newByStartLength((int)range.x, (int)range.y), documentContentInfo, contentType, null, null);
                    return this.checkName((ElementName)context.getNameSelection());
                }
                catch (BadLocationException | BadPartitioningException e) {
                    RUIPlugin.logUncriticalError(e);
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_NoSingleRElement_message, (Object)R_OBJECT_NAME_NAME)));
    }

    private String checkName(ElementName elementName) throws CoreException {
        String name;
        if (elementName instanceof RElementName && (name = ((RElementName)elementName).getDisplayName(3)) != null) {
            return name;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_InvalidObject_QualifiedName_message, (Object)R_OBJECT_NAME_NAME)));
    }
}

