/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.internal.r.ui.pkgmanager.DetailGroup;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.model.core.NamedElement;
import org.eclipse.statet.r.core.pkgmanager.RPkgVersions;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgSpec;

@NonNullByDefault
public final class RPkgListLabelProvider
extends StyledCellLabelProvider {
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof DetailGroup) {
            cell.setText(((DetailGroup)element).getLabel());
            cell.setStyleRanges(null);
        } else if (element instanceof NamedElement) {
            NamedElement pkg = (NamedElement)element;
            StyledString text = new StyledString();
            text.append(pkg.getName());
            String version = this.getVersionString(pkg);
            if (!version.isEmpty()) {
                text.append(" (", StyledString.QUALIFIER_STYLER);
                text.append(version, StyledString.QUALIFIER_STYLER);
                text.append(")", StyledString.QUALIFIER_STYLER);
            }
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
        } else {
            cell.setText(element.toString());
            cell.setStyleRanges(null);
        }
        super.update(cell);
    }

    private String getVersionString(NamedElement obj) {
        NamedElement namedElement = obj;
        Objects.requireNonNull(namedElement);
        NamedElement namedElement2 = namedElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RPkg.class, RPkgSpec.class, RPkgVersions.class}, (Object)namedElement2, n)) {
            case 0 -> {
                RPkg pkg = (RPkg)namedElement2;
                yield pkg.getVersion().toString();
            }
            case 1 -> {
                RPkgSpec pkg = (RPkgSpec)namedElement2;
                yield pkg.getVersion().toString();
            }
            case 2 -> {
                RPkgVersions pkg = (RPkgVersions)namedElement2;
                yield CollectionUtils.toString((List)pkg.getVersions(), (String)", ");
            }
            default -> "";
        };
    }
}

