/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.launching;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.variables.core.StaticVariable;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.r.apps.ui.Messages;
import org.eclipse.statet.internal.r.apps.ui.RAppUIPlugin;
import org.eclipse.statet.internal.r.apps.ui.launching.AppControlConfigs;
import org.eclipse.statet.internal.r.apps.ui.launching.AppControlLaunchConfig;
import org.eclipse.statet.internal.r.apps.ui.launching.AppRCommandHandler;
import org.eclipse.statet.internal.r.apps.ui.launching.DataLoader;
import org.eclipse.statet.internal.r.apps.ui.variables.AppVarView;
import org.eclipse.statet.internal.r.apps.ui.viewer.AppBrowserSession;
import org.eclipse.statet.internal.r.apps.ui.viewer.AppBrowserView;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.PortForwardingL;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSession;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.RunnableStatus;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.r.apps.ui.AppRegistry;
import org.eclipse.statet.r.apps.ui.RApp;
import org.eclipse.statet.r.apps.ui.VariablesData;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.console.core.util.RCodeVariableText;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.statet.rj.ts.core.console.AbstractRConsoleOptRunnable;
import org.eclipse.statet.rj.ts.core.console.RConsoleService;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class AppRunner
extends AbstractRConsoleOptRunnable
implements RApp {
    public static final String RUN_TASK_ID = "org.eclipse.statet.r.apps/RunApp";
    public static final String STOP_TASK_ID = "org.eclipse.statet.r.apps/StopApp";
    private static final Status NOT_RUNNING_DATA_STATUS = new InfoStatus("org.eclipse.statet.r.apps", "The app is not running.");
    private static final Status NOT_LOADED_DATA_STATUS = new InfoStatus("org.eclipse.statet.r.apps", "Variabes are not yet available.");
    private final AppControlLaunchConfig config;
    private final CopyOnWriteIdentityListSet<RApp.Listener> listeners = new CopyOnWriteIdentityListSet();
    private @Nullable AppSession session;
    private @Nullable RProcess tool;
    private @Nullable IWorkbenchPage workbenchPage;
    private @Nullable DataLoader variablesLoader;
    private volatile @Nullable VariablesData variablesData;

    public static RProcess fetchRProcess(IWorkbenchPage page) throws CoreException {
        Tool tool = NicoUI.getToolRegistry().getActiveToolSession(page).getTool();
        NicoUITools.accessTool((String)"R", (Tool)tool);
        return (RProcess)tool;
    }

    public AppRunner(AppControlLaunchConfig config) {
        super(RUN_TASK_ID, NLS.bind((String)"Run R App ''{0}''", (Object)config.getAppFolder().getFullPath().toString()));
        this.config = config;
        this.initVars();
    }

    @Override
    public IResource getResource() {
        return this.config.getAppFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(RConsoleService r, ProgressMonitor m) throws StatusException {
        AppRCommandHandler listener = null;
        try {
            AppSession session;
            AppRunner appRunner = this;
            synchronized (appRunner) {
                this.tool = (RProcess)r.getTool();
                this.session = session = new AppSession(this.tool);
            }
            session.init(m);
            listener = AppRCommandHandler.connect(this, (RToolService)r, m);
            r.briefAboutToChange();
            r.submitToConsole(session.getStartCode(), m);
        }
        finally {
            r.briefChanged(1);
            this.onAppStopped(null);
            if (listener != null) {
                listener.disconnect(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAppStarted(String url, String typeId) {
        AppSession session;
        AppRunner appRunner = this;
        synchronized (appRunner) {
            session = this.session;
            if (session == null) {
                return;
            }
        }
        boolean isRunning = session.onStarted(url);
        this.updateVarsOnStarted();
        if (isRunning) {
            AppRegistry.getInstance().onAppStarted(session.getIdUrl(), this);
            if (this.config.getViewerId() != null) {
                this.showViewer(session, this.config.getViewerId());
            }
            if (this.config.getVariablesViewAction() != 0 && this.variablesData != null) {
                this.showVariablesView(session, this.config.getVariablesViewAction());
            }
            this.refreshVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAppStopped(@Nullable String url) {
        AppSession session;
        AppRunner appRunner = this;
        synchronized (appRunner) {
            session = this.session;
            if (session == null) {
                return;
            }
            this.session = null;
        }
        session.onAppStop();
        if (session.getIdUrl() != null) {
            AppRegistry.getInstance().onAppStopped(session.getIdUrl(), this);
        }
        this.updateVarsOnStopped();
    }

    public @Nullable RProcess getTool() {
        return this.tool;
    }

    protected IWorkbenchPage getWorkbenchPage() {
        IWorkbenchPage page = this.workbenchPage;
        if (page == null) {
            page = this.config.getWorkbenchPage();
        }
        if (page != null && page.getWorkbenchWindow().getActivePage() == page) {
            return page;
        }
        this.workbenchPage = page = UIAccess.getActiveWorkbenchPage((boolean)true);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        AppRunner appRunner = this;
        synchronized (appRunner) {
            AppSession session = this.session;
            return session != null && session.isRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getStartedTimestamp() {
        AppRunner appRunner = this;
        synchronized (appRunner) {
            AppSession session = this.session;
            return session != null && session.isRunning() ? session.startedTimestamp : Long.MIN_VALUE;
        }
    }

    @Override
    public void startApp(IWorkbenchPage page) throws CoreException {
        RProcess tool = AppRunner.fetchRProcess(page);
        Status status = this.tryStart(tool);
        if (status.getSeverity() < 4) {
            return;
        }
        throw new CoreException(StatusUtils.convert((Status)status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canRestartApp() {
        AppRunner appRunner = this;
        synchronized (appRunner) {
            block4: {
                AppSession session = this.session;
                if (session != null && session.isRunning()) break block4;
                return true;
            }
        }
        return this.config.getStopCode() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartApp(IWorkbenchPage page) throws CoreException {
        Status status0;
        Queue.Section queueSection;
        RProcess tool;
        AppRunner appRunner = this;
        synchronized (appRunner) {
            tool = this.tool;
            AppSession session = this.session;
            queueSection = session != null && session.isRunning() ? session.queueSection : null;
        }
        AppRunner runner = new AppRunner(this.config);
        runner.workbenchPage = this.workbenchPage;
        Status status = null;
        if (tool != null) {
            if (queueSection != null && queueSection != tool.getQueue().getTopLevelSection() && (status0 = runner.tryRestart(tool, queueSection)).getSeverity() < 4) {
                return;
            }
            status0 = runner.tryRestart(tool, tool.getQueue().getTopLevelSection());
            if (status0.getSeverity() < 4) {
                return;
            }
            if (status == null) {
                status = status0;
            }
        }
        if ((status0 = runner.tryRestart(tool = AppRunner.fetchRProcess(page), tool.getQueue().getTopLevelSection())).getSeverity() < 4) {
            return;
        }
        if (status == null) {
            status = status0;
        }
        throw new CoreException(StatusUtils.convert((Status)status));
    }

    private Status tryStart(RProcess tool) {
        Queue queue = tool.getQueue();
        Status status = queue.add((ToolRunnable)this);
        if (status.getSeverity() < 4) {
            this.stopBlocking(tool, this.config.getStopBlocking());
        }
        return status;
    }

    private Status tryRestart(RProcess tool, Queue.Section queueSection) {
        Queue queue = tool.getQueue();
        Status status = queue.add((ToolRunnable)this, queueSection, 1);
        if (status.getSeverity() < 4) {
            AppRunner runner = (AppRunner)((RunnableStatus)status).getRunnable();
            runner.stopBlocking(tool, this.config.getStopBlocking() | 2);
        }
        return status;
    }

    private void stopBlocking(RProcess tool, int mode) {
        ToolRunnable currentRunnable;
        if (mode == 0) {
            return;
        }
        ToolController controller = tool.getController();
        if (controller != null && (currentRunnable = controller.getCurrentRunnable()) != this && currentRunnable instanceof AppRunner) {
            AppRunner runner = (AppRunner)currentRunnable;
            if ((mode & 1) != 0 || (mode & 2) != 0 && runner.config == this.config) {
                runner.stopApp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canStopApp() {
        AppRunner appRunner = this;
        synchronized (appRunner) {
            block4: {
                AppSession session = this.session;
                if (session != null && session.isRunning()) break block4;
                return false;
            }
        }
        return this.config.getStopCode() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopApp() {
        AppSession session;
        AppRunner appRunner = this;
        synchronized (appRunner) {
            session = this.session;
            if (session == null) {
                return;
            }
        }
        if (this.config.getStopCode() != null) {
            session.getTool().getQueue().addHot((ToolRunnable)new StopRunnable());
        }
    }

    private void showViewer(AppSession session, String viewerId) {
        if (session.getLocalUrl() == null) {
            this.onError(4, "Cannot open viewer to show the R app: URL is missing.", null, 2);
            return;
        }
        UIAccess.getDisplay().asyncExec(() -> {
            Object object = this;
            synchronized (object) {
                if (session != this.session || !session.isRunning()) {
                    return;
                }
            }
            try {
                switch (viewerId) {
                    case "workbench-external": {
                        this.openExternalBrowser(session);
                        return;
                    }
                    case "workbench-view": {
                        this.openViewBrowser(this.getWorkbenchPage(), session);
                        return;
                    }
                }
                throw new UnsupportedOperationException("viewerId= " + viewerId);
            }
            catch (Exception e) {
                this.onError(4, Messages.Operation_Viewer_error_Run_message, e, 3);
                return;
            }
        });
    }

    private void openExternalBrowser(AppSession session) throws PartInitException, MalformedURLException {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        IWebBrowser webBrowser = browserSupport.getExternalBrowser();
        webBrowser.openURL(session.getLocalUrl().toURL());
    }

    private AppBrowserView getView(IWorkbenchPage page) throws PartInitException {
        return (AppBrowserView)page.showView("org.eclipse.statet.r.apps.views.AppViewer", null, 2);
    }

    private void openViewBrowser(IWorkbenchPage page, AppSession session) throws PartInitException {
        AppBrowserView view = this.getView(page);
        AppBrowserSession viewSession = (AppBrowserSession)BrowserSession.findSessionById((ImCollection)view.getSessions(), (Object)session.getIdUrl());
        if (viewSession == null) {
            viewSession = new AppBrowserSession(session.getIdUrl());
        }
        view.openUrl(session.getLocalUrl(), viewSession);
    }

    private void showVariablesView(AppSession session, int viewActionMode) {
        UIAccess.getDisplay().asyncExec(() -> {
            AppRunner appRunner = this;
            synchronized (appRunner) {
                if (session != this.session || !session.isRunning()) {
                    return;
                }
            }
            try {
                Object view;
                IWorkbenchPage page = this.getWorkbenchPage();
                IViewReference viewRef = page.findViewReference("org.eclipse.statet.r.apps.views.VariableViewer");
                if (viewRef != null) {
                    if (viewRef.isFastView()) {
                        return;
                    }
                    view = viewRef.getView(false);
                    if (view != null && page.isPartVisible((IWorkbenchPart)view)) {
                        return;
                    }
                }
                view = (AppVarView)page.showView("org.eclipse.statet.r.apps.views.VariableViewer", null, viewActionMode);
                ((AppVarView)((Object)((Object)view))).setShownByLauncher(this);
            }
            catch (PartInitException e) {
                this.onError(4, Messages.Operation_Variables_error_Run_message, e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RApp.Listener listener) {
        boolean refresh;
        ObjectUtils.nonNullAssert((Object)listener);
        CopyOnWriteIdentityListSet<RApp.Listener> copyOnWriteIdentityListSet = this.listeners;
        synchronized (copyOnWriteIdentityListSet) {
            refresh = this.listeners.isEmpty() && this.variablesLoader == null;
            this.listeners.add((Object)listener);
        }
        if (refresh) {
            this.refreshVariables();
        }
    }

    @Override
    public void removeListener(RApp.Listener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public @Nullable VariablesData getVariables() {
        return this.variablesData;
    }

    private void initVars() {
        String code = this.config.getVariablesCode();
        if (code == null) {
            return;
        }
        this.variablesData = new VariablesData(code, NOT_RUNNING_DATA_STATUS);
    }

    private void updateVarsOnStarted() {
        VariablesData data = this.variablesData;
        if (data == null || data.getStatus() != NOT_RUNNING_DATA_STATUS) {
            return;
        }
        this.setData(new VariablesData(data.getExpression(), NOT_LOADED_DATA_STATUS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshVariables() {
        DataLoader loader;
        VariablesData data = this.variablesData;
        if (data == null) {
            return;
        }
        CopyOnWriteIdentityListSet<RApp.Listener> copyOnWriteIdentityListSet = this.listeners;
        synchronized (copyOnWriteIdentityListSet) {
            loader = this.variablesLoader;
            if (loader == null) {
                if (this.listeners.isEmpty() || !this.isRunning()) {
                    return;
                }
                this.variablesLoader = loader = new DataLoader(this, data.getExpression());
            }
        }
        loader.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVarsOnStopped() {
        DataLoader loader;
        VariablesData data = this.variablesData;
        if (data == null) {
            return;
        }
        CopyOnWriteIdentityListSet<RApp.Listener> copyOnWriteIdentityListSet = this.listeners;
        synchronized (copyOnWriteIdentityListSet) {
            loader = this.variablesLoader;
            this.variablesLoader = null;
        }
        if (loader != null) {
            loader.stop();
        }
        this.setData(new VariablesData(data.getExpression(), NOT_RUNNING_DATA_STATUS));
    }

    void setData(VariablesData variables) {
        this.variablesData = variables;
        RApp.AppEvent event = new RApp.AppEvent(this);
        for (RApp.Listener listener : this.listeners) {
            listener.onVariablesChanged(event);
        }
    }

    private void onError(int severity, String message, @Nullable Throwable e, int style) {
        StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(severity, "org.eclipse.statet.r.apps", message, e), style);
    }

    private void onError(int severity, String message, @Nullable Throwable e) {
        this.onError(severity, message, e, 1);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AppRunner) {
            return this.config == ((AppRunner)obj).config;
        }
        return false;
    }

    private class AppSession {
        private final RProcess rProcess;
        private Queue.Section queueSection;
        private String host;
        private String remoteHost;
        private int remotePort;
        private @Nullable RSAccessClientSession remoteNetSession;
        private @Nullable PortForwardingL remoteLocalPort;
        private @Nullable URI localUrl;
        private @Nullable URI idUrl;
        private boolean isRunning;
        private long startedTimestamp;

        public AppSession(RProcess tool) {
            this.rProcess = tool;
        }

        public RProcess getTool() {
            return this.rProcess;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void init(ProgressMonitor m) throws StatusException {
            this.queueSection = this.rProcess.getController().getCurrentQueueSection();
            String host = AppRunner.this.config.getAppHost();
            if (host.isEmpty()) {
                RWorkspace rWorkspace = this.rProcess.getWorkspace();
                if (rWorkspace.isRemote()) {
                    this.host = rWorkspace.getHost();
                    RSAccessClientSession remoteNetSession = rWorkspace.getRemoteNetSession(m);
                    if (remoteNetSession != null) {
                        this.remoteNetSession = remoteNetSession;
                        this.remoteHost = remoteNetSession.getTargetLocalhostString();
                    }
                } else {
                    this.host = CommonsNet.LOCAL_LOOPBACK_STRING;
                }
            } else {
                this.host = host;
            }
            if (this.remoteHost == null) {
                this.remoteHost = this.host;
            }
            this.remotePort = AppRunner.this.config.getAppPort();
        }

        public String getStartCode() throws StatusException {
            String code = AppRunner.this.config.getStartCode();
            Map<String, IStringVariable> variables = AppRunner.this.config.getVariables();
            VariableUtils.add(variables, (IStringVariable)new StaticVariable(AppControlConfigs.APP_HOST_VAR, this.remoteHost));
            VariableUtils.add(variables, (IStringVariable)new StaticVariable(AppControlConfigs.APP_PORT_VAR, this.remotePort > 0 ? Integer.toString(this.remotePort) : "NULL"));
            RCodeVariableText variableText = new RCodeVariableText(this.rProcess.getWorkspace(), variables);
            try {
                return variableText.performStringSubstitution(code, null);
            }
            catch (CoreException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.apps", NLS.bind((String)Messages.Operation_StartApp_RCode_error_SpecInvalid_message, (Object)e.getMessage())));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onStarted(String urlString) {
            block12: {
                try {
                    URI url;
                    try {
                        url = new URI(urlString);
                    }
                    catch (URISyntaxException e) {
                        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.apps", NLS.bind((String)"Invalid URL of the R app from R= ''{0}''.", (Object)urlString), (Throwable)e));
                    }
                    RSAccessClientSession remoteNetSession = this.remoteNetSession;
                    if (remoteNetSession != null) {
                        try {
                            PortForwardingL portForwarding;
                            this.remoteLocalPort = portForwarding = remoteNetSession.allocatePortForwardingL(url.getPort() != -1 ? new Port(url.getPort()) : CommonsNet.getDefaultPort((String)url.getScheme()));
                            this.localUrl = new URI(url.getScheme(), null, portForwarding.getLocalAddress().getHostString(), portForwarding.getLocalAddress().getPort(), url.getPath(), url.getQuery(), url.getFragment());
                            this.idUrl = new URI(url.getScheme(), null, this.host, url.getPort(), url.getPath(), null, null);
                            break block12;
                        }
                        catch (StatusException e) {
                            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.apps", "Failed create SSH tunnel for http connection of the R app.", (Throwable)e));
                        }
                    }
                    if (!this.host.equals(url.getHost())) {
                        this.localUrl = new URI(url.getScheme(), null, this.host, url.getPort(), url.getPath(), url.getQuery(), url.getFragment());
                        this.idUrl = new URI(url.getScheme(), null, this.host, url.getPort(), url.getPath(), null, null);
                    } else {
                        this.idUrl = this.localUrl = url;
                    }
                }
                catch (Exception e) {
                    AppRunner.this.onError(4, "An error occurred when preparing to show the R app.", e, AppRunner.this.config.getViewerId() != null ? 3 : 1);
                    return false;
                }
            }
            AppRunner appRunner = AppRunner.this;
            synchronized (appRunner) {
                this.isRunning = true;
                this.startedTimestamp = System.nanoTime();
                return true;
            }
        }

        public URI getLocalUrl() {
            return this.localUrl;
        }

        public URI getIdUrl() {
            return this.idUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAppStop() {
            AppRunner appRunner = AppRunner.this;
            synchronized (appRunner) {
                this.isRunning = false;
            }
            this.queueSection = null;
            PortForwardingL remoteForwarding = this.remoteLocalPort;
            if (remoteForwarding != null) {
                RSAccessClientSession remoteNetSession = (RSAccessClientSession)ObjectUtils.nonNullAssert((Object)this.remoteNetSession);
                this.remoteLocalPort = null;
                try {
                    remoteNetSession.releasePortForwarding(remoteForwarding);
                }
                catch (StatusException e) {
                    RAppUIPlugin.logError("Failed delete SSH tunnel for http connection of the R app.", e);
                }
            }
        }
    }

    public class StopRunnable
    extends AbstractRToolRunnable {
        public StopRunnable() {
            super(AppRunner.STOP_TASK_ID, "Stop R App");
        }

        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(RToolService r, ProgressMonitor m) throws StatusException {
            AppRunner appRunner = AppRunner.this;
            synchronized (appRunner) {
                AppSession session = AppRunner.this.session;
                if (session == null || !session.isRunning()) {
                    return;
                }
            }
            String code = AppRunner.this.config.getStopCode();
            r.evalVoid(code, m);
        }
    }
}

