/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.util;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private transient @Nullable String versionString;
    private transient int hash;

    private static int parseInt(String value, String componentName) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%1$s= '%2$s'", componentName, value), e);
        }
    }

    private static void validateInt(int value, String componentName) {
        if (value < 0) {
            throw new IllegalArgumentException(componentName + "= " + value);
        }
    }

    public Version(int major, int minor, int micro, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = ObjectUtils.nonNullElse(qualifier, "");
        this.validate();
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor) {
        this(major, minor, 0, null);
    }

    public Version(Version version) {
        this(version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    public Version(byte[] bytes) {
        if (bytes.length != 12) {
            throw new IllegalArgumentException();
        }
        this.major = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        this.minor = (bytes[4] & 0xFF) << 24 | (bytes[5] & 0xFF) << 16 | (bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF;
        this.micro = (bytes[8] & 0xFF) << 24 | (bytes[9] & 0xFF) << 16 | (bytes[10] & 0xFF) << 8 | bytes[11] & 0xFF;
        this.qualifier = "";
        this.validate();
    }

    public Version(String version) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        String[] components = version.split("\\.", 4);
        if (components.length == 0 || components[0].isEmpty()) {
            throw new IllegalArgumentException(String.format("version= '%1$s'", version));
        }
        major = Version.parseInt(components[0], "major");
        if (components.length >= 2) {
            minor = Version.parseInt(components[1], "minor");
            if (components.length >= 3) {
                micro = Version.parseInt(components[2], "micro");
                if (components.length >= 4) {
                    qualifier = components[3];
                }
            }
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    private void validate() {
        Version.validateInt(this.major, "major");
        Version.validateInt(this.minor, "minor");
        Version.validateInt(this.micro, "micro");
        int i = 0;
        while (i < this.qualifier.length()) {
            char c = this.qualifier.charAt(i);
            if (!Character.isDefined(c) || c == ' ') {
                throw new IllegalArgumentException("qualifier= " + this.qualifier);
            }
            ++i;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Deprecated
    public String getBuild() {
        return this.qualifier;
    }

    public int getLowestNonZeroComponent() {
        if (!this.qualifier.isEmpty()) {
            return 3;
        }
        if (this.micro != 0) {
            return 2;
        }
        if (this.minor != 0) {
            return 1;
        }
        if (this.major != 0) {
            return 0;
        }
        return -1;
    }

    public byte[] serialize() {
        byte[] bytes = new byte[]{(byte)(this.major >>> 24), (byte)(this.major >>> 16), (byte)(this.major >>> 8), (byte)this.major, (byte)(this.minor >>> 24), (byte)(this.minor >>> 16), (byte)(this.minor >>> 8), (byte)this.minor, (byte)(this.micro >>> 24), (byte)(this.micro >>> 16), (byte)(this.micro >>> 8), (byte)this.micro};
        return bytes;
    }

    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        h = 527;
        h = 31 * h + this.major;
        h = 31 * h + this.minor;
        h = 31 * h + this.micro;
        this.hash = h = 31 * h + this.qualifier.hashCode();
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof Version)) break block3;
                Version other = (Version)obj;
                if (this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.qualifier.equals(other.qualifier)) break block2;
            }
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Version other) {
        if (this == other) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }

    public int compareTo(Version other, int numComponents) {
        if (numComponents <= 0 || numComponents > 4) {
            throw new IllegalArgumentException();
        }
        if (this == other) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0 || numComponents == 1) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0 || numComponents == 2) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0 || numComponents == 3) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }

    public String toString() {
        String s = this.versionString;
        if (s != null) {
            return s;
        }
        StringBuilder sb = new StringBuilder(20 + this.qualifier.length());
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        sb.append('.');
        sb.append(this.micro);
        if (!this.qualifier.isEmpty()) {
            sb.append('.');
            sb.append(this.qualifier);
        }
        this.versionString = sb.toString();
        return this.versionString;
    }
}

