/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

@NonNullByDefault
public class PixelConverter {
    private static final double FONT_WS_FACTOR = switch ((String)ObjectUtils.nonNullElse((Object)Platform.getWS(), (Object)"")) {
        case "win32" -> 0.95;
        case "gtk" -> 1.15;
        default -> 1.0;
    };
    private final FontMetrics fontMetrics;
    private final boolean monospace;

    public PixelConverter(Control control) {
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(control.getFont());
            this.fontMetrics = gc.getFontMetrics();
            this.monospace = gc.stringExtent((String)"i").x == gc.stringExtent((String)"W").x;
        }
        finally {
            gc.dispose();
        }
    }

    public int convertHeightInCharsToPixels(int chars) {
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fontMetrics, (int)chars);
    }

    public int convertHorizontalDLUsToPixels(int dlus) {
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)dlus);
    }

    public int convertVerticalDLUsToPixels(int dlus) {
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fontMetrics, (int)dlus);
    }

    public int convertWidthInCharsToPixels(int chars) {
        if (this.monospace) {
            return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)chars);
        }
        return (int)(FONT_WS_FACTOR * (double)Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)chars));
    }
}

