/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.eutils.autonature.core.ProjectConfigurator;
import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ConfiguratorTask
extends Task {
    private final String label;
    private final @Nullable String natureId;
    private @Nullable IConfigurationElement configElement;
    private @Nullable ProjectConfigurator configurator;

    public ConfiguratorTask(String label, @Nullable String natureId, IConfigurationElement configElement) {
        this.label = label;
        this.natureId = natureId;
        this.configElement = configElement;
    }

    private synchronized @Nullable ProjectConfigurator getProjectConfigurator() throws CoreException {
        IConfigurationElement configElement = this.configElement;
        if (configElement != null) {
            this.configElement = null;
            this.configurator = (ProjectConfigurator)configElement.createExecutableExtension("class");
        }
        return this.configurator;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isSupported(byte mode) {
        return mode == 2;
    }

    @Override
    public byte check(IProject project, int flags, SubMonitor m) throws CoreException {
        if (this.natureId != null) {
            try {
                if (project.hasNature(this.natureId)) {
                    return 1;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if ((flags & 1) == 0) {
            return 0;
        }
        ProjectConfigurator configurator = this.getProjectConfigurator();
        if (configurator == null) {
            return 0;
        }
        return configurator.check(project, (IProgressMonitor)m);
    }

    public void configure(IProject project, SubMonitor m) {
        ProjectConfigurator configurator = this.configurator;
        if (configurator == null) {
            throw new RuntimeException();
        }
        configurator.configure(project, (IProgressMonitor)m);
    }

    public String toString() {
        return "ConfiguratorTask '" + this.label + "'";
    }
}

