/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt;

import java.util.concurrent.TimeUnit;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public abstract class ScheduledDisplayRunnable
implements Runnable {
    private static final int IDLE = 0;
    private static final int STOPPED = -1;
    private static final byte NOT_SCHEDULED = 0;
    private static final byte DIRECT_SCHEDULED = 1;
    private static final byte TIMED_SCHEDULED = 2;
    private static final int PREV_NANOS_TOL = 2000;
    private static final int SCHEDULE_NANOS_TOL = 2000000;
    private final Display display;
    private int state = 0;
    private byte scheduled = 0;
    private long scheduledTime;

    public static ScheduledDisplayRunnable adapt(final Runnable runnable, Display display) {
        return new ScheduledDisplayRunnable(display){

            @Override
            protected void execute() {
                runnable.run();
            }
        };
    }

    public ScheduledDisplayRunnable(Display display) {
        this.display = (Display)ObjectUtils.nonNullAssert((Object)display);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFor(long nanoTime, int power) {
        if (power <= 0) {
            throw new IllegalArgumentException();
        }
        ScheduledDisplayRunnable scheduledDisplayRunnable = this;
        synchronized (scheduledDisplayRunnable) {
            try {
                long prevDiff;
                if (this.state == -1) {
                    return;
                }
                long l = prevDiff = this.state > 0 ? nanoTime - this.scheduledTime : -2000L;
                if (power < this.state || power == this.state && prevDiff <= 0L) {
                    return;
                }
                this.state = power;
                this.scheduledTime = nanoTime;
                if (this.scheduled == 1 || this.scheduled == 2 && prevDiff > -2000L) {
                    return;
                }
                long remaining = nanoTime - System.nanoTime();
                if (remaining > 2000000L && Thread.currentThread() == this.display.getThread()) {
                    this.scheduled = (byte)2;
                    this.display.timerExec((int)((remaining + 400000L) / 1000000L), (Runnable)this);
                } else {
                    this.scheduled = 1;
                    this.display.asyncExec((Runnable)this);
                }
            }
            catch (RuntimeException e) {
                this.handleScheduleException(e);
            }
        }
    }

    public void scheduleFor(long nanoTime) {
        this.scheduleFor(nanoTime, 1);
    }

    public void scheduleForNow(int power) {
        this.scheduleFor(System.nanoTime(), power);
    }

    public void scheduleWithDelay(long delay, TimeUnit unit, int power) {
        if (delay < 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleFor(System.nanoTime() + unit.toNanos(delay), power);
    }

    public void scheduleWithDelay(long delay, TimeUnit unit) {
        if (delay < 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleFor(System.nanoTime() + unit.toNanos(delay), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow() {
        boolean inRealm;
        try {
            inRealm = Thread.currentThread() == this.display.getThread();
        }
        catch (RuntimeException e) {
            this.handleScheduleException(e);
            return;
        }
        if (inRealm) {
            ScheduledDisplayRunnable scheduledDisplayRunnable = this;
            synchronized (scheduledDisplayRunnable) {
                if (this.state == -1) {
                    return;
                }
                this.state = 0;
            }
            this.execute();
        } else {
            this.scheduleFor(System.nanoTime(), Integer.MAX_VALUE);
        }
    }

    public synchronized void cancel() {
        if (this.state == -1) {
            return;
        }
        this.state = 0;
    }

    public synchronized void stop() {
        this.state = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ScheduledDisplayRunnable scheduledDisplayRunnable = this;
        synchronized (scheduledDisplayRunnable) {
            this.scheduled = 0;
            if (this.state <= 0) {
                return;
            }
            long remaining = this.scheduledTime - System.nanoTime();
            if (remaining > 2000000L) {
                this.scheduled = (byte)2;
                this.display.timerExec((int)((remaining + 400000L) / 1000000L), (Runnable)this);
                return;
            }
            this.state = 0;
        }
        this.execute();
    }

    protected abstract void execute();

    protected void handleScheduleException(RuntimeException e) throws RuntimeException {
        if (!(e instanceof SWTException) || ((SWTException)e).code != 45) {
            throw e;
        }
        this.stop();
    }
}

