/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

@NonNullByDefault
public class ToggleBooleanPreferenceHandler
extends AbstractHandler
implements IElementUpdater,
IEclipsePreferences.IPreferenceChangeListener {
    private final Preference<Boolean> pref;
    private final PreferenceAccess prefAccess;
    private boolean isPrefEnabled;
    private final @Nullable String commandId;

    public ToggleBooleanPreferenceHandler(Preference<@NonNull Boolean> pref, @Nullable String commandId) {
        this(pref, EPreferences.getInstancePrefs(), commandId);
    }

    public ToggleBooleanPreferenceHandler(Preference<@NonNull Boolean> pref, PreferenceAccess access, @Nullable String commandId) {
        this.pref = pref;
        this.prefAccess = access;
        this.commandId = commandId;
        this.prefAccess.addPreferenceNodeListener(this.pref.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
        this.isPrefEnabled = (Boolean)this.prefAccess.getPreferenceValue(this.pref);
        this.setBaseEnabled(true);
    }

    protected final boolean isPrefEnabled() {
        return this.isPrefEnabled;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        boolean isEnabled;
        if (this.pref.getKey().equals(event.getKey()) && (isEnabled = ((Boolean)this.prefAccess.getPreferenceValue(this.pref)).booleanValue()) != this.isPrefEnabled) {
            this.isPrefEnabled = isEnabled;
            this.handleToggled(isEnabled);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            if (this.commandId != null && commandService != null) {
                WorkbenchUIUtils.refreshCommandElements(this.commandId, (IHandler2)this, null);
            }
        }
    }

    protected void handleToggled(boolean isEnabled) {
    }

    public void dispose() {
        this.prefAccess.removePreferenceNodeListener(this.pref.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    public void updateElement(UIElement element, Map parameters) {
        WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, element);
        try {
            element.setChecked(this.isPrefEnabled);
        }
        finally {
            WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
        }
    }

    public @Nullable Object execute(ExecutionEvent arg0) throws ExecutionException {
        PreferenceUtils.setPrefValue((IScopeContext)((IScopeContext)this.prefAccess.getPreferenceContexts().getFirst()), this.pref, (Object)(!this.isPrefEnabled ? 1 : 0), (int)2);
        return null;
    }
}

