/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.eclient.graphics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.statet.ecommons.ui.swt.AutoDisposeReference;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.rj.eclient.graphics.CircleElement;
import org.eclipse.statet.internal.rj.eclient.graphics.ClipSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.ColorManager;
import org.eclipse.statet.internal.rj.eclient.graphics.ColorSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.EclipseRGraphicFactory;
import org.eclipse.statet.internal.rj.eclient.graphics.FillSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.FontManager;
import org.eclipse.statet.internal.rj.eclient.graphics.FontSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.GraphicInitialization;
import org.eclipse.statet.internal.rj.eclient.graphics.LineElement;
import org.eclipse.statet.internal.rj.eclient.graphics.LineSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.PathElement;
import org.eclipse.statet.internal.rj.eclient.graphics.PolygonElement;
import org.eclipse.statet.internal.rj.eclient.graphics.PolylineElement;
import org.eclipse.statet.internal.rj.eclient.graphics.RasterElement;
import org.eclipse.statet.internal.rj.eclient.graphics.RectElement;
import org.eclipse.statet.internal.rj.eclient.graphics.TextElement;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusChangeListener;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.eclient.graphics.DefaultGCRenderer;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicInstruction;
import org.eclipse.statet.rj.eclient.graphics.LocatorCallback;
import org.eclipse.statet.rj.eclient.graphics.comclient.ToolRClientGraphicActions;
import org.eclipse.statet.rj.graphic.core.RGraphic;
import org.eclipse.statet.rj.graphic.core.RGraphicInitialization;
import org.eclipse.statet.rj.graphic.core.util.CachedMapping;
import org.eclipse.statet.rj.graphic.core.util.CharMapping;
import org.eclipse.statet.rj.graphic.core.util.Unicode2AdbSymbolMapping;
import org.eclipse.statet.rj.server.client.RClientGraphic;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.RServiceControlExtension;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class EclipseRGraphic
implements RClientGraphic,
ERGraphic {
    private static final CharMapping ADBSYMBOL_MAPPING = new CachedMapping((CharMapping)new Unicode2AdbSymbolMapping());
    private static final int DIRECT_RED_MASK = 65280;
    private static final int DIRECT_GREEN_MASK = 0xFF0000;
    private static final int DIRECT_BLUE_MASK = -16777216;
    private static final PaletteData DIRECT_PALETTE = new PaletteData(65280, 0xFF0000, -16777216);
    private static final long NOT_SET = 0L;
    private static final LocatorCallback R_LOCATOR_CALLBACK = new LocatorCallback(){

        @Override
        public String getMessage() {
            return "\u2192 Locate a point by mouse click (request from R)";
        }

        @Override
        public int located(double x, double y) {
            return 1;
        }

        @Override
        public void stopped(String type) {
        }
    };
    private final int devId;
    private int canvasColor;
    private final long drawingStopDelay = 33000000L;
    private final long drawingForceDelay = 333000000L;
    private final EclipseRGraphicFactory manager;
    private boolean isRClosed;
    private boolean isLocalClosed;
    private final Object stateLock = new Object();
    private boolean isActive;
    private boolean isActiveNotified;
    private int mode = 1;
    private int modeNotified;
    private long drawingStoppedTime;
    private long instructionsNotifiedTime;
    private boolean stateNotificationDirectScheduled;
    private boolean stateNotificationDelayedScheduled;
    private final Runnable stateNotificationRunnable = new Runnable(){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [31[UNCONDITIONALDOLOOP]], but top level block is 11[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };
    private final int options;
    private final ToolRClientGraphicActions actions;
    private volatile double[] nextSize;
    private double[] size;
    private FontManager.FontFamily currentFontFamily;
    private int currentFontSize;
    private int currentFontStyle;
    private int currentFontRFace;
    private CharMapping currentFontMapping;
    private String lastStringEnc;
    private double[] lastStringWidth;
    private final Display display;
    private boolean isDisposed;
    private final FontManager swtFontManager;
    private final ColorManager swtColorManager;
    private String serifFontName;
    private String sansFontName;
    private String monoFontName;
    private String symbolFontName;
    private CharMapping symbolFontMapping;
    private ERGraphicInstruction[] instructionsNew = new ERGraphicInstruction[1];
    private int instructionsNewSize;
    private ERGraphicInstruction[] instructionsUpdate;
    private int instructionsUpdateStart;
    private int instructionsUpdateSize;
    private final Object instructionsLock = new Object();
    private ERGraphicInstruction[] instructions;
    private int instructionsSize;
    private final Object userExchangeLock = new Object();
    private String userExchangeRType;
    private RServiceControlExtension userExchangeRCallback;
    private volatile LocatorCallback locatorCallback;
    private LocatorCallback locatorNotified;
    private Status locatorMessage;
    private Collection<String> locatorStopTypes = Collections.emptySet();
    private double[] locatorLocationValue;
    private final Object locatorAnswerLock = new Object();
    private final CopyOnWriteIdentityListSet<RGraphic.Listener> graphicListeners = new CopyOnWriteIdentityListSet();
    private Status message = Status.OK_STATUS;
    private final CopyOnWriteIdentityListSet<StatusChangeListener> messageListeners = new CopyOnWriteIdentityListSet();
    private boolean locatorNotificationDirectScheduled;
    private boolean locatorNotificationDeferredScheduled;
    private long locatorDeferredTime = 0L;
    private final Runnable locatorNotificationRunnable = new Runnable(){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };

    private static final long toTime(long time) {
        return time != 0L ? time : 1L;
    }

    private static void disposeElements(ERGraphicInstruction[] instructions, int beginIdx, int endIdx) {
        block7: {
            try {
                int i = beginIdx;
                while (i < endIdx) {
                    switch (instructions[i].getInstructionType()) {
                        case 12: {
                            Image image = ((RasterElement)instructions[i]).swtImage;
                            if (image == null) break;
                            image.dispose();
                            break;
                        }
                        case 13: {
                            Path path = ((PathElement)instructions[i]).swtPath;
                            if (path == null) break;
                            path.dispose();
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (SWTException e) {
                if (e.code == 45) break block7;
                CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.eclient.graphics", "An error occurred when disposing SWT resources.", (Throwable)e));
            }
        }
    }

    public EclipseRGraphic(int devId, double w, double h, RClientGraphic.InitConfig config, boolean active, ToolRClientGraphicActions actions, int options, EclipseRGraphicFactory manager) {
        this.devId = devId;
        this.isActive = active;
        this.actions = actions;
        this.manager = manager;
        this.options = options;
        this.display = UIAccess.getDisplay();
        this.swtFontManager = manager.getFontManager(this.display);
        this.swtColorManager = manager.getColorManager(this.display);
        this.nextSize = new double[]{w, h};
        this.size = this.nextSize;
        this.initPanel(w, h, config);
    }

    @Override
    public String getLabel() {
        String rLabel;
        StringBuilder sb = new StringBuilder();
        sb.append("Device ");
        sb.append(this.devId + 1);
        if (this.actions != null && (rLabel = this.actions.getRLabel()) != null && rLabel.length() > 0) {
            sb.append(" \u2502 ");
            sb.append(rLabel);
        }
        boolean locator = this.isLocatorStarted();
        if (this.isActive || locator) {
            sb.append(" \t<");
            if (this.isActive) {
                sb.append("active+");
            }
            if (locator) {
                sb.append("locator+");
            }
            sb.replace(sb.length() - 1, sb.length(), ">");
        }
        return sb.toString();
    }

    private void add(ERGraphicInstruction instr) {
        if (this.instructionsNew == null) {
            this.instructionsNew = new ERGraphicInstruction[512];
        } else if (this.instructionsNewSize >= this.instructionsNew.length) {
            ERGraphicInstruction[] newArray = new ERGraphicInstruction[this.instructionsNewSize + 512];
            System.arraycopy(this.instructionsNew, 0, newArray, 0, this.instructionsNewSize);
            this.instructionsNew = newArray;
        }
        this.instructionsNew[this.instructionsNewSize] = instr;
        ++this.instructionsNewSize;
    }

    protected void initPanel(double w, double h, RClientGraphic.InitConfig config) {
        this.currentFontFamily = null;
        this.currentFontMapping = null;
        IPreferencesService preferences = Platform.getPreferencesService();
        this.serifFontName = preferences.getString("org.eclipse.statet.rj.eclient.graphics/fonts", "serif.name", "", null);
        this.sansFontName = preferences.getString("org.eclipse.statet.rj.eclient.graphics/fonts", "sans.name", "", null);
        this.monoFontName = preferences.getString("org.eclipse.statet.rj.eclient.graphics/fonts", "mono.name", "", null);
        if (preferences.getBoolean("org.eclipse.statet.rj.eclient.graphics/fonts", "symbol.use", true, null)) {
            this.symbolFontName = preferences.getString("org.eclipse.statet.rj.eclient.graphics/fonts", "symbol.name", "Symbol", null);
            String encoding = preferences.getString("org.eclipse.statet.rj.eclient.graphics/fonts", "symbol.enc", "AdobeSymbol", null);
            this.symbolFontMapping = "AdobeSymbol".equals(encoding) ? ADBSYMBOL_MAPPING : null;
        } else {
            this.symbolFontName = null;
            this.symbolFontMapping = null;
        }
        this.canvasColor = config.canvasColor & 0xFFFFFF;
        this.add(new GraphicInitialization(w, h, this.canvasColor, this.swtColorManager.getColor(this.canvasColor)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(double w, double h, RClientGraphic.InitConfig config) {
        Object object = this.stateLock;
        synchronized (object) {
            this.internalReset();
        }
        this.initPanel(w, h, config);
    }

    private void internalReset() {
        if (this.instructionsNew != null) {
            if (this.instructionsNewSize > 0) {
                EclipseRGraphic.disposeElements(this.instructionsNew, 0, this.instructionsNewSize);
            }
            this.instructionsNew = null;
            this.instructionsNewSize = 0;
        }
        if (this.instructionsUpdate != null) {
            if (this.instructionsUpdateSize > 0) {
                EclipseRGraphic.disposeElements(this.instructionsUpdate, this.instructionsUpdateStart, this.instructionsUpdateStart + this.instructionsUpdateSize);
            }
            this.instructionsUpdate = null;
            this.instructionsUpdateStart = 0;
            this.instructionsUpdateSize = 0;
        }
        this.drawingStoppedTime = System.nanoTime();
        this.instructionsNotifiedTime = this.drawingStoppedTime - 1000000000L;
    }

    private void execInDisplay(Runnable runnable) {
        block2: {
            try {
                this.display.asyncExec(runnable);
            }
            catch (SWTException e) {
                if (e.code == 45) break block2;
                throw e;
            }
        }
    }

    private void scheduleInDisplay(Runnable runnable, long nanos) {
        this.display.timerExec((int)((nanos + 400000L) / 1000000L), runnable);
    }

    @Override
    public int getDevId() {
        return this.devId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        if (this.isActive == active) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.isActive = active;
            if (this.isDisposed) {
                return;
            }
            if (!this.stateNotificationDirectScheduled) {
                this.stateNotificationDirectScheduled = true;
                this.execInDisplay(this.stateNotificationRunnable);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.mode == mode) {
                return;
            }
            if (mode != 1) {
                this.drawingStoppedTime = System.nanoTime();
                this.flushNewInstructions();
            }
            this.mode = mode;
            if (this.isDisposed) {
                return;
            }
            if (mode == 1 && this.modeNotified != 1 && !this.stateNotificationDirectScheduled) {
                this.stateNotificationDirectScheduled = true;
                this.execInDisplay(this.stateNotificationRunnable);
            } else if (mode != 1 && !this.stateNotificationDirectScheduled && !this.stateNotificationDelayedScheduled) {
                this.stateNotificationDirectScheduled = true;
                this.execInDisplay(this.stateNotificationRunnable);
            }
        }
    }

    private void flushNewInstructions() {
        if (this.instructionsNewSize > 0) {
            if (this.instructionsUpdate == null) {
                this.instructionsUpdate = this.instructionsNew;
                this.instructionsUpdateStart = 0;
                this.instructionsUpdateSize = this.instructionsNewSize;
                this.instructionsNew = null;
                this.instructionsNewSize = 0;
            } else {
                int newSize = this.instructionsUpdateStart + this.instructionsUpdateSize + this.instructionsNewSize;
                if (newSize > this.instructionsUpdate.length) {
                    ERGraphicInstruction[] newArray = new ERGraphicInstruction[newSize + 512];
                    System.arraycopy(this.instructionsUpdate, 0, newArray, 0, this.instructionsUpdateStart + this.instructionsUpdateSize);
                    this.instructionsUpdate = newArray;
                }
                System.arraycopy(this.instructionsNew, 0, this.instructionsUpdate, this.instructionsUpdateStart + this.instructionsUpdateSize, this.instructionsNewSize);
                this.instructionsUpdateSize += this.instructionsNewSize;
                this.instructionsNewSize = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ERGraphicInstruction> getCurrentInstructions() {
        Object object = this.stateLock;
        synchronized (object) {
            this.flushNewInstructions();
            return ImCollections.newList((Object[])this.instructionsUpdate).subList(0, this.instructionsSize + this.instructionsUpdateSize);
        }
    }

    public double[] computeSize() {
        return this.size;
    }

    protected void printFont() {
        System.out.println(this.currentFontFamily.name + " " + this.currentFontStyle + " " + this.currentFontSize);
    }

    public double[] computeFontMetric(int ch) {
        return this.currentFontFamily.getCharMetrics(this.currentFontStyle, this.currentFontSize, this.currentFontMapping != null ? this.currentFontMapping.encode(ch) : ch);
    }

    public double[] computeStringWidth(String txt) {
        return this.computeStringWidthEnc(this.currentFontMapping != null ? this.currentFontMapping.encode(txt) : txt);
    }

    protected final double[] computeStringWidthEnc(String text) {
        if (text.equals(this.lastStringEnc)) {
            return this.lastStringWidth;
        }
        double[] answer = this.currentFontFamily.getStringWidth(this.currentFontStyle, this.currentFontSize, text);
        this.lastStringEnc = text;
        this.lastStringWidth = answer;
        return answer;
    }

    public void addSetClip(double x0, double y0, double x1, double y1) {
        ClipSetting instr = new ClipSetting(x0, y0, x1, y1);
        this.add(instr);
    }

    public void addSetColor(int color) {
        ColorSetting instr = new ColorSetting(color, this.swtColorManager.getColor(color & 0xFFFFFF));
        this.add(instr);
    }

    public void addSetFill(int color) {
        FillSetting instr = new FillSetting(color, this.swtColorManager.getColor(color & 0xFFFFFF));
        this.add(instr);
    }

    public void addSetFont(String family, int face, float pointSize, float lineHeight) {
        switch (face) {
            case 2: 
            case 3: 
            case 4: {
                family = this.getFontName(family);
                this.currentFontStyle = face - 1;
                this.currentFontMapping = null;
                break;
            }
            case 5: {
                if (this.symbolFontName != null) {
                    family = this.symbolFontName;
                    this.currentFontStyle = 0;
                    this.currentFontMapping = this.symbolFontMapping;
                    break;
                }
            }
            default: {
                family = this.getFontName(family);
                this.currentFontStyle = 0;
                this.currentFontMapping = null;
            }
        }
        this.currentFontFamily = this.swtFontManager.getFamily(family);
        this.currentFontRFace = face;
        this.currentFontSize = (int)((double)pointSize + 0.5);
        this.lastStringEnc = null;
        FontSetting instr = new FontSetting(family, face, pointSize, lineHeight, this.currentFontFamily.getSWTFont(this.currentFontStyle, this.currentFontSize), this.currentFontFamily.getSWTFontProperties(this.currentFontStyle, this.currentFontSize));
        this.add(instr);
    }

    private String getFontName(String family) {
        if (family.isEmpty() || family.equals("sansserif")) {
            return this.sansFontName;
        }
        if (family.equals("serif")) {
            return this.serifFontName;
        }
        if (family.equals("mono")) {
            return this.monoFontName;
        }
        return family;
    }

    public void addSetLine(int type, float width, byte cap, byte join, float joinMiterLimit) {
        LineSetting instr = new LineSetting(type, width, cap, join, joinMiterLimit);
        this.add(instr);
    }

    public void addDrawLine(double x0, double y0, double x1, double y1) {
        LineElement instr = new LineElement(x0, y0, x1, y1);
        this.add(instr);
    }

    public void addDrawRect(double x0, double y0, double x1, double y1) {
        RectElement instr = new RectElement(x0, y0, x1, y1);
        this.add(instr);
    }

    public void addDrawPolyline(double[] x, double[] y) {
        PolylineElement instr = new PolylineElement(x, y);
        this.add(instr);
    }

    public void addDrawPolygon(double[] x, double[] y) {
        PolygonElement instr = new PolygonElement(x, y);
        this.add(instr);
    }

    public void addDrawPath(int[] n, double[] x, double[] y, int winding) {
        Path path = new Path((Device)this.display);
        int k = 0;
        int end = 0;
        int i = 0;
        while (i < n.length) {
            end += n[i];
            path.moveTo((float)Math.floor(x[k] + 0.5), (float)Math.floor(y[k++] + 0.5));
            while (k < end) {
                path.lineTo((float)Math.floor(x[k] + 0.5), (float)Math.floor(y[k++] + 0.5));
            }
            path.close();
            ++i;
        }
        PathElement instr = new PathElement(n, x, y, winding, path);
        this.add(instr);
    }

    public void addDrawCircle(double x, double y, double r) {
        CircleElement instr = new CircleElement(x, y, r);
        this.add(instr);
    }

    public void addDrawText(String txt, double x, double y, double rDeg, double hAdj) {
        String text = this.currentFontMapping != null ? this.currentFontMapping.encode(txt) : txt;
        TextElement instr = new TextElement(text, x, y, rDeg, hAdj, hAdj != 0.0 ? this.computeStringWidthEnc(text)[0] : 0.0);
        this.add(instr);
    }

    public void addDrawRaster(byte[] imgData, boolean hasAlpha, int imgWidth, int imgHeight, double x, double y, double w, double h, double rDeg, boolean interpolate) {
        ImageData imageData = new ImageData(imgWidth, imgHeight, 32, DIRECT_PALETTE, 4, imgData);
        if (hasAlpha) {
            byte[] alpha = new byte[imgWidth * imgHeight];
            int i = 0;
            while (i < alpha.length) {
                alpha[i] = imgData[i * 4 + 3];
                ++i;
            }
            imageData.alphaData = alpha;
        }
        Image swtImage = new Image((Device)this.display, imageData);
        RasterElement instr = new RasterElement(imgData, imgWidth, imgHeight, x, y, w, h, rDeg, interpolate, swtImage);
        this.add(instr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] capture(int width, int height) {
        ImageData imageData;
        Throwable throwable = null;
        Object var5_5 = null;
        try (AutoDisposeReference managedImage = AutoDisposeReference.autoDispose((Resource)new Image((Device)this.display, width, height));){
            DefaultGCRenderer renderer = new DefaultGCRenderer();
            List<ERGraphicInstruction> instructions = this.getCurrentInstructions();
            if (instructions.isEmpty()) {
                return null;
            }
            RGraphicInitialization init = (RGraphicInitialization)instructions.get(0);
            double scale = width == (int)(init.width + 0.5) ? 1.0 : (double)width / init.width;
            renderer.clear(scale);
            GC gc = new GC((Drawable)managedImage.get());
            try {
                renderer.paint(gc, instructions);
            }
            finally {
                gc.dispose();
            }
            imageData = ((Image)managedImage.get()).getImageData();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
        if (imageData == null) return null;
        if (!imageData.palette.isDirect) {
            return null;
        }
        if (imageData.palette.redMask == 65280 && imageData.palette.greenMask == 0xFF0000 && imageData.palette.blueMask == -16777216 && imageData.scanlinePad == 4 && imageData.bytesPerLine == width * 4) {
            if (imageData.data.length == width * height * 4) return imageData.data;
        }
        byte[] data = imageData.data.length == width * height * 4 ? imageData.data : new byte[width * height * 4];
        int blueMask = imageData.palette.blueMask;
        int blueShift = imageData.palette.blueShift;
        int greenMask = imageData.palette.greenMask;
        int greenShift = imageData.palette.greenShift;
        int redMask = imageData.palette.redMask;
        int redShift = imageData.palette.redShift;
        int i = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int p = imageData.getPixel(x, y);
                data[i++] = blueShift < 0 ? (byte)((p & blueMask) >>> -blueShift) : (byte)((p & blueMask) << blueShift);
                data[i++] = greenShift < 0 ? (byte)((p & greenMask) >>> -greenShift) : (byte)((p & greenMask) << greenShift);
                data[i++] = redShift < 0 ? (byte)((p & redMask) >>> -redShift) : (byte)((p & redMask) << redShift);
                data[i++] = -1;
                ++x;
            }
            ++y;
        }
        return data;
    }

    /*
     * Exception decompiling
     */
    protected void waitRUserExchange(String type, RService r, ProgressMonitor m, Callable<Boolean> cancelListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void internalStartLocator(LocatorCallback callback) {
        this.locatorCallback = callback;
        this.locatorMessage = new InfoStatus("org.eclipse.statet.rj.eclient.graphics", callback.getMessage());
        this.locatorStopTypes = callback.getStopTypes();
        this.locatorDeferredTime = 0L;
        if (this.display.isDisposed()) {
            return;
        }
        if (!this.locatorNotificationDirectScheduled) {
            this.execInDisplay(this.locatorNotificationRunnable);
        }
    }

    private void internalStopLocator(boolean deferred) {
        if (deferred) {
            this.locatorDeferredTime = EclipseRGraphic.toTime(System.nanoTime() + 500000000L);
            if (this.display.isDisposed()) {
                return;
            }
            if (!this.locatorNotificationDirectScheduled && !this.locatorNotificationDeferredScheduled) {
                this.locatorNotificationDirectScheduled = true;
                this.execInDisplay(this.locatorNotificationRunnable);
            }
            return;
        }
        this.locatorCallback = null;
        this.locatorMessage = null;
        this.locatorStopTypes = Collections.emptySet();
        this.locatorDeferredTime = 0L;
        if (this.display.isDisposed()) {
            return;
        }
        if (!this.locatorNotificationDirectScheduled) {
            this.locatorNotificationDirectScheduled = true;
            this.execInDisplay(this.locatorNotificationRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] runRLocator(RService r, ProgressMonitor m) {
        double[] value;
        Object object = this.userExchangeLock;
        synchronized (object) {
            block8: {
                if (this.locatorCallback == null || this.locatorCallback == R_LOCATOR_CALLBACK) break block8;
                return null;
            }
            this.userExchangeRType = "locator";
            this.internalStartLocator(R_LOCATOR_CALLBACK);
            this.locatorLocationValue = null;
        }
        this.waitRUserExchange("locator", r, m, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return EclipseRGraphic.this.answerLocator(null, null, true);
            }
        });
        Object object2 = this.userExchangeLock;
        synchronized (object2) {
            value = this.locatorLocationValue;
            if (this.userExchangeRType == "locator") {
                this.userExchangeRType = null;
            }
            this.internalStopLocator(value != null);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status startLocalLocator(LocatorCallback callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        Object object = this.userExchangeLock;
        synchronized (object) {
            if (this.locatorCallback != null && this.locatorCallback != callback) {
                return new ErrorStatus("org.eclipse.statet.rj.eclient.graphics", "Another locator is already started.");
            }
            this.internalStartLocator(callback);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isLocatorStarted() {
        return this.locatorCallback != null;
    }

    @Override
    public Collection<String> getLocatorStopTypes() {
        return this.locatorStopTypes;
    }

    @Override
    public void returnLocator(double x, double y) {
        this.answerLocator(null, new double[]{x, y}, false);
    }

    @Override
    public void stopLocator(String type) {
        this.answerLocator(type, null, false);
    }

    /*
     * Exception decompiling
     */
    private boolean answerLocator(String type, double[] xy, boolean onlyR) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closeFromR() {
        this.isRClosed = true;
        if (this.isLocalClosed || (this.options & 0x10) == 0) {
            this.dispose();
        }
        this.answerLocator(null, null, true);
        this.setActive(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        this.graphicListeners.clear();
        DisposeRunnable runnable = null;
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isDisposed) {
                this.isDisposed = true;
                this.internalReset();
                Object object2 = this.instructionsLock;
                synchronized (object2) {
                    if (this.instructionsSize > 0) {
                        runnable = new DisposeRunnable(this.instructions, this.instructionsSize);
                    }
                    this.instructionsSize = 0;
                    this.instructions = null;
                }
            }
        }
        if (runnable != null) {
            this.execInDisplay(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ERGraphicInstruction> getInstructions() {
        Object object = this.instructionsLock;
        synchronized (object) {
            return this.instructionsSize > 0 ? ImCollections.newList((Object[])this.instructions).subList(0, this.instructionsSize) : ImCollections.emptyList();
        }
    }

    @Override
    public @Nullable RTool getRHandle() {
        if (this.actions != null) {
            return this.actions.getRHandle();
        }
        return null;
    }

    @Override
    public Status resize(double w, double h) {
        if (this.actions != null) {
            this.nextSize = new double[]{w, h};
            return this.actions.resizeGraphic(this.devId, new Runnable(){

                @Override
                public void run() {
                    EclipseRGraphic.this.size = EclipseRGraphic.this.nextSize;
                }
            });
        }
        return null;
    }

    @Override
    public Status close() {
        if (this.isRClosed) {
            this.isLocalClosed = true;
            this.dispose();
        }
        if (this.actions != null) {
            this.answerLocator(null, null, false);
            return this.actions.closeGraphic(this.devId);
        }
        this.isLocalClosed = true;
        this.answerLocator(null, null, false);
        this.manager.close(this);
        this.dispose();
        return null;
    }

    public void addListener(RGraphic.Listener listener) {
        this.graphicListeners.add((Object)((RGraphic.Listener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeListener(RGraphic.Listener listener) {
        this.graphicListeners.remove((Object)listener);
    }

    protected void updateMessage() {
        Status message = this.locatorMessage != null ? this.locatorMessage : Status.OK_STATUS;
        if (!this.message.equals(message)) {
            this.message = message;
            for (StatusChangeListener listener : this.messageListeners) {
                listener.onStatusChanged(message);
            }
        }
    }

    @Override
    public Status getMessage() {
        return this.message;
    }

    @Override
    public void addMessageListener(StatusChangeListener listener) {
        this.messageListeners.add((Object)((StatusChangeListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    @Override
    public void removeMessageListener(StatusChangeListener listener) {
        this.messageListeners.remove((Object)listener);
    }

    protected void preAction() throws StatusException {
        if (this.actions == null || this.actions.getRHandle() == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isRClosed) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.eclient.graphics", "The R graphic device is already closed."));
        }
    }

    @Override
    public void copy(String toDev, String toDevFile, String toDevArgs, ProgressMonitor m) throws StatusException {
        this.preAction();
        this.actions.copy(this.devId, toDev, toDevFile, toDevArgs, m);
    }

    @Override
    public double[] convertGraphic2User(double[] xy, ProgressMonitor m) throws StatusException {
        this.preAction();
        return this.actions.convertGraphic2User(this.devId, xy, m);
    }

    @Override
    public double[] convertUser2Graphic(double[] xy, ProgressMonitor m) throws StatusException {
        this.preAction();
        return this.actions.convertUser2Graphic(this.devId, xy, m);
    }

    private static class DisposeRunnable
    implements Runnable {
        private final ERGraphicInstruction[] instructions;
        private final int size;
        private boolean delay;

        public DisposeRunnable(ERGraphicInstruction[] instructions, int size) {
            this.instructions = instructions;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.delay) {
                this.delay = false;
                Display.getCurrent().timerExec(5000, (Runnable)this);
            }
            EclipseRGraphic.disposeElements(this.instructions, 0, this.size);
        }
    }
}

