/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.WorkingBuffer;

@NonNullByDefault
public abstract class GenericUriSourceUnit
implements SourceUnit {
    private final String id;
    private final ElementName name;
    private final IFileStore fileStore;
    private WorkingBuffer buffer;
    private int counter = 0;

    public GenericUriSourceUnit(String id, IFileStore fileStore) {
        this.id = id;
        this.name = new ElementName(){

            @Override
            public int getType() {
                return 17;
            }

            @Override
            public String getDisplayName() {
                return GenericUriSourceUnit.this.fileStore.toString();
            }

            @Override
            public String getSegmentName() {
                return GenericUriSourceUnit.this.id;
            }

            @Override
            public @Nullable ElementName getNextSegment() {
                return null;
            }
        };
        this.fileStore = (IFileStore)ObjectUtils.nonNullAssert((Object)fileStore);
    }

    @Override
    public @Nullable SourceUnit getUnderlyingUnit() {
        return null;
    }

    @Override
    public boolean isSynchronized() {
        return this.buffer.isSynchronized();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getElementType() {
        return 528;
    }

    @Override
    public ElementName getElementName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.counter > 0;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return this.buffer.checkState(validate, monitor);
    }

    @Override
    public Object getResource() {
        return this.fileStore;
    }

    @Override
    public AbstractDocument getDocument(@Nullable IProgressMonitor monitor) {
        return this.buffer.getDocument(monitor);
    }

    @Override
    public long getContentStamp(@Nullable IProgressMonitor monitor) {
        return this.buffer.getContentStamp(monitor);
    }

    @Override
    public SourceContent getContent(IProgressMonitor monitor) {
        return this.buffer.getContent(monitor);
    }

    @Override
    public @Nullable AstInfo getAstInfo(@Nullable String type, boolean ensureSync, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public @Nullable SourceUnitModelInfo getModelInfo(@Nullable String type, int syncLevel, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
        if (this.counter == 1) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            if (this.buffer == null) {
                m.setWorkRemaining(2);
                this.buffer = this.createWorkingBuffer(m.newChild(1));
            }
            this.register();
        }
    }

    @Override
    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
        if (this.counter == 0) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            this.buffer.releaseDocument((IProgressMonitor)m.newChild(1));
            this.unregister();
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    protected abstract WorkingBuffer createWorkingBuffer(SubMonitor var1);

    protected void register() {
    }

    protected void unregister() {
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == IFileStore.class) {
            return (T)this.fileStore;
        }
        if (adapterType == PreferenceAccess.class) {
            return (T)EPreferences.getInstancePrefs();
        }
        return null;
    }

    public String toString() {
        return this.getModelTypeId() + "/" + String.valueOf(this.getWorkingContext()) + ": " + this.getId();
    }
}

