/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.statet.internal.ltk.core.LtkCorePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.impl.WorkingBuffer;

@NonNullByDefault
public class BasicWorkingBuffer
implements WorkingBuffer {
    protected static final byte IFILE = 1;
    protected static final byte FILESTORE = 2;
    protected static final byte DOCUMENT = 1;
    protected final SourceUnit unit;
    private @Nullable AbstractDocument document;
    private byte mode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SourceContent createContentFromDocument(IDocument doc) {
        Object lock = null;
        if (doc instanceof ISynchronizable) {
            lock = ((ISynchronizable)doc).getLockObject();
        }
        if (lock != null && doc instanceof IDocumentExtension4) {
            Object object = lock;
            synchronized (object) {
                return new SourceContent(((IDocumentExtension4)doc).getModificationStamp(), doc.get());
            }
        }
        return new SourceContent(System.currentTimeMillis(), doc.get());
    }

    public BasicWorkingBuffer(SourceUnit unit) {
        this.unit = unit;
    }

    protected final byte detectResourceMode() {
        if (this.mode == 0) {
            Object resource = this.unit.getResource();
            if (resource instanceof IFile) {
                this.mode = 1;
            } else if (resource instanceof IFileStore && !((IFileStore)resource).fetchInfo().isDirectory()) {
                this.mode = (byte)2;
            }
            if (this.mode == 0) {
                this.mode = (byte)-1;
            }
        }
        return this.mode;
    }

    protected final byte getResourceMode() {
        return this.mode;
    }

    protected byte getContentMode() {
        return 0;
    }

    @Override
    public long getContentStamp(@Nullable IProgressMonitor monitor) {
        IFile resource;
        AbstractDocument doc = this.document;
        if (doc != null) {
            return doc.getModificationStamp();
        }
        SourceUnit underlyingUnit = this.unit.getUnderlyingUnit();
        if (underlyingUnit != null) {
            return underlyingUnit.getContentStamp(monitor);
        }
        if (this.detectResourceMode() == 1 && (resource = (IFile)this.unit.getResource()) != null) {
            return resource.getModificationStamp();
        }
        return 0L;
    }

    @Override
    public synchronized @Nullable AbstractDocument getDocument() {
        return this.document;
    }

    @Override
    public synchronized AbstractDocument getDocument(@Nullable IProgressMonitor monitor) {
        AbstractDocument doc = this.document;
        if (doc == null) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
            doc = this.createDocument(m);
            this.checkDocument(doc);
            if ((this.getContentMode() & 1) != 0) {
                this.document = doc;
            }
        }
        return doc;
    }

    @Override
    public SourceContent getContent(IProgressMonitor monitor) {
        AbstractDocument doc;
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        AbstractDocument abstractDocument = doc = (this.getContentMode() & 1) != 0 ? this.getDocument((IProgressMonitor)m) : this.getDocument();
        if (doc != null) {
            return BasicWorkingBuffer.createContentFromDocument((IDocument)doc);
        }
        try {
            return this.createContent(m);
        }
        catch (CoreException e) {
            LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", String.format("An error occured when loading the content for '%1$s'.", this.unit), (Throwable)e));
            return new SourceContent(0L, "");
        }
    }

    @Override
    public void saveDocument(IProgressMonitor monitor) {
    }

    @Override
    public synchronized void releaseDocument(IProgressMonitor monitor) {
        this.document = null;
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        SourceUnit underlyingUnit = this.unit.getUnderlyingUnit();
        if (underlyingUnit != null) {
            return underlyingUnit.checkState(validate, monitor);
        }
        switch (this.detectResourceMode()) {
            case 1: {
                IFile resource = (IFile)this.unit.getResource();
                if (!validate) {
                    return !resource.getResourceAttributes().isReadOnly();
                }
                return resource.getWorkspace().validateEdit(new IFile[]{resource}, IWorkspace.VALIDATE_PROMPT).isOK();
            }
            case 2: {
                IFileStore store = (IFileStore)this.unit.getResource();
                try {
                    return !store.fetchInfo(0, monitor).getAttribute(2);
                }
                catch (CoreException e) {
                    LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", 0, "An error occurred when checking modifiable state of the file.", (Throwable)e));
                    return false;
                }
            }
        }
        return false;
    }

    protected @Nullable AbstractDocument createDocument(SubMonitor m) {
        IDocument fileDoc = this.createEmptyDocument();
        if (!(fileDoc instanceof AbstractDocument)) {
            return null;
        }
        AbstractDocument document = (AbstractDocument)fileDoc;
        try {
            SourceContent content = this.createContent(m);
            document.set(content.getString(), content.getStamp());
        }
        catch (CoreException e) {
            LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", String.format("An error occured when loading the content for '%1$s'.", this.unit), (Throwable)e));
        }
        return document;
    }

    private IDocument createEmptyDocument() {
        switch (this.detectResourceMode()) {
            case 1: {
                return FileBuffers.getTextFileBufferManager().createEmptyDocument(((IFile)this.unit.getResource()).getFullPath(), LocationKind.IFILE);
            }
            case 2: {
                return FileBuffers.getTextFileBufferManager().createEmptyDocument(URIUtil.toPath((URI)((IFileStore)this.unit.getResource()).toURI()), LocationKind.LOCATION);
            }
        }
        return FileBuffers.getTextFileBufferManager().createEmptyDocument(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDocument(AbstractDocument document) {
        if (document instanceof ISynchronizable) {
            AbstractDocument abstractDocument = document;
            synchronized (abstractDocument) {
                if (((ISynchronizable)document).getLockObject() == null) {
                    ((ISynchronizable)document).setLockObject(new Object());
                }
            }
        }
    }

    protected SourceContent createContent(SubMonitor m) throws CoreException {
        SourceUnit underlyingUnit = this.unit.getUnderlyingUnit();
        if (underlyingUnit != null) {
            return underlyingUnit.getContent((IProgressMonitor)m);
        }
        switch (this.detectResourceMode()) {
            case 1: {
                return this.loadContentFromFile((IFile)this.unit.getResource(), m);
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ltk.core", "Unsupported operation: mode= " + this.mode));
    }

    protected final SourceContent loadContentFromFile(IFile file, SubMonitor m) throws CoreException {
        return new SourceContent(file.getModificationStamp(), file.readString());
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }
}

