/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.ltk.text.core.HeuristicTokenScanner;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.util.RChunkHeuristicTokenScanner;

@NonNullByDefault
public class RHeuristicTokenScanner
extends HeuristicTokenScanner {
    public static final CharPairSet R_BRACKETS = new CharPairSet(ImCollections.newIdentityList((Object[])new CharPair[]{Chars.CURLY_BRACKETS, Chars.ROUND_BRACKETS, Chars.SQUARE_BRACKETS}));
    private static final HeuristicTokenScanner.StopCondition R_WORD_CONDITION = new HeuristicTokenScanner.StopCondition(){

        public boolean matches(char c) {
            return RTokens.isRobustSeparator(c);
        }
    };
    private static final HeuristicTokenScanner.StopCondition R_WORD_DOT_SEP_CONDITION = new HeuristicTokenScanner.StopCondition(){

        public boolean matches(char c) {
            return RTokens.isRobustSeparator(c, true);
        }
    };

    public static RHeuristicTokenScanner create(DocContentSections documentContentInfo) {
        return documentContentInfo.getPrimaryType() == "org.eclipse.statet.R" ? new RHeuristicTokenScanner(documentContentInfo) : new RChunkHeuristicTokenScanner(documentContentInfo);
    }

    protected RHeuristicTokenScanner(DocContentSections documentContentInfo) {
        super(documentContentInfo, RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT);
    }

    public CharPairSet getDefaultBrackets() {
        return R_BRACKETS;
    }

    public @Nullable IRegion findRWord(int position, boolean isDotSeparator, boolean allowEnd) throws BadLocationException {
        return this.findAnyRegion(position, isDotSeparator ? R_WORD_DOT_SEP_CONDITION : R_WORD_CONDITION, true);
    }
}

