/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.SingleValue;

@NonNullByDefault
public abstract class Symbol
extends SingleValue {
    @Nullable String text;

    private Symbol(int statusCode, @Nullable RAstNode parent) {
        super(statusCode, parent);
    }

    private Symbol(int statusCode) {
        super(statusCode, null);
    }

    private Symbol() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.SYMBOL;
    }

    @Override
    public abstract RTerminal getOperator(int var1);

    public final @Nullable String getText() {
        return this.text;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (NodeType.SYMBOL == element.getNodeType()) {
            Symbol other = (Symbol)element;
            return Objects.equals(this.text, other.text);
        }
        return false;
    }

    @Override
    void appendPathElement(StringBuilder s) {
        s.append('$');
        s.append(this.text);
    }

    static final class G
    extends Symbol {
        private @Nullable TextRegion textRegion;

        G(int statusCode, int startOffset, int endOffset) {
            super(statusCode);
            this.doSetStartEndOffset(startOffset, endOffset);
        }

        G(int startOffset, int endOffset) {
            this.doSetStartEndOffset(startOffset, endOffset);
        }

        G() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SYMBOL_G;
        }

        public final @Nullable TextRegion getTextRegion() {
            return this.textRegion;
        }

        @Override
        void setText(@Nullable String text, @Nullable TextRegion textRegion) {
            this.text = text;
            this.textRegion = textRegion;
        }
    }

    static final class Std
    extends Symbol {
        Std(int statusCode, @Nullable RAstNode parent, int startOffset, int endOffset) {
            super(statusCode, parent);
            this.doSetStartEndOffset(startOffset, endOffset);
        }

        Std(int statusCode, int startOffset, int endOffset) {
            super(statusCode);
            this.doSetStartEndOffset(startOffset, endOffset);
        }

        Std(int startOffset, int endOffset) {
            this.doSetStartEndOffset(startOffset, endOffset);
        }

        Std() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SYMBOL;
        }

        public final @Nullable TextRegion getTextRegion() {
            return this;
        }

        @Override
        void setText(@Nullable String text, @Nullable TextRegion textRegion) {
            this.text = text;
        }
    }
}

