/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.util.data;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.core.data.DataProvider;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class PropertyColumnHeaderDataProvider
implements DataProvider {
    private final ImList<String> propertyNames;
    private final @Nullable Map<String, String> propertyToLabelMap;

    public PropertyColumnHeaderDataProvider(ImList<String> propertyNames, Map<String, String> propertyToLabelMap) {
        this.propertyNames = (ImList)ObjectUtils.nonNullAssert(propertyNames);
        this.propertyToLabelMap = propertyToLabelMap;
    }

    @Override
    public long getColumnCount() {
        return this.propertyNames.size();
    }

    @Override
    public long getRowCount() {
        return 1L;
    }

    @Override
    public Object getDataValue(long columnIndex, long rowIndex, int flags, @Nullable IProgressMonitor monitor) {
        String label;
        if (columnIndex < 0L || columnIndex >= (long)this.propertyNames.size()) {
            throw new IndexOutOfBoundsException();
        }
        String propertyName = (String)this.propertyNames.get((int)columnIndex);
        if (this.propertyToLabelMap != null && (label = this.propertyToLabelMap.get(propertyName)) != null) {
            return label;
        }
        return propertyName;
    }

    @Override
    public void setDataValue(long columnIndex, long rowIndex, @Nullable Object newValue) {
        throw new UnsupportedOperationException();
    }
}

