/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;

public class WidgetToolBarComposite
extends Composite {
    private final Listener listener;
    private ToolBar leftToolBar;
    private ToolBar rightToolBar;

    public WidgetToolBarComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = LayoutUtils.newCompositeGrid(2);
        layout.verticalSpacing = 2;
        this.setLayout((Layout)layout);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        WidgetToolBarComposite.this.onPaint(event);
                        break;
                    }
                }
            }
        };
        this.createToolBars();
    }

    private void createToolBars() {
        this.leftToolBar = new ToolBar((Composite)this, 0x800000);
        this.leftToolBar.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.rightToolBar = new ToolBar((Composite)this, 0x820000);
        this.rightToolBar.setLayoutData((Object)new GridData(131072, 4, true, false));
        this.addListener(9, this.listener);
    }

    public ToolBar getLeftToolBar() {
        return this.leftToolBar;
    }

    public ToolBar getRightToolBar() {
        return this.rightToolBar;
    }

    private void onPaint(Event event) {
        GC gc = event.gc;
        Rectangle toolBarBounds = this.leftToolBar.getBounds();
        gc.setForeground(gc.getDevice().getSystemColor(19));
        int y = toolBarBounds.y + toolBarBounds.height + 1;
        gc.drawLine(event.x, y, event.x + event.width, y);
    }

    public GridData getContentLayoutData() {
        return new GridData(4, 4, true, true, 2, 1);
    }
}

