/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.nico.core.runtime.History;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUIMessages;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.views.HistoryView;

public class HistorySubmitAction
extends Action {
    private final HistoryView view;

    public HistorySubmitAction(HistoryView view) {
        super(NicoUIMessages.SubmitAction_name);
        this.setId("org.eclipse.statet.nico.addviews.submit");
        this.view = view;
    }

    public void run() {
        ToolController controller;
        final History.Entry[] selection = this.view.getSelection();
        ToolProcess process = this.view.getTool();
        ToolController toolController = controller = process != null ? process.getController() : null;
        if (selection == null || controller == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
                try {
                    try {
                        m.beginTask(NicoUITools.createSubmitMessage(controller.getTool()), 10);
                        List<String> commands = HistoryView.createCommandList(selection);
                        m.worked(2);
                        Status status = controller.submit(commands, SubmitType.EDITOR, (IProgressMonitor)m.newChild(8));
                        if (status.getSeverity() >= 4) {
                            throw new CoreException(StatusUtils.convert((Status)status));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    m.done();
                }
            }
        };
        NicoUITools.runSubmitInBackground(process, runnable, this.view.getSite().getShell());
    }
}

