/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.model.TexModel;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.source.LtxDocumentContentInfo;
import org.eclipse.statet.docmlet.tex.core.source.TexDocumentConstants;
import org.eclipse.statet.docmlet.tex.ui.editors.LtxDefaultFoldingProvider;
import org.eclipse.statet.docmlet.tex.ui.editors.LtxEditor;
import org.eclipse.statet.docmlet.tex.ui.editors.TexMarkOccurrencesLocator;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.LtxSourceViewerConfiguration;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.LtxSourceViewerConfigurator;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.TexEditingSettings;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.docmlet.tex.ui.TexUIPlugin;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.LtxOutlinePage;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class LtxDocEditor
extends SourceEditor1
implements LtxEditor {
    private static final ImList<String> KEY_CONTEXTS = ImCollections.newIdentityList((Object)"org.eclipse.statet.docmlet.contexts.TexEditor");
    private static final ImList<String> CONTEXT_IDS = ImCollections.concatList((Collection)ACTION_SET_CONTEXT_IDS, KEY_CONTEXTS);
    private LtxSourceViewerConfigurator texConfig;

    public LtxDocEditor() {
        super(TexCore.LTX_CONTENT_TYPE);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("org.eclipse.statet.docmlet.menus.LtxEditorContextMenu");
    }

    protected SourceEditorViewerConfigurator createConfiguration() {
        this.setDocumentProvider((IDocumentProvider)TexUIPlugin.getInstance().getTexDocumentProvider());
        this.enableStructuralFeatures(TexModel.getLtxModelManager(), (Preference)TexEditingSettings.FOLDING_ENABLED_PREF, (Preference)TexEditingSettings.MARKOCCURRENCES_ENABLED_PREF);
        this.texConfig = new LtxSourceViewerConfigurator(null, new LtxSourceViewerConfiguration((DocContentSections)LtxDocumentContentInfo.INSTANCE, 0, this, null, null, null));
        return this.texConfig;
    }

    protected Collection<String> getContextIds() {
        return CONTEXT_IDS;
    }

    protected ISourceEditorAddon createCodeFoldingProvider() {
        return new FoldingEditorAddon((FoldingProvider)new LtxDefaultFoldingProvider());
    }

    protected ISourceEditorAddon createMarkOccurrencesProvider() {
        return new ThisMarkOccurrencesProvider(this);
    }

    @Override
    public TexSourceUnit getSourceUnit() {
        return (TexSourceUnit)super.getSourceUnit();
    }

    protected void setupConfiguration(IEditorInput newInput) {
        super.setupConfiguration(newInput);
        TexSourceUnit su = this.getSourceUnit();
        this.texConfig.setSource(su != null ? su.getTexCoreAccess() : null);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if ("tabWidth".equals(event.getProperty()) || "spacesForTabs".equals(event.getProperty())) {
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        super.collectContextMenuPreferencePages(pageIds);
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.TexEditor");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.LtxTextStyles");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.LtxEditorTemplates");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.TexCodeStyle");
    }

    protected SourceEditor1OutlinePage createOutlinePage() {
        return new LtxOutlinePage(this);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline"};
    }

    private static class ThisMarkOccurrencesProvider
    extends AbstractMarkOccurrencesProvider {
        private final TexMarkOccurrencesLocator locator = new TexMarkOccurrencesLocator();

        public ThisMarkOccurrencesProvider(SourceEditor1 editor) {
            super(editor, TexDocumentConstants.LTX_DEFAULT_OR_MATH_CONTENT_CONSTRAINT);
        }

        protected void doUpdate(AbstractMarkOccurrencesProvider.RunData run, ISourceUnitModelInfo info, AstSelection astSelection, ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
            this.locator.run(run, info, astSelection, orgSelection);
        }
    }
}

