/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntryProvider;
import org.eclipse.statet.jcommons.runtime.bundle.BundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.runtime.bundle.DefaultBundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.RefClassBundleResolver;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.ServerUtils;

@NonNullByDefault
public class RJContext {
    public static final String RJ_BUNDLE_RESOLVERS_PROPERTY_KEY = "org.eclipse.statet.rj.context.BundleResolvers";
    public static final String RJ_SERVER_CLASS_PATH_PROPERTY_KEY = "org.eclipse.statet.rj.server.ClassPath.urls";
    public static final String RJ_PATH_SEPARATOR = ":,:";
    private static final Pattern RJ_PATH_SEPARATOR_PATTERN = Pattern.compile(":,:", 16);
    protected static final String LOCALHOST_POLICY_FILENAME = "localhost.policy";
    private ImList<BundleEntryProvider> libPathEntryProviders;
    private final ImList<BundleResolver> bundleResolvers;

    public static BundleEntryProvider detectRJLibPaths() throws RjInitFailedException {
        ArrayList<Path> expliciteBaseDirectories = null;
        String paths = System.getProperty("org.eclipse.statet.rj.Path");
        if (paths != null) {
            String[] directories;
            expliciteBaseDirectories = new ArrayList<Path>();
            String[] stringArray = directories = RJ_PATH_SEPARATOR_PATTERN.split(paths);
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                String pathString = stringArray[n2];
                expliciteBaseDirectories.add(Paths.get(pathString, new String[0]));
                ++n2;
            }
        }
        try {
            return BundleEntryProvider.detectEntryProvider(RJContext.class, expliciteBaseDirectories);
        }
        catch (StatusException e) {
            throw new RjInitFailedException("Failed to autodetect RJ library location", e);
        }
    }

    public RJContext(Collection<BundleEntryProvider> pathEntryProviders) {
        this.libPathEntryProviders = ImCollections.toList(pathEntryProviders);
        this.bundleResolvers = ImCollections.toList(this.loadBundleResolvers());
    }

    public RJContext(BundleEntryProvider pathEntryProvider, BundleEntryProvider ... pathEntryProviderAdditionals) {
        this((Collection<BundleEntryProvider>)ImCollections.addElement((List)ImCollections.newList((Object[])pathEntryProviderAdditionals), (int)0, (Object)pathEntryProvider));
    }

    protected RJContext() {
        this.bundleResolvers = ImCollections.toList(this.loadBundleResolvers());
    }

    protected ImList<BundleResolver> getBundleResolvers() {
        return this.bundleResolvers;
    }

    protected List<BundleResolver> loadBundleResolvers() {
        ArrayList<BundleResolver> resolvers = new ArrayList<BundleResolver>();
        String property = System.getProperty(RJ_BUNDLE_RESOLVERS_PROPERTY_KEY);
        String[] ids = property != null ? property.split(",") : new String[]{"default"};
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                BundleResolver resolver = this.getBundleResolver(id);
                if (resolver == null) {
                    throw new RjInvalidConfigurationException("The specified bundle resolver is unknown.");
                }
                resolvers.add(resolver);
            }
            catch (RjInvalidConfigurationException e) {
                CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.server", String.format("An error occurred when loading bundle resolver '%1$s' for RJ context.", id), (Throwable)e));
            }
            ++n2;
        }
        return resolvers;
    }

    protected @Nullable BundleResolver getBundleResolver(String id) throws RjInvalidConfigurationException {
        if (id.equals("default")) {
            return new DefaultBundleResolver();
        }
        if (id.equals("RefClass")) {
            return new RefClassBundleResolver();
        }
        return null;
    }

    public List<BundleEntry> resolveBundles(List<BundleSpec> bundleSpecs) throws RjInvalidConfigurationException {
        List<? extends BundleEntry> candidates = this.getBundleCandidates();
        Collections.sort(candidates);
        BundleResolver.Data data = new BundleResolver.Data(ImCollections.toList(candidates));
        ArrayList<MultiStatus> bundleStatuses = new ArrayList<MultiStatus>();
        ArrayList<BundleSpec> missing = new ArrayList<BundleSpec>();
        ImList<BundleResolver> resolvers = this.getBundleResolvers();
        for (BundleSpec bundleSpec : bundleSpecs) {
            MultiStatus status = new MultiStatus("org.eclipse.statet.rj.server", String.format("'%1$s':", bundleSpec.getId()));
            boolean found = false;
            for (BundleResolver resolver : resolvers) {
                if (!resolver.resolveBundle(data, bundleSpec, status)) continue;
                found = true;
                break;
            }
            if (!found) {
                missing.add(bundleSpec);
                status.add((Status)new ErrorStatus("org.eclipse.statet.rj.server", "The bundle could not be resolved."));
            }
            if (status.getChildren().isEmpty()) continue;
            bundleStatuses.add(status);
        }
        if (!bundleStatuses.isEmpty()) {
            MultiStatus status = new MultiStatus("org.eclipse.statet.rj.server", "Status for resolving of bundles for RJ.", null, ImCollections.toList(bundleStatuses));
            CommonsRuntime.log((Status)status);
            if (!missing.isEmpty()) {
                throw new RjInvalidConfigurationException("Failed to resolve the bundle(s): " + CollectionUtils.toString(missing, (String)", "), new StatusException((Status)status));
            }
        }
        return ImCollections.toList((Collection)data.getResolved());
    }

    protected List<? extends BundleEntry> getBundleCandidates() {
        ArrayList pathsEntries = new ArrayList();
        for (BundleEntryProvider provider : this.libPathEntryProviders) {
            provider.getEntries(pathsEntries);
        }
        return pathsEntries;
    }

    public String getServerPolicyFilePath() throws RjInvalidConfigurationException {
        URL resource = RJContext.class.getClassLoader().getResource(LOCALHOST_POLICY_FILENAME);
        if (resource != null) {
            resource.toString();
        }
        try {
            BundleEntry lib = this.resolveBundles((List<BundleSpec>)ImCollections.newList((Object)ServerUtils.RJ_SERVER_SPEC)).get(0);
            Path policyPath = lib.getResourcePath(LOCALHOST_POLICY_FILENAME);
            if (policyPath != null && Files.isRegularFile(policyPath, new LinkOption[0])) {
                return policyPath.toUri().toString();
            }
            String s = lib.getResourceUrlString(LOCALHOST_POLICY_FILENAME);
            if (s != null) {
                return s;
            }
            throw new UnsupportedOperationException(String.format("BundleEntry= '%1$s'", lib));
        }
        catch (Exception e) {
            throw new RjInvalidConfigurationException("Failed find server policy file.", e);
        }
    }

    protected String getPropertiesDirPath() {
        return System.getProperty("user.dir");
    }

    protected @Nullable InputStream getInputStream(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    protected OutputStream getOutputStream(String path) throws IOException {
        File file = new File(path);
        return new FileOutputStream(file, false);
    }

    public @Nullable Properties loadProperties(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String path = String.valueOf(this.getPropertiesDirPath()) + '/' + name + ".properties";
        InputStream in = this.getInputStream(path);
        if (in == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public void saveProperties(String name, Properties properties) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        String path = String.valueOf(this.getPropertiesDirPath()) + '/' + name + ".properties";
        OutputStream out = this.getOutputStream(path);
        try {
            properties.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

