/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.statet.internal.r.core.sourcemodel.AnonymousAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.CompositeSourceElement;
import org.eclipse.statet.internal.r.core.sourcemodel.ElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.IBuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.sourcemodel.IRoxygenAnalyzeContext;
import org.eclipse.statet.internal.r.core.sourcemodel.PackageReferences;
import org.eclipse.statet.internal.r.core.sourcemodel.RChunkBuildElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElementByElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceModelInfo;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceUnitElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RoxygenAnalyzer;
import org.eclipse.statet.internal.r.core.sourcemodel.RoxygenRCodeElement;
import org.eclipse.statet.internal.r.core.sourcemodel.SubIndexedDElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.SubIndexedSElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.SubNamedPartSyntacticElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.SubNamedSlotSemanticElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.SubNamedSlotSyntacticElementAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.ArgsBuilder;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Arithmetic;
import org.eclipse.statet.r.core.rsource.ast.Assignment;
import org.eclipse.statet.r.core.rsource.ast.CForLoop;
import org.eclipse.statet.r.core.rsource.ast.CIfElse;
import org.eclipse.statet.r.core.rsource.ast.CLoopCommand;
import org.eclipse.statet.r.core.rsource.ast.CRepeatLoop;
import org.eclipse.statet.r.core.rsource.ast.CWhileLoop;
import org.eclipse.statet.r.core.rsource.ast.Dummy;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.Help;
import org.eclipse.statet.r.core.rsource.ast.Logical;
import org.eclipse.statet.r.core.rsource.ast.Model;
import org.eclipse.statet.r.core.rsource.ast.NSGet;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.NullConst;
import org.eclipse.statet.r.core.rsource.ast.NumberConst;
import org.eclipse.statet.r.core.rsource.ast.Power;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.Relational;
import org.eclipse.statet.r.core.rsource.ast.Seq;
import org.eclipse.statet.r.core.rsource.ast.Sign;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.rsource.ast.Special;
import org.eclipse.statet.r.core.rsource.ast.StringConst;
import org.eclipse.statet.r.core.rsource.ast.SubIndexed;
import org.eclipse.statet.r.core.rsource.ast.SubNamed;
import org.eclipse.statet.r.core.rsource.ast.Symbol;

public class SourceAnalyzer
extends RAstVisitor {
    private static final int S_GLOBAL = 0;
    private static final int S_LOCAL = 1;
    private static final int S_SEARCH = 2;
    private static final int RETURN_SOURCE_CONTAINTER = 1;
    private static final int RETURN_METHOD_SIGNATURE = 2;
    private static final int RETURN_STRING_ARRAY = 3;
    private static final int REG_CLASS_REPRESENTATION = 4;
    private static final int REG_CLASS_PROTOTYPE = 5;
    private static final int[] NO_REQUESTS = new int[0];
    private static final int[] STRING_ARRAY_REQUEST = new int[]{3};
    private static final int[] SIGNATURE_REQUESTS = new int[]{2, 3};
    private static final int[] REPRESENTATION_REQUEST = new int[]{4};
    private static final int[] PROTOTYPE_REQUEST = new int[]{5};
    private static final Integer FIRST = 0;
    private static final Comparator<ISourceStructElement> SOURCEELEMENT_SORTER = new Comparator<ISourceStructElement>(){

        @Override
        public int compare(ISourceStructElement e1, ISourceStructElement e2) {
            return e1.getSourceRange().getStartOffset() - e2.getSourceRange().getStartOffset();
        }
    };
    private IRSourceUnit sourceUnit;
    private List<RChunkBuildElement> chunkElements;
    private AstInfo ast;
    private int anonymCount;
    private final ArrayList<String> idComponents = new ArrayList(32);
    private LinkedHashMap<String, BuildSourceFrame> frames;
    private Map<String, BuildSourceFrame> dependencyEnvironments;
    private final ArrayList<BuildSourceFrame> currentEnvironments = new ArrayList(32);
    private BuildSourceFrame globalEnvir;
    private BuildSourceFrame genericDefaultEnvir;
    private BuildSourceFrame topLevelEnvir;
    private BuildSourceFrame topScope;
    private PackageReferences packageRefs;
    private final LinkedList<RAstNode> argValueToIgnore = new LinkedList();
    private int[] request = NO_REQUESTS;
    private Object returnValue;
    private final ArrayList<SourceElementBuilder> sourceContainerBuilders = new ArrayList();
    private SourceElementBuilder currentSourceContainerBuilder;
    private RCoreFunctions configuredRDef;
    private final Map<String, IFCallAnalyzer> fCallAnalyzers = new HashMap<String, IFCallAnalyzer>();
    private IFCallAnalyzer fCallFallback;
    private final IFCallAnalyzer fCallNoAnalysis = new IFCallAnalyzer(){

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    };
    private final RoxygenAnalyzer roxygenAnalyzer;
    private final RoxygenAdapter roxygenAdapter;
    private boolean roxygenExamples;
    private final HashMap<String, Integer> commonNames = new HashMap();
    private final HashMap<String, Integer> classNames = new HashMap();
    private final HashMap<String, Integer> importNames = new HashMap();

    public SourceAnalyzer() {
        this.configure(RCoreFunctions.DEFAULT);
        this.roxygenAnalyzer = new RoxygenAnalyzer();
        this.roxygenAdapter = new RoxygenAdapter();
    }

    public void configure(RCoreFunctions rdef) {
        this.configuredRDef = rdef;
        this.fCallAnalyzers.clear();
        this.fCallAnalyzers.put("assign", new BaseAssign(rdef));
        BaseRemove analyzer = new BaseRemove(rdef);
        this.fCallAnalyzers.put("remove", analyzer);
        this.fCallAnalyzers.put("rm", analyzer);
        this.fCallAnalyzers.put("exists", new BaseExists(rdef));
        this.fCallAnalyzers.put("get", new BaseGet(rdef));
        this.fCallAnalyzers.put("save", new BaseSave(rdef));
        this.fCallAnalyzers.put("call", new BaseCall(rdef));
        this.fCallAnalyzers.put("do.call", new BaseDoCall(rdef));
        this.fCallAnalyzers.put("library", new BaseLibrary(rdef));
        this.fCallAnalyzers.put("require", new BaseRequire(rdef));
        this.fCallAnalyzers.put("globalenv", new BaseGlobalenv(rdef));
        this.fCallAnalyzers.put("topenv", new BaseTopenv(rdef));
        this.fCallAnalyzers.put("c", new BaseC(rdef));
        this.fCallAnalyzers.put("setGeneric", new MethodsSetGeneric(rdef));
        this.fCallAnalyzers.put("setGroupGeneric", new MethodsSetGroupGeneric(rdef));
        this.fCallAnalyzers.put("removeGeneric", new MethodsRemoveGeneric(rdef));
        this.fCallAnalyzers.put("signature", new MethodsSignature(rdef));
        this.fCallAnalyzers.put("setClass", new MethodsSetClass(rdef));
        this.fCallAnalyzers.put("setClassUnion", new MethodsSetClassUnion(rdef));
        this.fCallAnalyzers.put("representation", new MethodsRepresentation(rdef));
        this.fCallAnalyzers.put("prototype", new MethodsPrototype(rdef));
        this.fCallAnalyzers.put("setIs", new MethodsSetIs(rdef));
        this.fCallAnalyzers.put("removeClass", new MethodsRemoveClass(rdef));
        this.fCallAnalyzers.put("resetClass", this.fCallNoAnalysis);
        this.fCallAnalyzers.put("setAs", new MethodsSetAs(rdef));
        this.fCallAnalyzers.put("setValidity", new MethodsSetValidity(rdef));
        this.fCallAnalyzers.put("getClass", new MethodsGetClass(rdef));
        this.fCallAnalyzers.put("getClassDef", new MethodsGetClassDef(rdef));
        this.fCallAnalyzers.put("findClass", new MethodsFindClass(rdef));
        this.fCallAnalyzers.put("new", new MethodsNew(rdef));
        this.fCallAnalyzers.put("as", new MethodsAs(rdef));
        this.fCallAnalyzers.put("setMethod", new MethodsSetMethod(rdef));
        this.fCallAnalyzers.put("removeMethod", new MethodsRemoveMethod(rdef));
        this.fCallAnalyzers.put("removeMethods", new MethodsRemoveMethods(rdef));
        this.fCallAnalyzers.put("getMethod", new MethodsGetMethod(rdef));
        this.fCallAnalyzers.put("selectMethod", new MethodsSelectMethod(rdef));
        this.fCallAnalyzers.put("getMethods", new MethodsGetMethods(rdef));
        this.fCallAnalyzers.put("findMethod", new MethodsFindMethod(rdef));
        this.fCallAnalyzers.put("slot", new MethodsSlot(rdef));
        for (String name : rdef.getKnownFunctions()) {
            if (this.fCallAnalyzers.containsKey(name)) continue;
            this.fCallAnalyzers.put(name, new CommonDefBased(rdef.getArgs(name)));
        }
        this.fCallFallback = new NoDefFallback();
    }

    public IRModelInfo createModel(IRSourceUnit u, AstInfo ast) {
        if (!(ast.getRoot() instanceof SourceComponent)) {
            throw new IllegalArgumentException("ast");
        }
        SourceComponent root = (SourceComponent)ast.getRoot();
        this.anonymCount = 0;
        this.sourceUnit = u;
        try {
            this.init();
            RSourceUnitElement fileElement = new RSourceUnitElement(this.sourceUnit, this.topLevelEnvir, root);
            this.enterElement(fileElement, this.topLevelEnvir, root);
            root.acceptInRChildren(this);
            this.leaveElement();
            this.finish();
            this.ast = new AstInfo(4, ast);
            RSourceModelInfo modelInfo = new RSourceModelInfo(this.ast, this.frames, this.topLevelEnvir, this.packageRefs, this.dependencyEnvironments, fileElement);
            this.roxygenExamples = false;
            this.roxygenAdapter.update(modelInfo);
            if (this.roxygenExamples) {
                BuildSourceFrame.ElementAccessList modelList;
                BuildSourceFrame.ElementAccessList docuList;
                String name;
                Map.Entry<String, BuildSourceFrame.ElementAccessList> entry;
                this.finish();
                Iterator<Map.Entry<String, BuildSourceFrame.ElementAccessList>> iter = this.topLevelEnvir.data.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    name = entry.getKey();
                    docuList = entry.getValue();
                    if (docuList.isCreated != 0) continue;
                    iter.remove();
                    modelList = modelInfo.topFrame.data.get(name);
                    if (modelList != null) {
                        for (ElementAccess access : docuList.entries) {
                            access.shared = modelList;
                        }
                        modelList.entries.addAll(docuList.entries);
                        continue;
                    }
                    docuList.frame = modelInfo.topFrame;
                    modelInfo.topFrame.data.put(name, docuList);
                }
                iter = this.packageRefs.data.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    name = entry.getKey();
                    docuList = entry.getValue();
                    if (docuList.isCreated != 0) continue;
                    iter.remove();
                    modelList = modelInfo.packageRefs.data.get(name);
                    if (modelList != null) {
                        for (ElementAccess access : docuList.entries) {
                            access.shared = modelList;
                        }
                        modelList.entries.addAll(docuList.entries);
                        continue;
                    }
                    docuList.frame = modelInfo.topFrame;
                    modelInfo.packageRefs.data.put(name, docuList);
                }
            }
            RSourceModelInfo rSourceModelInfo = modelInfo;
            return rSourceModelInfo;
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        finally {
            this.cleanup();
            this.sourceUnit = null;
        }
        return null;
    }

    public void beginChunkSession(IRSourceUnit su, AstInfo ast) {
        this.anonymCount = 0;
        this.sourceUnit = su;
        this.ast = ast;
        if (this.chunkElements == null) {
            this.chunkElements = new ArrayList<RChunkBuildElement>();
        }
        this.init();
    }

    public void processChunk(RChunkBuildElement element, List<SourceComponent> rootNodes) {
        try {
            this.chunkElements.add(element);
            for (SourceComponent sourceComponent : rootNodes) {
                element.envir = this.topLevelEnvir;
                this.enterElement(element, this.topLevelEnvir, sourceComponent);
                sourceComponent.acceptInRChildren(this);
                this.leaveElement();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void processInlineNode(SourceComponent rootNode) {
        try {
            rootNode.acceptInRChildren(this);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public IRModelInfo stopChunkSession() {
        try {
            RSourceModelInfo modelInfo;
            this.finish();
            RSourceModelInfo rSourceModelInfo = modelInfo = new RSourceModelInfo(this.ast, this.frames, this.topLevelEnvir, this.packageRefs, this.dependencyEnvironments, new CompositeSourceElement(this.sourceUnit, this.topLevelEnvir, this.chunkElements, (TextRegion)this.ast.getRoot()));
            return rSourceModelInfo;
        }
        finally {
            this.cleanup();
            this.sourceUnit = null;
            this.chunkElements.clear();
        }
    }

    private void init() {
        this.frames = new LinkedHashMap();
        this.dependencyEnvironments = new HashMap<String, BuildSourceFrame>();
        String projId = this.sourceUnit instanceof IWorkspaceSourceUnit ? ((IWorkspaceSourceUnit)this.sourceUnit).getResource().getProject().getName() : "<noproject:" + this.sourceUnit.getElementName();
        BuildSourceFrame.DefScope fileEnvir = new BuildSourceFrame.DefScope(1, BuildSourceFrame.createId(1, projId, 0), null, new BuildSourceFrame[0]);
        this.currentEnvironments.add(fileEnvir);
        this.topLevelEnvir = this.globalEnvir = fileEnvir;
        this.genericDefaultEnvir = this.globalEnvir;
        this.packageRefs = new PackageReferences();
        this.topScope = this.currentEnvironments.get(this.currentEnvironments.size() - 1);
        this.idComponents.add(projId);
    }

    private void finish() {
        for (BuildSourceFrame si : this.dependencyEnvironments.values()) {
            si.runLateResolve(false);
        }
        this.topLevelEnvir.parents = ImCollections.concatList(this.dependencyEnvironments.values(), this.topLevelEnvir.parents);
        for (BuildSourceFrame si : this.frames.values()) {
            si.runLateResolve(false);
        }
        HashMap<String, Integer> commonNames = this.commonNames;
        HashMap<String, Integer> classNames = this.classNames;
        HashMap<String, Integer> importNames = this.importNames;
        int anonymous = 0;
        try {
            for (SourceElementBuilder seb : this.sourceContainerBuilders) {
                if (seb.element.getElementName() == null && seb.element instanceof RSourceElementByElementAccess.RMethod) {
                    RSourceElementByElementAccess element = (RSourceElementByElementAccess.RMethod)seb.element;
                    ((RSourceElementByElementAccess.RMethod)element).occurrenceCount = anonymous++;
                    this.registerAnonFunctionElement((RSourceElementByElementAccess.RMethod)element, seb.envir);
                }
                for (RSourceElementByElementAccess element : seb.children) {
                    HashMap<String, Integer> names;
                    String name = element.getElementName().getDisplayName();
                    switch (element.type & 0xF00) {
                        case 1024: {
                            names = classNames;
                            break;
                        }
                        case 768: {
                            names = importNames;
                            break;
                        }
                        default: {
                            names = commonNames;
                        }
                    }
                    Integer occ = names.get(name);
                    if (occ == null) {
                        names.put(name, FIRST);
                        continue;
                    }
                    element.occurrenceCount = occ + 1;
                    names.put(name, element.occurrenceCount);
                }
                for (ElementAccess access : seb.toCheck) {
                    if (seb.envir != access.getFrame() || commonNames.containsKey(access.getSegmentName())) continue;
                    commonNames.put(access.getSegmentName(), null);
                    seb.children.add(new RSourceElementByElementAccess.RVariable(seb.element, seb.envir != this.topLevelEnvir ? 1553 : 1552, access));
                }
                Object[] finalChildren = seb.children.toArray(new RSourceElementByElementAccess[seb.children.size()]);
                Arrays.sort(finalChildren, SOURCEELEMENT_SORTER);
                if (finalChildren.length > 0) {
                    seb.element.setSourceChildren((List<? extends IRLangSourceElement>)ImCollections.newList((Object[])finalChildren));
                }
                commonNames.clear();
                classNames.clear();
                importNames.clear();
            }
            if (this.chunkElements != null && !this.chunkElements.isEmpty()) {
                HashMap<String, Integer> names = commonNames;
                for (RChunkBuildElement element : this.chunkElements) {
                    String name = element.getElementName().getDisplayName();
                    Integer occ = names.get(name);
                    if (occ == null) {
                        names.put(name, FIRST);
                        continue;
                    }
                    element.occurrenceCount = occ + 1;
                    names.put(name, element.occurrenceCount);
                }
            }
        }
        finally {
            commonNames.clear();
            classNames.clear();
            importNames.clear();
        }
    }

    private void cleanup() {
        this.clean(this.currentEnvironments);
        this.clean(this.idComponents);
        this.argValueToIgnore.clear();
        this.clean(this.sourceContainerBuilders);
        this.ast = null;
        this.genericDefaultEnvir = null;
        this.globalEnvir = null;
        this.packageRefs = null;
        this.topLevelEnvir = null;
        this.frames = null;
        this.dependencyEnvironments = null;
        this.returnValue = null;
        this.currentSourceContainerBuilder = null;
    }

    private void clean(ArrayList<?> list) {
        if (list.size() > 2048) {
            list.clear();
            list.trimToSize();
            list.ensureCapacity(1024);
        } else {
            list.clear();
        }
    }

    private BuildSourceFrame getPkgEnvir(String name) {
        String id;
        BuildSourceFrame envir;
        if ((envir = this.dependencyEnvironments.get(id = BuildSourceFrame.createId(2, name, ++this.anonymCount))) == null) {
            envir = new BuildSourceFrame.DefScope(2, id, name, new BuildSourceFrame[0]);
            this.dependencyEnvironments.put(id, envir);
        }
        return envir;
    }

    private void registerInEnvir(int search, String name, ElementAccess access) {
        if (access.shared != null) {
            return;
        }
        switch (search) {
            case 1: {
                this.topScope.add(name, access);
                return;
            }
            case 0: {
                this.globalEnvir.add(name, access);
                return;
            }
            case 2: {
                this.topScope.addLateResolve(name, access);
                return;
            }
        }
        throw new IllegalArgumentException("Illegal mode");
    }

    private ElementAccess registerSimpleClassAccessInEnvir(RAstNode refNode, RAstNode nameNode) {
        ElementAccess.Class access = new ElementAccess.Class(refNode);
        access.flags = 0;
        access.nameNode = nameNode;
        this.genericDefaultEnvir.addClass(nameNode.getText(), access);
        return access;
    }

    protected final void enterElement(IBuildSourceFrameElement element, BuildSourceFrame envir, RAstNode node) {
        this.currentSourceContainerBuilder = new SourceElementBuilder(element, this.currentSourceContainerBuilder, envir);
        envir.addFrameElement(element);
        this.frames.put(envir.getFrameId(), envir);
        node.addAttachment(envir);
        this.sourceContainerBuilders.add(this.currentSourceContainerBuilder);
    }

    protected final void addEnvirInsteadOfElement(BuildSourceFrame envir, RAstNode node) {
        this.frames.put(envir.getFrameId(), envir);
        node.addAttachment(envir);
    }

    protected final void leaveElement() {
        this.currentSourceContainerBuilder = this.currentSourceContainerBuilder.parent;
    }

    private Object registerSourceElement(Object value, ElementAccess access) {
        if (value instanceof RSourceElementByElementAccess) {
            RSourceElementByElementAccess element = (RSourceElementByElementAccess)value;
            if ((element.getElementType() & 0xF00) == 1280) {
                this.registerFunctionElement((RSourceElementByElementAccess.RMethod)value, element.getElementType(), access, null);
                return null;
            }
            element.setAccess(access);
            this.currentSourceContainerBuilder.children.add(element);
            access.getNode().addAttachment(element);
            return null;
        }
        if (access.getSegmentName() != null && access.getType() == 17 && access.nextSegment == null) {
            this.currentSourceContainerBuilder.toCheck.add(access);
        }
        return value;
    }

    private void registerAnonFunctionElement(RSourceElementByElementAccess.RMethod rMethod, IRFrame frame) {
        AnonymousAccess access = new AnonymousAccess(rMethod.getFDefNode(), frame);
        rMethod.complete(access, SourceAnalyzer.createMethodArgDef(rMethod.getFDefNode(), null));
        access.getNode().addAttachment(rMethod);
    }

    private void registerFunctionElement(RSourceElementByElementAccess.RMethod rMethod, int type, ElementAccess access, Signature sig) {
        IRFrame frame;
        if (rMethod.getElementType() == 1296 && (frame = access.getFrame()) != null && (frame.getFrameType() == 5 || frame.getFrameType() == 6)) {
            type |= 1;
        }
        rMethod.complete(type, access, SourceAnalyzer.createMethodArgDef(rMethod.getFDefNode(), sig));
        if (sig != null && sig.argNameAccess != null) {
            BuildSourceFrame buildFrame = rMethod.getBuildFrame();
            int i = 0;
            while (i < sig.argNameAccess.length) {
                if (sig.argNameAccess[i] != null) {
                    buildFrame.add(((Signature)sig).argNameAccess[i].nameNode.getText(), sig.argNameAccess[i]);
                }
                ++i;
            }
        }
        access.flags |= 0x10;
        this.currentSourceContainerBuilder.children.add(rMethod);
        access.getNode().addAttachment(rMethod);
    }

    private void registerFunctionElement(RSourceElementByElementAccess.RMethod rMethod) {
        this.currentSourceContainerBuilder.children.add(rMethod);
        rMethod.getAccess().getNode().addAttachment(rMethod);
    }

    private void registerClassElement(RSourceElementByElementAccess.RClass rClass) {
        this.currentSourceContainerBuilder.children.add(rClass);
        rClass.getAccess().getNode().addAttachment(rClass);
    }

    private void registerClassExtElement(RSourceElementByElementAccess.RClassExt rClassExt) {
        this.currentSourceContainerBuilder.children.add(rClassExt);
        rClassExt.getAccess().getNode().addAttachment(rClassExt);
    }

    private boolean isRequested(int requestId) {
        int i = 0;
        while (i < this.request.length) {
            if (this.request[i] == requestId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void visit(SourceComponent node) throws InvocationTargetException {
        throw new IllegalArgumentException();
    }

    @Override
    public void visit(Assignment node) throws InvocationTargetException {
        this.returnValue = null;
        node.getSourceChild().acceptInR(this);
        Object returnValue = this.returnValue;
        if (node.getNodeType() == NodeType.A_COLON) {
            this.returnValue = null;
            return;
        }
        RAstNode target = node.getTargetChild();
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 2;
        String name = this.resolveElementName(target, access, true);
        if (name != null || returnValue instanceof RSourceElementByElementAccess) {
            int mode;
            if (access.getNextSegment() == null) {
                switch (node.getOperator(0)) {
                    case ARROW_LEFT_D: 
                    case ARROW_RIGHT_D: {
                        mode = 2;
                        break;
                    }
                    default: {
                        mode = 1;
                        break;
                    }
                }
            } else {
                mode = 2;
            }
            this.registerInEnvir(mode, name, access);
            this.returnValue = this.registerSourceElement(returnValue, access);
        } else {
            this.returnValue = null;
        }
    }

    @Override
    public void visit(CForLoop node) throws InvocationTargetException {
        Symbol symbol = node.getVarChild();
        ElementAccess.Default access = new ElementAccess.Default(symbol);
        access.flags = 2;
        String name = this.resolveElementName(symbol, access, false);
        if (name != null) {
            this.registerInEnvir(1, name, access);
        }
        this.request = NO_REQUESTS;
        node.getCondChild().acceptInR(this);
        node.getContChild().acceptInR(this);
        this.returnValue = null;
    }

    @Override
    public void visit(FDef node) throws InvocationTargetException {
        RSourceElementByElementAccess.RMethod rMethod;
        BuildSourceFrame.DefScope envir = new BuildSourceFrame.DefScope(5, BuildSourceFrame.createId(5, null, ++this.anonymCount), null, new BuildSourceFrame[]{this.topScope});
        this.currentEnvironments.add(envir);
        this.topScope = envir;
        if (this.currentSourceContainerBuilder != null) {
            rMethod = new RSourceElementByElementAccess.RMethod((IRLangSourceElement)this.currentSourceContainerBuilder.element, envir, node);
            this.enterElement(rMethod, envir, node);
        } else {
            rMethod = null;
            this.addEnvirInsteadOfElement(envir, node);
        }
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        if (rMethod != null) {
            this.leaveElement();
        }
        this.currentEnvironments.remove(envir);
        this.topScope = this.currentEnvironments.get(this.currentEnvironments.size() - 1);
        this.returnValue = rMethod;
    }

    @Override
    public void visit(FDef.Arg node) throws InvocationTargetException {
        RAstNode nameNode = node.getNameChild();
        if ((nameNode.getStatusCode() & 0x10000) == 0) {
            ElementAccess.Default access = new ElementAccess.Default(node);
            access.flags = 34;
            access.nameNode = nameNode;
            this.registerInEnvir(1, nameNode.getText(), access);
            if (this.currentSourceContainerBuilder != null) {
                this.currentSourceContainerBuilder.children.add(new RSourceElementByElementAccess.RVariable(this.currentSourceContainerBuilder.element, 1585, access));
            }
        }
        if (node.hasDefault()) {
            node.getDefaultChild().acceptInR(this);
        }
        this.returnValue = null;
    }

    @Override
    public void visit(FCall node) throws InvocationTargetException {
        boolean write;
        RAstNode ref = node.getRefChild();
        ElementAccess.Default access = new ElementAccess.Default(node, ref);
        access.flags = 17;
        String name = this.resolveElementName(node.getRefChild(), access, true);
        if (name != null) {
            this.registerInEnvir(2, name, access);
        }
        RAstNode parent = node.getRParent();
        switch (parent != null ? parent.getNodeType() : NodeType.DUMMY) {
            case A_RIGHT: 
            case A_EQUALS: 
            case A_LEFT: {
                write = ((Assignment)parent).getTargetChild() == node;
                break;
            }
            default: {
                write = false;
            }
        }
        IFCallAnalyzer specialist = null;
        if (name != null) {
            specialist = this.fCallAnalyzers.get(name);
        }
        if (specialist == null) {
            specialist = this.fCallFallback;
        }
        specialist.visit(node, write);
    }

    @Override
    public void visit(FCall.Arg node) throws InvocationTargetException {
        RAstNode valueNode = node.getValueChild();
        if (valueNode != null && !this.argValueToIgnore.remove((Object)valueNode)) {
            valueNode.acceptInR(this);
        }
        this.returnValue = null;
    }

    public RSourceElementByElementAccess.RMethod visitAndCheckValue(FCall.Arg node, String name) throws InvocationTargetException {
        RAstNode valueNode;
        assert (name != null);
        if (node != null && (valueNode = node.getValueChild()) != null) {
            valueNode.acceptInR(this);
            this.argValueToIgnore.add(valueNode);
            if (this.returnValue instanceof RSourceElementByElementAccess.RMethod) {
                RSourceElementByElementAccess.RMethod rMethod = (RSourceElementByElementAccess.RMethod)this.returnValue;
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 18;
                access.nameNode = node.getNameChild();
                this.currentSourceContainerBuilder.envir.addRunResolve(name, access);
                this.registerFunctionElement(rMethod, 1297, access, null);
                this.returnValue = null;
                return rMethod;
            }
            this.returnValue = null;
        }
        return null;
    }

    @Override
    public void visit(SubIndexed.Arg node) throws InvocationTargetException {
        RAstNode valueNode = node.getValueChild();
        if (valueNode != null) {
            valueNode.acceptInR(this);
        }
    }

    @Override
    public void visit(NSGet node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolveElementName(node, (ElementAccess)access);
        if (name != null) {
            this.registerInEnvir(1, name, access);
        }
        this.returnValue = access;
    }

    @Override
    public void visit(Symbol node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolveElementName(node, (ElementAccess)access);
        if (name != null) {
            this.registerInEnvir(2, name, access);
            if (name.equals(".GlobalEnv")) {
                this.returnValue = this.globalEnvir;
                return;
            }
        }
        this.returnValue = access;
    }

    @Override
    public void visit(SubNamed node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolvePartName(node, access);
        if (name != null) {
            this.registerInEnvir(2, name, access);
        }
        this.returnValue = access;
    }

    @Override
    public void visit(SubIndexed node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolveElementName(node, (ElementAccess)access);
        if (name != null) {
            this.registerInEnvir(2, name, access);
        }
        this.returnValue = access;
    }

    @Override
    public void visit(Model node) throws InvocationTargetException {
        node.acceptInRChildren(this);
        this.returnValue = node;
    }

    @Override
    public void visit(Help node) throws InvocationTargetException {
        this.returnValue = null;
    }

    @Override
    public void visit(StringConst node) throws InvocationTargetException {
        int i = 0;
        while (i < this.request.length) {
            if (this.request[i] == 3) {
                this.returnValue = new NodeArray(3, new StringConst[]{node});
                return;
            }
            ++i;
        }
        this.returnValue = node;
    }

    @Override
    public void visit(NumberConst node) throws InvocationTargetException {
        this.returnValue = null;
    }

    @Override
    public void visit(NullConst node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Special node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Sign node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Power node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Arithmetic node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Seq node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Relational node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Logical node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CIfElse node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CRepeatLoop node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CWhileLoop node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CLoopCommand node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    private String resolveElementName(RAstNode node, ElementAccess access, boolean allowString) throws InvocationTargetException {
        switch (node.getNodeType()) {
            case SYMBOL: {
                return this.resolveElementName((Symbol)node, access);
            }
            case STRING_CONST: {
                if (allowString && (node.getStatusCode() & 0x10000) == 0) {
                    access.nameNode = node;
                    return node.getText();
                }
                return null;
            }
            case SUB_INDEXED_S: 
            case SUB_INDEXED_D: {
                return this.resolveElementName((SubIndexed)node, access);
            }
            case SUB_NAMED_PART: {
                return this.resolvePartName((SubNamed)node, access);
            }
            case SUB_NAMED_SLOT: {
                return this.resolveSlotName((SubNamed)node, access);
            }
            case NS_GET: 
            case NS_GET_INT: {
                return this.resolveElementName((NSGet)node, access);
            }
        }
        if (node == access.fullNode) {
            node.acceptInRChildren(this);
        } else {
            node.acceptInR(this);
        }
        return null;
    }

    private String resolveElementName(Symbol node, ElementAccess access) {
        if ((node.getStatusCode() & 0x10000) == 0) {
            access.nameNode = node;
            return node.getText();
        }
        return null;
    }

    private String resolveElementName(SubIndexed node, ElementAccess access) throws InvocationTargetException {
        RAstNode child = node.getRefChild();
        String name = this.resolveElementName(child, access, false);
        node.getArgsChild().acceptInR(this);
        if (name != null) {
            access.flags |= 0x100;
            access.appendSubElement(node.getOperator(0) == RTerminal.SUB_INDEXED_D_OPEN ? new SubIndexedDElementAccess(access, node) : new SubIndexedSElementAccess(access, node));
            return name;
        }
        return null;
    }

    private String resolvePartName(SubNamed node, ElementAccess access) throws InvocationTargetException {
        RAstNode child = node.getRefChild();
        String name = this.resolveElementName(child, access, false);
        if (name != null) {
            access.flags |= 0x100;
            access.appendSubElement(new SubNamedPartSyntacticElementAccess(access, node));
            return name;
        }
        return null;
    }

    private String resolveSlotName(SubNamed node, ElementAccess access) throws InvocationTargetException {
        RAstNode child = node.getRefChild();
        String name = this.resolveElementName(child, access, false);
        if (name != null) {
            access.flags |= 0x100;
            access.appendSubElement(new SubNamedSlotSyntacticElementAccess(access, node));
            return name;
        }
        return null;
    }

    private String resolveElementName(NSGet node, ElementAccess access) {
        RAstNode namespaceChild = node.getNamespaceChild();
        String namespaceName = null;
        if (this.isValidPackageName(namespaceChild)) {
            namespaceName = namespaceChild.getText();
            ElementAccess.Scope packageAccess = node.getNodeType() == NodeType.NS_GET_INT ? new ElementAccess.NamespaceInternal(access.fullNode, namespaceChild) : new ElementAccess.Namespace(access.fullNode, namespaceChild);
            this.packageRefs.add(namespaceName, packageAccess);
            if (access instanceof ElementAccess.Main) {
                ((ElementAccess.Main)access).setScope(packageAccess);
            }
        }
        BuildSourceFrame envir = namespaceName != null && (node.getElementChild().getStatusCode() & 0x10000) == 0 ? this.getPkgEnvir(namespaceName) : this.topScope;
        access.nameNode = node.getElementChild();
        String name = access.nameNode.getText();
        envir.add(name, access);
        return null;
    }

    private boolean isValidPackageName(RAstNode node) {
        switch (node.getNodeType()) {
            case SYMBOL: {
                return (node.getStatusCode() & 0x10000) == 0;
            }
            case STRING_CONST: {
                return true;
            }
        }
        return false;
    }

    private Signature readSignature(RAstNode refNode, RAstNode sigNode) throws InvocationTargetException {
        if (sigNode != null) {
            this.request = SIGNATURE_REQUESTS;
            this.returnValue = null;
            sigNode.acceptInR(this);
            this.argValueToIgnore.add(sigNode);
            if (this.returnValue instanceof ReturnValue) {
                ReturnValue value = (ReturnValue)this.returnValue;
                this.returnValue = null;
                if (value.returnType == 2) {
                    return (Signature)value;
                }
                if (value.returnType == 3) {
                    RAstNode[] nodes = ((NodeArray)value).array;
                    String[] classNames = new String[nodes.length];
                    int i = 0;
                    while (i < nodes.length) {
                        this.registerSimpleClassAccessInEnvir(refNode, nodes[i]);
                        classNames[i] = nodes[i].getText();
                        ++i;
                    }
                    return new Signature(null, classNames);
                }
            } else {
                this.returnValue = null;
                return null;
            }
        }
        return null;
    }

    public static ArgsDefinition createMethodArgDef(FDef fdefNode, Signature sig) {
        ArgsBuilder b;
        block13: {
            block14: {
                FDef.Args argList = fdefNode != null ? fdefNode.getArgsChild() : null;
                b = new ArgsBuilder();
                if (argList == null) break block14;
                int n = argList.getChildCount();
                if (sig != null && sig.classNames != null) {
                    int i = 0;
                    while (i < n) {
                        String argName = argList.getChild(i).getNameChild().getText();
                        if (argName != null && sig.argNameAccess != null) {
                            int j = 0;
                            while (j < sig.argNameAccess.length) {
                                if (sig.argNameAccess[j] != null && argName.equals(((Signature)sig).argNameAccess[j].nameNode.getText())) {
                                    b.add(argName, 0, sig.classNames[j]);
                                    break;
                                }
                                ++j;
                            }
                        } else if (i < sig.classNames.length) {
                            b.add(argName, 0, sig.classNames[i]);
                        } else {
                            b.add(argName, 0, null);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        String argName = argList.getChild(i).getNameChild().getText();
                        b.add(argName, 0, null);
                        ++i;
                    }
                }
                break block13;
            }
            if (sig == null || sig.argNameAccess == null || sig.classNames == null) break block13;
            int i = 0;
            while (i < sig.argNameAccess.length) {
                if (sig.argNameAccess[i] != null) {
                    b.add(((Signature)sig).argNameAccess[i].nameNode.getText(), 0, sig.classNames[i]);
                    ++i;
                    continue;
                }
                break;
            }
        }
        return b.build();
    }

    private boolean evalBoolean(RAstNode valueNode, boolean defaultValue) {
        if (valueNode != null && valueNode.getNodeType() == NodeType.NUM_CONST) {
            if (valueNode.getOperator(0) == RTerminal.TRUE) {
                return true;
            }
            if (valueNode.getOperator(0) == RTerminal.FALSE) {
                return false;
            }
        }
        return defaultValue;
    }

    private BuildSourceFrame readScopeArgs(RAstNode pos, BuildSourceFrame defaultScope) throws InvocationTargetException {
        this.returnValue = null;
        BuildSourceFrame envir = null;
        if (pos != null) {
            switch (pos.getNodeType()) {
                case NUM_CONST: {
                    if (!pos.getText().equals("1")) break;
                    envir = this.globalEnvir;
                    break;
                }
                case STRING_CONST: {
                    if (pos.getText().equals(".GlobalEnv")) {
                        envir = this.globalEnvir;
                        break;
                    }
                    if (!pos.getText().startsWith("package:")) break;
                    envir = this.getPkgEnvir(pos.getText().substring(8));
                    break;
                }
                default: {
                    pos.acceptInR(this);
                    if (!(this.returnValue instanceof BuildSourceFrame)) break;
                    envir = (BuildSourceFrame)this.returnValue;
                }
            }
            this.argValueToIgnore.add(pos);
        }
        if (envir != null) {
            return envir;
        }
        return defaultScope;
    }

    protected final class BaseAssign
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_x;
        private final int argIdx_value;

        public BaseAssign(RCoreFunctions rdef) {
            this.argsDef = rdef.BASE_ASSIGN_args;
            this.argIdx_x = this.argsDef.indexOf("x");
            this.argIdx_value = this.argsDef.indexOf("value");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.returnValue = null;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode xNode = args.getArgValueNode(this.argIdx_x);
            RAstNode valueNode = args.getArgValueNode(this.argIdx_value);
            Object returnValue = null;
            if (valueNode != null) {
                valueNode.acceptInR(SourceAnalyzer.this);
                returnValue = SourceAnalyzer.this.returnValue;
                SourceAnalyzer.this.returnValue = null;
                SourceAnalyzer.this.argValueToIgnore.add(valueNode);
            }
            if (xNode != null && xNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 2;
                access.nameNode = xNode;
                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode("pos"), SourceAnalyzer.this.topScope);
                if (SourceAnalyzer.this.evalBoolean(args.getArgValueNode("inherits"), false)) {
                    envir.addLateResolve(xNode.getText(), access);
                } else {
                    envir.add(xNode.getText(), access);
                }
                returnValue = SourceAnalyzer.this.registerSourceElement(returnValue, access);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = returnValue;
        }
    }

    protected final class BaseC
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;

        public BaseC(RCoreFunctions rdef) {
            this.argsDef = rdef.BASE_C_args;
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            NodeArray returnValue = null;
            int i = 0;
            block0: while (i < SourceAnalyzer.this.request.length) {
                if (SourceAnalyzer.this.request[i] == 3) {
                    RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
                    RAstNode[] array = new RAstNode[args.ellipsisArgs.length];
                    int j = 0;
                    while (j < array.length) {
                        FCall.Arg argNode = args.ellipsisArgs[j];
                        if (argNode.hasValue()) {
                            RAstNode valueNode = argNode.getValueChild();
                            if (valueNode.getNodeType() != NodeType.STRING_CONST) break block0;
                            array[j] = valueNode;
                            SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                        }
                        ++j;
                    }
                    returnValue = new NodeArray(3, array);
                    break;
                }
                ++i;
            }
            SourceAnalyzer.this.request = NO_REQUESTS;
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = returnValue;
        }
    }

    protected final class BaseCall
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;

        public BaseCall(RCoreFunctions rdef) {
            this.argsDef = rdef.BASE_CALL_args;
            this.argIdx_fName = this.argsDef.indexOf("name");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode nameNode = args.getArgValueNode(this.argIdx_fName);
            if (nameNode != null && nameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 16;
                access.nameNode = nameNode;
                SourceAnalyzer.this.topScope.addLateResolve(nameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(nameNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private abstract class BaseCommonPackageLoad
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_packageName;
        private final int argIdx_stringOnly;

        public BaseCommonPackageLoad(ArgsDefinition argsDef) {
            this.argsDef = argsDef;
            this.argIdx_packageName = this.argsDef.indexOf("package");
            this.argIdx_stringOnly = this.argsDef.indexOf("character.only");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode nameValue = args.getArgValueNode(this.argIdx_packageName);
            if (nameValue != null && (nameValue.getNodeType() == NodeType.STRING_CONST || !SourceAnalyzer.this.evalBoolean(args.getArgNode(this.argIdx_stringOnly), false) && nameValue.getNodeType() == NodeType.SYMBOL) && SourceAnalyzer.this.isValidPackageName(nameValue)) {
                BuildSourceFrame envir;
                String packageName = nameValue.getText();
                ElementAccess.Package access = new ElementAccess.Package(node, nameValue);
                access.flags |= 4;
                SourceAnalyzer.this.packageRefs.add(packageName, access);
                if (SourceAnalyzer.this.currentSourceContainerBuilder != null) {
                    RSourceElementByElementAccess.RPkgImport rImport = new RSourceElementByElementAccess.RPkgImport(SourceAnalyzer.this.currentSourceContainerBuilder.element, access);
                    SourceAnalyzer.this.currentSourceContainerBuilder.children.add(rImport);
                }
                if (!((SourceAnalyzer)SourceAnalyzer.this).globalEnvir.parents.contains((Object)(envir = SourceAnalyzer.this.getPkgEnvir(packageName)))) {
                    ((SourceAnalyzer)SourceAnalyzer.this).globalEnvir.parents = ImCollections.addElement(((SourceAnalyzer)SourceAnalyzer.this).globalEnvir.parents, (int)0, (Object)envir);
                }
                SourceAnalyzer.this.argValueToIgnore.add(nameValue);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = SourceAnalyzer.this.globalEnvir;
        }
    }

    protected final class BaseDoCall
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;

        public BaseDoCall(RCoreFunctions rdef) {
            this.argsDef = rdef.BASE_DOCALL_args;
            this.argIdx_fName = this.argsDef.indexOf("what");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode nameNode = args.getArgValueNode(this.argIdx_fName);
            if (nameNode != null) {
                ElementAccess.Default access = new ElementAccess.Default(node, nameNode);
                access.flags = 17;
                String name = SourceAnalyzer.this.resolveElementName(nameNode, access, true);
                if (name != null) {
                    SourceAnalyzer.this.topScope.addLateResolve(name, access);
                }
                SourceAnalyzer.this.argValueToIgnore.add(nameNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseExists
    extends CommonVarNamedRead {
        public BaseExists(RCoreFunctions rdef) {
            super(rdef.BASE_EXISTS_args, "x", "where");
        }
    }

    protected final class BaseGet
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_x;
        private final int argIdx_scope;

        public BaseGet(RCoreFunctions rdef) {
            this.argsDef = rdef.BASE_GET_args;
            this.argIdx_x = this.argsDef.indexOf("x");
            this.argIdx_scope = this.argsDef.indexOf("pos");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode xNode = args.getArgValueNode(this.argIdx_x);
            if (xNode != null && xNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 0;
                access.nameNode = xNode;
                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode(this.argIdx_scope), SourceAnalyzer.this.topScope);
                if (SourceAnalyzer.this.evalBoolean(args.getArgValueNode("inherits"), true)) {
                    envir.addLateResolve(xNode.getText(), access);
                } else {
                    envir.add(xNode.getText(), access);
                }
                SourceAnalyzer.this.argValueToIgnore.add(xNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseGlobalenv
    implements IFCallAnalyzer {
        public BaseGlobalenv(RCoreFunctions rdef) {
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = SourceAnalyzer.this.globalEnvir;
        }
    }

    protected final class BaseLibrary
    extends BaseCommonPackageLoad {
        public BaseLibrary(RCoreFunctions rdef) {
            super(rdef.BASE_LIBRARY_args);
        }
    }

    protected final class BaseRemove
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;

        public BaseRemove(RCoreFunctions rdef) {
            this.argsDef = rdef.BASE_REMOVE_args;
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            if (args.ellipsisArgs.length > 0) {
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    FCall.Arg argNode = args.ellipsisArgs[i];
                    if (argNode.hasValue()) {
                        RAstNode valueNode = argNode.getValueChild();
                        switch (valueNode.getNodeType()) {
                            case STRING_CONST: 
                            case SYMBOL: {
                                ElementAccess.Default access = new ElementAccess.Default(node);
                                access.flags = 3;
                                access.nameNode = valueNode;
                                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode("pos"), SourceAnalyzer.this.topScope);
                                if (SourceAnalyzer.this.evalBoolean(args.getArgValueNode("inherits"), false)) {
                                    envir.addLateResolve(valueNode.getText(), access);
                                } else {
                                    envir.add(valueNode.getText(), access);
                                }
                                SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseRequire
    extends BaseCommonPackageLoad {
        public BaseRequire(RCoreFunctions rdef) {
            super(rdef.BASE_REQUIRE_args);
        }
    }

    protected final class BaseSave
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;

        public BaseSave(RCoreFunctions rdef) {
            this.argsDef = rdef.BASE_SAVE_args;
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            if (args.ellipsisArgs.length > 0) {
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    FCall.Arg argNode = args.ellipsisArgs[i];
                    if (argNode.hasValue()) {
                        RAstNode valueNode = argNode.getValueChild();
                        switch (valueNode.getNodeType()) {
                            case STRING_CONST: 
                            case SYMBOL: {
                                ElementAccess.Default access = new ElementAccess.Default(node);
                                access.flags = 0;
                                access.nameNode = valueNode;
                                SourceAnalyzer.this.topScope.addLateResolve(valueNode.getText(), access);
                                SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseTopenv
    implements IFCallAnalyzer {
        public BaseTopenv(RCoreFunctions rdef) {
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = SourceAnalyzer.this.topLevelEnvir;
        }
    }

    protected final class CommonDefBased
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;

        public CommonDefBased(ArgsDefinition argsDef) {
            this.argsDef = argsDef;
        }

        private boolean matchesNameType(int nameType, int defType, RAstNode argValue) {
            return (defType & nameType) != 0 && ((defType & 0x4000000) != 0 && argValue.getNodeType() == NodeType.STRING_CONST || (defType & 0x2000000) != 0 && argValue.getNodeType() == NodeType.SYMBOL) && argValue.getText() != null;
        }

        @Override
        public final void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            int i = 0;
            while (i < args.allocatedArgs.length) {
                RAstNode argValue = args.getArgValueNode(i);
                if (argValue != null) {
                    ElementAccess access;
                    if (this.matchesNameType(512, this.argsDef.get((int)i).type, argValue)) {
                        access = new ElementAccess.Namespace(node, argValue);
                        access.nameNode = argValue;
                        SourceAnalyzer.this.packageRefs.add(argValue.getText(), access);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if ((this.argsDef.get((int)i).type & 0x4000) != 0 && argValue.getNodeType() == NodeType.STRING_CONST) {
                        access = new ElementAccess.Default(node);
                        access.flags = 16;
                        access.nameNode = argValue;
                        SourceAnalyzer.this.genericDefaultEnvir.addLateResolve(argValue.getText(), access);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if ((this.argsDef.get((int)i).type & 0x2000) != 0 && argValue.getNodeType() == NodeType.STRING_CONST) {
                        SourceAnalyzer.this.registerSimpleClassAccessInEnvir(node, argValue);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if ((this.argsDef.get((int)i).type & 0x100) != 0 && argValue.getNodeType() == NodeType.STRING_CONST) {
                        access = new ElementAccess.Default(node);
                        access.flags = 0;
                        access.nameNode = argValue;
                        SourceAnalyzer.this.topScope.addLateResolve(argValue.getText(), access);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if (this.matchesNameType(4096, this.argsDef.get((int)i).type, argValue)) {
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    }
                }
                ++i;
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected class CommonVarNamedRead
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_name;
        private final int argIdx_scope;

        protected CommonVarNamedRead(ArgsDefinition argsDef, String nameArgName, String scopeArgName) {
            this.argsDef = argsDef;
            this.argIdx_name = this.argsDef.indexOf(nameArgName);
            this.argIdx_scope = this.argsDef.indexOf(scopeArgName);
        }

        @Override
        public final void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode nameValue = args.getArgValueNode(this.argIdx_name);
            if (nameValue != null && nameValue.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 0;
                access.nameNode = nameValue;
                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode(this.argIdx_scope), SourceAnalyzer.this.topScope);
                if (SourceAnalyzer.this.evalBoolean(args.getArgValueNode("inherits"), false)) {
                    envir.addLateResolve(nameValue.getText(), access);
                } else {
                    envir.add(nameValue.getText(), access);
                }
                SourceAnalyzer.this.argValueToIgnore.add(nameValue);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected static interface IFCallAnalyzer {
        public void visit(FCall var1, boolean var2) throws InvocationTargetException;
    }

    protected final class MethodsAs
    extends MethodsCommonClassRead {
        public MethodsAs(RCoreFunctions rdef) {
            super(rdef.METHODS_AS_args, "Class");
        }
    }

    private abstract class MethodsCommonClassRead
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_className;

        protected MethodsCommonClassRead(ArgsDefinition argsDef, String classNameNodeName) {
            this.argsDef = argsDef;
            this.argIdx_className = this.argsDef.indexOf(classNameNodeName);
        }

        @Override
        public final void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode classNameNode = args.getArgValueNode(this.argIdx_className);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                SourceAnalyzer.this.registerSimpleClassAccessInEnvir(node, classNameNode);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private class MethodsCommonMethodRead
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;

        protected MethodsCommonMethodRead(ArgsDefinition argsDef, String fNameNodeName) {
            this.argsDef = argsDef;
            this.argIdx_fName = this.argsDef.indexOf(fNameNodeName);
        }

        @Override
        public final void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode fNameNode = args.getArgValueNode(this.argIdx_fName);
            if (fNameNode != null && fNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 16;
                access.nameNode = fNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.add(fNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private abstract class MethodsCommonSetGeneric
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;
        private final int argIdx_def;
        private final int argIdx_useAsDefault;
        private final int argIdx_genericFunction;
        private final int argIdx_signature;

        protected MethodsCommonSetGeneric(ArgsDefinition argsDef) {
            this.argsDef = argsDef;
            this.argIdx_fName = this.argsDef.indexOf("name");
            this.argIdx_def = this.argsDef.indexOf("def");
            this.argIdx_useAsDefault = this.argsDef.indexOf("useAsDefault");
            this.argIdx_genericFunction = this.argsDef.indexOf("genericFunction");
            this.argIdx_signature = this.argsDef.indexOf("signature");
        }

        @Override
        public final void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode fNameNode = args.getArgValueNode(this.argIdx_fName);
            if (fNameNode != null && fNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 18;
                access.nameNode = fNameNode;
                SourceAnalyzer.this.topLevelEnvir.add(fNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameNode);
                String string = access.getSegmentName();
                SourceAnalyzer sourceAnalyzer = SourceAnalyzer.this;
                int n = sourceAnalyzer.anonymCount + 1;
                sourceAnalyzer.anonymCount = n;
                BuildSourceFrame.RunScope envir = new BuildSourceFrame.RunScope(5, BuildSourceFrame.createId(5, string, n), SourceAnalyzer.this.topScope);
                if (SourceAnalyzer.this.currentSourceContainerBuilder != null) {
                    ArgsDefinition methodDef;
                    RSourceElementByElementAccess.RMethod rMethod = new RSourceElementByElementAccess.RMethod(SourceAnalyzer.this.currentSourceContainerBuilder.element, 1312, access, envir);
                    SourceAnalyzer.this.registerFunctionElement(rMethod);
                    SourceAnalyzer.this.enterElement(rMethod, envir, node);
                    RSourceElementByElementAccess.RMethod defMethod = SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.argIdx_def), "def");
                    RSourceElementByElementAccess.RMethod defaultMethod = SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.argIdx_useAsDefault), "useAsDefault");
                    SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.argIdx_genericFunction), "genericFunction");
                    RAstNode signatureValue = args.getArgValueNode(this.argIdx_signature);
                    RAstNode[] signatureArgNodes = null;
                    if (signatureValue != null) {
                        SourceAnalyzer.this.request = STRING_ARRAY_REQUEST;
                        SourceAnalyzer.this.returnValue = null;
                        signatureValue.acceptInR(SourceAnalyzer.this);
                        SourceAnalyzer.this.argValueToIgnore.add(signatureValue);
                        if (SourceAnalyzer.this.returnValue instanceof ReturnValue && ((ReturnValue)((SourceAnalyzer)SourceAnalyzer.this).returnValue).returnType == 3) {
                            signatureArgNodes = ((NodeArray)((SourceAnalyzer)SourceAnalyzer.this).returnValue).array;
                        }
                        SourceAnalyzer.this.returnValue = null;
                    }
                    ArgsDefinition baseDef = null;
                    if (defMethod != null) {
                        baseDef = defMethod.getArgsDefinition();
                    }
                    if (defaultMethod != null && (baseDef == null || baseDef.size() == 0)) {
                        baseDef = defaultMethod.getArgsDefinition();
                    }
                    if (baseDef != null && baseDef.size() > 0) {
                        ArgsBuilder argsBuilder = new ArgsBuilder();
                        if (signatureArgNodes != null) {
                            int i = 0;
                            while (i < baseDef.size()) {
                                block24: {
                                    String name = baseDef.get((int)i).name;
                                    if (name != null) {
                                        int j = 0;
                                        while (j < signatureArgNodes.length) {
                                            if (name.equals(signatureArgNodes[j].getText())) {
                                                argsBuilder.add(name, 0, "<?>");
                                                break block24;
                                            }
                                            ++j;
                                        }
                                        argsBuilder.add(name, 0, "\u2014");
                                    } else {
                                        argsBuilder.add(name);
                                    }
                                }
                                ++i;
                            }
                        } else if (baseDef.size() == 1 && "...".equals(baseDef.get((int)0).name)) {
                            argsBuilder.add("...", 0, "<?>");
                        } else {
                            int i = 0;
                            while (i < baseDef.size()) {
                                String name = baseDef.get((int)i).name;
                                if (name != null) {
                                    if (!name.equals("...")) {
                                        argsBuilder.add(name, 0, "<?>");
                                    } else {
                                        argsBuilder.add(name, 0, "\u2014");
                                    }
                                } else {
                                    argsBuilder.add(name);
                                }
                                ++i;
                            }
                        }
                        methodDef = argsBuilder.build();
                    } else {
                        methodDef = new ArgsDefinition(new String[0]);
                    }
                    rMethod.complete(methodDef);
                    node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
                    SourceAnalyzer.this.leaveElement();
                } else {
                    SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                    node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
                }
            } else {
                node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsFindClass
    extends MethodsCommonClassRead {
        public MethodsFindClass(RCoreFunctions rdef) {
            super(rdef.METHODS_FINDCLASS_args, "Class");
        }
    }

    protected final class MethodsFindMethod
    extends MethodsCommonMethodRead {
        public MethodsFindMethod(RCoreFunctions rdef) {
            super(rdef.METHODS_FINDMETHOD_args, "f");
        }
    }

    protected final class MethodsGetClass
    extends MethodsCommonClassRead {
        public MethodsGetClass(RCoreFunctions rdef) {
            super(rdef.METHODS_GETCLASS_args, "Class");
        }
    }

    protected final class MethodsGetClassDef
    extends MethodsCommonClassRead {
        public MethodsGetClassDef(RCoreFunctions rdef) {
            super(rdef.METHODS_GETCLASSDEF_args, "Class");
        }
    }

    protected final class MethodsGetMethod
    extends MethodsCommonMethodRead {
        public MethodsGetMethod(RCoreFunctions rdef) {
            super(rdef.METHODS_GETMETHOD_args, "f");
        }
    }

    protected final class MethodsGetMethods
    extends MethodsCommonMethodRead {
        public MethodsGetMethods(RCoreFunctions rdef) {
            super(rdef.METHODS_GETMETHODS_args, "f");
        }
    }

    protected final class MethodsNew
    extends MethodsCommonClassRead {
        public MethodsNew(RCoreFunctions rdef) {
            super(rdef.METHODS_NEW_args, "Class");
        }
    }

    protected final class MethodsPrototype
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;

        public MethodsPrototype(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_PROTOTYPE_args;
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            boolean requested = SourceAnalyzer.this.request == PROTOTYPE_REQUEST && SourceAnalyzer.this.currentSourceContainerBuilder.element.getElementType() == 1152;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            if (args.ellipsisArgs.length > 0) {
                RSourceElementByElementAccess.RClass classDef = requested ? (RSourceElementByElementAccess.RClass)SourceAnalyzer.this.currentSourceContainerBuilder.element : null;
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    FCall.Arg arg = args.ellipsisArgs[i];
                    if (arg.hasName()) {
                        RAstNode slotNameNode = arg.getNameChild();
                        String slotName = slotNameNode.getText();
                        RSourceElementByElementAccess.RSlot slot = null;
                        if (classDef != null && slotName != null) {
                            ElementAccess.Slot access = new ElementAccess.Slot(arg);
                            access.flags = 2;
                            access.nameNode = slotNameNode;
                            SourceAnalyzer.this.currentSourceContainerBuilder.envir.addRunResolve(slotName, access);
                            for (RSourceElementByElementAccess child : SourceAnalyzer.this.currentSourceContainerBuilder.children) {
                                if (child.getElementType() != 1664 || !slotName.equals(child.getElementName().getSegmentName())) continue;
                                slot = (RSourceElementByElementAccess.RSlot)child;
                                break;
                            }
                        }
                        arg.hasValue();
                    }
                    ++i;
                }
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveClass
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_className;

        public MethodsRemoveClass(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_REMOVECLASS_args;
            this.argIdx_className = this.argsDef.indexOf("Class");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode classNameNode = args.getArgValueNode(this.argIdx_className);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Class access = new ElementAccess.Class(node);
                access.flags = 3;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(classNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveGeneric
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;

        public MethodsRemoveGeneric(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SETGROUPGENERIC_args;
            this.argIdx_fName = this.argsDef.indexOf("f");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode fNameNode = args.getArgValueNode(this.argIdx_fName);
            if (fNameNode != null && fNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 19;
                access.nameNode = fNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.add(fNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveMethod
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;
        private final int argIdx_signature;

        public MethodsRemoveMethod(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_REMOVEMETHOD_args;
            this.argIdx_fName = this.argsDef.indexOf("f");
            this.argIdx_signature = this.argsDef.indexOf("signature");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode fNameArg = args.getArgValueNode(this.argIdx_fName);
            if (fNameArg != null && fNameArg.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 19;
                access.nameNode = fNameArg;
                SourceAnalyzer.this.genericDefaultEnvir.addLateResolve(fNameArg.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameArg);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveMethods
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;

        public MethodsRemoveMethods(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_REMOVEMETHODS_args;
            this.argIdx_fName = this.argsDef.indexOf("f");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode fNameArg = args.getArgValueNode(this.argIdx_fName);
            if (fNameArg != null && fNameArg.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 19;
                access.nameNode = fNameArg;
                SourceAnalyzer.this.genericDefaultEnvir.addLateResolve(fNameArg.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameArg);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRepresentation
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;

        public MethodsRepresentation(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_REPRESENTATION_args;
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            boolean requested = SourceAnalyzer.this.request == REPRESENTATION_REQUEST && SourceAnalyzer.this.currentSourceContainerBuilder.element.getElementType() == 1152;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            if (args.ellipsisArgs.length > 0) {
                RSourceElementByElementAccess.RClass rClass = requested ? (RSourceElementByElementAccess.RClass)SourceAnalyzer.this.currentSourceContainerBuilder.element : null;
                String[] superClassNames = new String[args.ellipsisArgs.length];
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    RAstNode value;
                    FCall.Arg arg = args.ellipsisArgs[i];
                    if (arg.hasName()) {
                        RAstNode valueNode;
                        RAstNode nameNode = arg.getNameChild();
                        RSourceElementByElementAccess.RSlot slot = null;
                        if (rClass != null) {
                            ElementAccess.Slot access = new ElementAccess.Slot(arg);
                            access.flags = 2;
                            access.nameNode = nameNode;
                            SourceAnalyzer.this.currentSourceContainerBuilder.envir.addRunResolve(nameNode.getText(), access);
                            slot = new RSourceElementByElementAccess.RSlot(rClass, access);
                            SourceAnalyzer.this.currentSourceContainerBuilder.children.add(slot);
                        }
                        if (arg.hasValue() && (valueNode = arg.getValueChild()).getNodeType() == NodeType.STRING_CONST) {
                            SourceAnalyzer.this.registerSimpleClassAccessInEnvir(arg, valueNode);
                            if (slot != null) {
                                slot.completeType(valueNode.getText());
                            }
                            SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                        }
                    } else if (arg.hasValue() && (value = arg.getValueChild()).getNodeType() == NodeType.STRING_CONST) {
                        SourceAnalyzer.this.registerSimpleClassAccessInEnvir(arg, value);
                        if (rClass != null) {
                            superClassNames[i] = value.getText();
                        }
                        SourceAnalyzer.this.argValueToIgnore.add(value);
                    }
                    ++i;
                }
                if (rClass != null) {
                    rClass.addSuperClasses(superClassNames);
                }
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSelectMethod
    extends MethodsCommonMethodRead {
        public MethodsSelectMethod(RCoreFunctions rdef) {
            super(rdef.METHODS_SELECTMETHOD_args, "f");
        }
    }

    protected final class MethodsSetAs
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_className;
        private final int argIdx_toClass;

        public MethodsSetAs(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SETAS_args;
            this.argIdx_className = this.argsDef.indexOf("from");
            this.argIdx_toClass = this.argsDef.indexOf("to");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            ElementAccess.Class access;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode classNameNode = args.getArgValueNode(this.argIdx_className);
            RAstNode toClassNode = args.getArgValueNode(this.argIdx_toClass);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                access = new ElementAccess.Class(node);
                access.flags = 2;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(classNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            if (toClassNode != null && toClassNode.getNodeType() == NodeType.STRING_CONST) {
                access = new ElementAccess.Class(node);
                access.flags = 0;
                access.nameNode = toClassNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(toClassNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(toClassNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetClass
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_className;
        private final int argIdx_superClasses;
        private final int argIdx_representation;
        private final int argIdx_prototype;

        public MethodsSetClass(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SETCLASS_args;
            this.argIdx_className = this.argsDef.indexOf("Class");
            this.argIdx_superClasses = this.argsDef.indexOf("contains");
            this.argIdx_representation = this.argsDef.indexOf("representation");
            this.argIdx_prototype = this.argsDef.indexOf("prototype");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            String name;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            ElementAccess.Class access = new ElementAccess.Class(node);
            access.flags = 2;
            RAstNode classNameValue = args.getArgValueNode(this.argIdx_className);
            if (classNameValue != null && classNameValue.getNodeType() == NodeType.STRING_CONST) {
                name = classNameValue.getText();
                access.nameNode = classNameValue;
                SourceAnalyzer.this.argValueToIgnore.add(classNameValue);
            } else {
                name = null;
            }
            SourceAnalyzer.this.genericDefaultEnvir.addClass(name, access);
            String string = access.getSegmentName();
            SourceAnalyzer sourceAnalyzer = SourceAnalyzer.this;
            int n = sourceAnalyzer.anonymCount + 1;
            sourceAnalyzer.anonymCount = n;
            BuildSourceFrame.RunScope envir = new BuildSourceFrame.RunScope(6, BuildSourceFrame.createId(6, string, n), SourceAnalyzer.this.topScope);
            if (SourceAnalyzer.this.currentSourceContainerBuilder != null) {
                RAstNode prototypeValue;
                RAstNode superClasses;
                RSourceElementByElementAccess.RClass rClass = new RSourceElementByElementAccess.RClass((IRLangSourceElement)SourceAnalyzer.this.currentSourceContainerBuilder.element, access, envir);
                SourceAnalyzer.this.registerClassElement(rClass);
                SourceAnalyzer.this.enterElement(rClass, envir, node);
                RAstNode representationValue = args.getArgValueNode(this.argIdx_representation);
                if (representationValue != null) {
                    SourceAnalyzer.this.request = REPRESENTATION_REQUEST;
                    representationValue.acceptInR(SourceAnalyzer.this);
                    SourceAnalyzer.this.argValueToIgnore.add(representationValue);
                    SourceAnalyzer.this.request = NO_REQUESTS;
                }
                if ((superClasses = args.getArgValueNode(this.argIdx_superClasses)) != null) {
                    SourceAnalyzer.this.request = STRING_ARRAY_REQUEST;
                    SourceAnalyzer.this.returnValue = null;
                    superClasses.acceptInR(SourceAnalyzer.this);
                    SourceAnalyzer.this.argValueToIgnore.add(superClasses);
                    if (SourceAnalyzer.this.returnValue instanceof ReturnValue && ((ReturnValue)((SourceAnalyzer)SourceAnalyzer.this).returnValue).returnType == 3) {
                        FCall.Arg refNode = args.allocatedArgs[this.argIdx_superClasses];
                        RAstNode[] superClassNameNodes = ((NodeArray)((SourceAnalyzer)SourceAnalyzer.this).returnValue).array;
                        String[] names = new String[superClassNameNodes.length];
                        int i = 0;
                        while (i < superClassNameNodes.length) {
                            ElementAccess superClassAccess = SourceAnalyzer.this.registerSimpleClassAccessInEnvir(refNode, superClassNameNodes[i]);
                            names[i] = superClassAccess.getSegmentName();
                            ++i;
                        }
                        rClass.addSuperClasses(names);
                    }
                    SourceAnalyzer.this.request = NO_REQUESTS;
                    SourceAnalyzer.this.returnValue = null;
                }
                if ((prototypeValue = args.getArgValueNode(this.argIdx_prototype)) != null) {
                    SourceAnalyzer.this.request = PROTOTYPE_REQUEST;
                    prototypeValue.acceptInR(SourceAnalyzer.this);
                    SourceAnalyzer.this.argValueToIgnore.add(prototypeValue);
                    SourceAnalyzer.this.request = NO_REQUESTS;
                }
                node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
                SourceAnalyzer.this.leaveElement();
            } else {
                SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetClassUnion
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_className;
        private final int argIdx_superClassNames;

        public MethodsSetClassUnion(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SETCLASSUNION_args;
            this.argIdx_className = this.argsDef.indexOf("name");
            this.argIdx_superClassNames = this.argsDef.indexOf("members");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            String name;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode classNameValue = args.getArgValueNode(this.argIdx_className);
            RAstNode superClassNamesValue = args.getArgValueNode(this.argIdx_superClassNames);
            ElementAccess.Class access = new ElementAccess.Class(node);
            access.flags = 2;
            if (classNameValue != null && classNameValue.getNodeType() == NodeType.STRING_CONST) {
                name = classNameValue.getText();
                access.nameNode = classNameValue;
                SourceAnalyzer.this.argValueToIgnore.add(classNameValue);
            } else {
                name = null;
            }
            SourceAnalyzer.this.genericDefaultEnvir.addClass(name, access);
            String string = access.getSegmentName();
            SourceAnalyzer sourceAnalyzer = SourceAnalyzer.this;
            int n = sourceAnalyzer.anonymCount + 1;
            sourceAnalyzer.anonymCount = n;
            BuildSourceFrame.RunScope envir = new BuildSourceFrame.RunScope(6, BuildSourceFrame.createId(6, string, n), SourceAnalyzer.this.topScope);
            if (SourceAnalyzer.this.currentSourceContainerBuilder != null) {
                RSourceElementByElementAccess.RClass rClass = new RSourceElementByElementAccess.RClass((IRLangSourceElement)SourceAnalyzer.this.currentSourceContainerBuilder.element, access, envir);
                SourceAnalyzer.this.registerClassElement(rClass);
                SourceAnalyzer.this.enterElement(rClass, envir, node);
                if (superClassNamesValue != null) {
                    SourceAnalyzer.this.request = STRING_ARRAY_REQUEST;
                    SourceAnalyzer.this.returnValue = null;
                    superClassNamesValue.acceptInR(SourceAnalyzer.this);
                    SourceAnalyzer.this.argValueToIgnore.add(superClassNamesValue);
                    if (SourceAnalyzer.this.returnValue instanceof ReturnValue && ((ReturnValue)((SourceAnalyzer)SourceAnalyzer.this).returnValue).returnType == 3) {
                        FCall.Arg refNode = args.allocatedArgs[this.argIdx_superClassNames];
                        RAstNode[] superClassNameNodes = ((NodeArray)((SourceAnalyzer)SourceAnalyzer.this).returnValue).array;
                        String[] names = new String[superClassNameNodes.length];
                        int i = 0;
                        while (i < superClassNameNodes.length) {
                            ElementAccess superClassAccess = SourceAnalyzer.this.registerSimpleClassAccessInEnvir(refNode, superClassNameNodes[i]);
                            names[i] = superClassAccess.getSegmentName();
                            ++i;
                        }
                        rClass.addSuperClasses(names);
                    }
                    SourceAnalyzer.this.request = NO_REQUESTS;
                    SourceAnalyzer.this.returnValue = null;
                }
                node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
                SourceAnalyzer.this.leaveElement();
            } else {
                SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetGeneric
    extends MethodsCommonSetGeneric {
        public MethodsSetGeneric(RCoreFunctions rdef) {
            super(rdef.METHODS_SETGENERIC_args);
        }
    }

    protected final class MethodsSetGroupGeneric
    extends MethodsCommonSetGeneric {
        public MethodsSetGroupGeneric(RCoreFunctions rdef) {
            super(rdef.METHODS_SETGROUPGENERIC_args);
        }
    }

    protected final class MethodsSetIs
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_className;
        private final int argIdx_classToExtendName;
        private final int argIdx_testF;
        private final int argIdx_coerceF;
        private final int argIdx_replaceF;

        public MethodsSetIs(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SETIS_args;
            this.argIdx_className = this.argsDef.indexOf("class1");
            this.argIdx_classToExtendName = this.argsDef.indexOf("class2");
            this.argIdx_testF = this.argsDef.indexOf("test");
            this.argIdx_coerceF = this.argsDef.indexOf("coerce");
            this.argIdx_replaceF = this.argsDef.indexOf("replace");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            ElementAccess.Class access;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode classNameNode = args.getArgValueNode(this.argIdx_className);
            RAstNode cToExtendNameNode = args.getArgValueNode(this.argIdx_classToExtendName);
            RSourceElementByElementAccess.RClassExt rClassExt = null;
            BuildSourceFrame.RunScope envir = null;
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                access = new ElementAccess.Class(node);
                access.flags = 2;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(classNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
                String string = access.getSegmentName();
                SourceAnalyzer sourceAnalyzer = SourceAnalyzer.this;
                int n = sourceAnalyzer.anonymCount + 1;
                sourceAnalyzer.anonymCount = n;
                envir = new BuildSourceFrame.RunScope(5, BuildSourceFrame.createId(5, string, n), SourceAnalyzer.this.topScope);
                if (SourceAnalyzer.this.currentSourceContainerBuilder != null) {
                    rClassExt = new RSourceElementByElementAccess.RClassExt(SourceAnalyzer.this.currentSourceContainerBuilder.element, access, envir, "setIs");
                    SourceAnalyzer.this.registerClassExtElement(rClassExt);
                } else {
                    node.addAttachment(envir);
                }
            }
            if (cToExtendNameNode != null && cToExtendNameNode.getNodeType() == NodeType.STRING_CONST) {
                access = new ElementAccess.Class(node);
                access.flags = 0;
                access.nameNode = cToExtendNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(cToExtendNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(cToExtendNameNode);
                if (rClassExt != null) {
                    rClassExt.complete(classNameNode.getText());
                }
            }
            if (rClassExt != null) {
                SourceAnalyzer.this.enterElement(rClassExt, envir, node);
                SourceAnalyzer.this.visitAndCheckValue(args.allocatedArgs[this.argIdx_testF], "test");
                SourceAnalyzer.this.visitAndCheckValue(args.allocatedArgs[this.argIdx_coerceF], "coerce");
                SourceAnalyzer.this.visitAndCheckValue(args.allocatedArgs[this.argIdx_replaceF], "replace");
                node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
                SourceAnalyzer.this.leaveElement();
            } else {
                node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetMethod
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_fName;
        private final int argIdx_signature;
        private final int argIdx_fDef;

        public MethodsSetMethod(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SETMETHOD_args;
            this.argIdx_fName = this.argsDef.indexOf("f");
            this.argIdx_signature = this.argsDef.indexOf("signature");
            this.argIdx_fDef = this.argsDef.indexOf("definition");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode fNameArg = args.getArgValueNode(this.argIdx_fName);
            RAstNode fDefArg = args.getArgValueNode(this.argIdx_fDef);
            if (fNameArg != null && fNameArg.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 18;
                access.nameNode = fNameArg;
                SourceAnalyzer.this.genericDefaultEnvir.add(fNameArg.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameArg);
                Signature sig = SourceAnalyzer.this.readSignature(node, args.getArgValueNode(this.argIdx_signature));
                SourceAnalyzer.this.returnValue = null;
                if (fDefArg != null) {
                    fDefArg.acceptInR(SourceAnalyzer.this);
                    SourceAnalyzer.this.argValueToIgnore.add(fDefArg);
                }
                if (SourceAnalyzer.this.returnValue instanceof RSourceElementByElementAccess.RMethod) {
                    RSourceElementByElementAccess.RMethod rMethod = (RSourceElementByElementAccess.RMethod)SourceAnalyzer.this.returnValue;
                    SourceAnalyzer.this.registerFunctionElement(rMethod, 1408, access, sig);
                } else {
                    String string = access.getSegmentName();
                    SourceAnalyzer sourceAnalyzer = SourceAnalyzer.this;
                    int n = sourceAnalyzer.anonymCount + 1;
                    sourceAnalyzer.anonymCount = n;
                    BuildSourceFrame.DefScope envir = new BuildSourceFrame.DefScope(5, BuildSourceFrame.createId(5, string, n), access.getSegmentName(), new BuildSourceFrame[]{SourceAnalyzer.this.topLevelEnvir});
                    if (SourceAnalyzer.this.currentSourceContainerBuilder != null) {
                        RSourceElementByElementAccess.RMethod rMethod = new RSourceElementByElementAccess.RMethod(SourceAnalyzer.this.currentSourceContainerBuilder.element, 1408, access, envir);
                        SourceAnalyzer.this.enterElement(rMethod, envir, node);
                        SourceAnalyzer.this.leaveElement();
                        SourceAnalyzer.this.registerFunctionElement(rMethod, 1408, access, sig);
                    } else {
                        SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                    }
                }
                SourceAnalyzer.this.returnValue = null;
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetValidity
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_className;

        public MethodsSetValidity(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SETVALIDITY_args;
            this.argIdx_className = this.argsDef.indexOf("Class");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode classNameNode = args.getArgValueNode(this.argIdx_className);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Class access = new ElementAccess.Class(node);
                access.flags = 2;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(classNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSignature
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;

        public MethodsSignature(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SIGNATURE_args;
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            Signature returnValue = null;
            if (args.ellipsisArgs.length > 0) {
                ElementAccess[] argNameNodes = new ElementAccess[args.ellipsisArgs.length];
                String[] classNames = new String[args.ellipsisArgs.length];
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    RAstNode value;
                    FCall.Arg arg = args.ellipsisArgs[i];
                    if (arg.hasName() && arg.getNameChild().getText() != null) {
                        argNameNodes[i] = new ElementAccess.Default(node, arg.getNameChild());
                        argNameNodes[i].flags = 32;
                    }
                    if (arg.hasValue() && (value = arg.getValueChild()).getNodeType() == NodeType.STRING_CONST) {
                        classNames[i] = value.getText();
                        SourceAnalyzer.this.registerSimpleClassAccessInEnvir(node, value);
                        SourceAnalyzer.this.argValueToIgnore.add(value);
                    }
                    ++i;
                }
                returnValue = new Signature(argNameNodes, classNames);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = returnValue;
        }
    }

    protected final class MethodsSlot
    implements IFCallAnalyzer {
        private final ArgsDefinition argsDef;
        private final int argIdx_object;
        private final int argIdx_slotName;

        public MethodsSlot(RCoreFunctions rdef) {
            this.argsDef = rdef.METHODS_SLOT_args;
            this.argIdx_object = this.argsDef.indexOf("object");
            this.argIdx_slotName = this.argsDef.indexOf("name");
        }

        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAst.FCallArgMatch args = RAst.matchArgs(node.getArgsChild(), this.argsDef);
            RAstNode objectArg = args.getArgValueNode(this.argIdx_object);
            RAstNode slotArg = args.getArgValueNode(this.argIdx_slotName);
            if (objectArg != null && objectArg.getNodeType() == NodeType.SYMBOL) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = assignment ? 258 : 256;
                access.nameNode = objectArg;
                SourceAnalyzer.this.argValueToIgnore.add(objectArg);
                if (slotArg != null && slotArg.getNodeType() == NodeType.STRING_CONST) {
                    access.nextSegment = new SubNamedSlotSemanticElementAccess(access, slotArg);
                    SourceAnalyzer.this.argValueToIgnore.add(slotArg);
                }
                SourceAnalyzer.this.topScope.addLateResolve(objectArg.getText(), access);
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class NoDefFallback
    implements IFCallAnalyzer {
        @Override
        public void visit(FCall node, boolean assignment) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            FCall.Args args = node.getArgsChild();
            if (args.getChildCount() > 0 && assignment) {
                FCall.Arg firstArg = args.getChild(0);
                RAstNode argName = firstArg.getNameChild();
                RAstNode argValue = firstArg.getValueChild();
                if (firstArg.hasValue() && (!firstArg.hasName() || argName.getText().equals("x"))) {
                    ElementAccess.Default access = new ElementAccess.Default(node);
                    access.flags = 2;
                    String mainName = SourceAnalyzer.this.resolveElementName(argValue, access, false);
                    SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    if (mainName != null) {
                        SourceAnalyzer.this.registerInEnvir(2, mainName, access);
                    }
                }
            }
            node.getArgsChild().acceptInRChildren(SourceAnalyzer.this);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private static class NodeArray
    extends ReturnValue {
        final RAstNode[] array;

        NodeArray(int returnType, RAstNode[] array) {
            super(returnType);
            this.array = array;
        }
    }

    private static class ReturnValue {
        final int returnType;

        ReturnValue(int returnType) {
            this.returnType = returnType;
        }
    }

    private class RoxygenAdapter
    implements IRoxygenAnalyzeContext {
        private RSourceModelInfo modelInfo;
        private int counter;

        private RoxygenAdapter() {
        }

        @Override
        public IRModelInfo getModelInfo() {
            return this.modelInfo;
        }

        @Override
        public void createSelfAccess(IRLangSourceElement element, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            RElementAccess elementAccess = ((RSourceElementByElementAccess)element).getAccess();
            if (elementAccess != null && text.equals(elementAccess.getSegmentName()) && elementAccess.getNextSegment() == null) {
                ElementAccess.Default access = new ElementAccess.Default(symbol.getRParent(), symbol);
                ((ElementAccess)elementAccess).shared.postAdd(access);
                return;
            }
        }

        @Override
        public void createNamespaceImportAccess(RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            ElementAccess.Namespace access = new ElementAccess.Namespace(symbol.getRParent(), symbol);
            access.flags |= 4;
            this.modelInfo.packageRefs.add(text, access);
        }

        @Override
        public void createNamespaceObjectImportAccess(IRFrameInSource namespace, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            if (namespace instanceof BuildSourceFrame) {
                ElementAccess.Default access = new ElementAccess.Default(symbol.getRParent(), symbol);
                BuildSourceFrame namespaceFrame = (BuildSourceFrame)namespace;
                BuildSourceFrame.ElementAccessList namespaceList = namespaceFrame.data.get(text);
                BuildSourceFrame next = this.modelInfo.localFrames.values().iterator().next();
                BuildSourceFrame.ElementAccessList defaultList = next.data.get(text);
                if (defaultList != null && defaultList.isCreated < 2) {
                    next.data.remove(text);
                    if (namespaceList != null) {
                        namespaceList.entries.addAll(defaultList.entries);
                        for (ElementAccess defaultAccess : defaultList.entries) {
                            defaultAccess.shared = namespaceList;
                        }
                        namespaceList.postAdd(access);
                    } else {
                        defaultList.frame = namespaceFrame;
                        defaultList.postAdd(access);
                        namespaceFrame.data.put(text, defaultList);
                    }
                } else if (namespaceList != null) {
                    namespaceList.postAdd(access);
                } else {
                    BuildSourceFrame.ElementAccessList accessList = new BuildSourceFrame.ElementAccessList(text);
                    accessList.frame = namespaceFrame;
                    accessList.postAdd(access);
                    namespaceFrame.data.put(text, accessList);
                }
            }
        }

        @Override
        public IRFrameInSource getNamespaceFrame(String name) {
            String id = BuildSourceFrame.createId(2, name, -1);
            BuildSourceFrame frame = this.modelInfo.namespaceFrames.get(id);
            if (frame == null) {
                frame = new BuildSourceFrame.DefScope(2, id, name, null);
                this.modelInfo.namespaceFrames.put(id, frame);
                return frame;
            }
            return null;
        }

        @Override
        public void createSlotAccess(RSourceElementByElementAccess.RClass rClass, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            BuildSourceFrame.ElementAccessList accessList = rClass.getBuildFrame().data.get(text);
            if (accessList == null) {
                return;
            }
            List<? extends IRLangSourceElement> children = rClass.getSourceChildren(null);
            for (IRLangSourceElement iRLangSourceElement : children) {
                if (iRLangSourceElement.getElementType() != 1664 || !text.equals(iRLangSourceElement.getElementName().getSegmentName())) continue;
                ElementAccess.Slot access = new ElementAccess.Slot(symbol.getRParent(), symbol);
                accessList.postAdd(access);
                return;
            }
        }

        @Override
        public void createArgAccess(RSourceElementByElementAccess.RMethod rMethod, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            BuildSourceFrame.ElementAccessList accessList = rMethod.getBuildFrame().data.get(text);
            if (accessList == null) {
                return;
            }
            List<? extends IRLangSourceElement> children = rMethod.getSourceChildren(null);
            for (IRLangSourceElement iRLangSourceElement : children) {
                if (iRLangSourceElement.getElementType() != 1585 || !text.equals(iRLangSourceElement.getElementName().getSegmentName())) continue;
                ElementAccess.Default access = new ElementAccess.Default(symbol.getRParent(), symbol);
                access.flags |= 0x20;
                accessList.postAdd(access);
                return;
            }
        }

        @Override
        public void createRSourceRegion(RAstNode node) {
            if (!SourceAnalyzer.this.roxygenExamples) {
                this.counter = 0;
                SourceAnalyzer.this.cleanup();
                SourceAnalyzer.this.init();
                SourceAnalyzer.this.roxygenExamples = true;
            }
            try {
                RoxygenRCodeElement element = new RoxygenRCodeElement(this.modelInfo.getSourceElement(), this.counter++, SourceAnalyzer.this.topLevelEnvir, node);
                SourceAnalyzer.this.enterElement(element, SourceAnalyzer.this.topLevelEnvir, node);
                node.acceptInRChildren(SourceAnalyzer.this);
                SourceAnalyzer.this.leaveElement();
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        public void update(RSourceModelInfo modelInfo) {
            this.modelInfo = modelInfo;
            SourceAnalyzer.this.roxygenAnalyzer.updateModel(SourceAnalyzer.this.roxygenAdapter);
        }
    }

    private static class Signature
    extends ReturnValue {
        private final ElementAccess[] argNameAccess;
        private final String[] classNames;

        Signature(ElementAccess[] argNameAccess, String[] classNames) {
            super(2);
            this.argNameAccess = argNameAccess;
            this.classNames = classNames;
        }
    }

    private static class SourceElementBuilder
    extends ReturnValue {
        private final SourceElementBuilder parent;
        private final IBuildSourceFrameElement element;
        private final List<RSourceElementByElementAccess> children;
        private final List<ElementAccess> toCheck;
        private final BuildSourceFrame envir;

        SourceElementBuilder(IBuildSourceFrameElement element, SourceElementBuilder parent, BuildSourceFrame envir) {
            super(1);
            this.element = element;
            this.parent = parent;
            this.children = new ArrayList<RSourceElementByElementAccess>();
            this.toCheck = new ArrayList<ElementAccess>();
            this.envir = envir;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SourceAnalyzer$SourceElementBuilder");
            sb.append("\n\tfor= ").append(this.element);
            sb.append("\n\tin= ").append(this.envir);
            return sb.toString();
        }
    }
}

