/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.ui.processing;

import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperationSettings;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.components.CustomizableVariableSelectionDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableTextValidator;
import org.eclipse.statet.internal.redocs.r.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.sourceediting.RTemplateSourceViewerConfigurator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class RunRConsoleSnippetOperationSettings
extends DocProcessingOperationSettings {
    private IObservableValue<String> snippetValue;
    private SnippetEditor1 snippetEditor;
    private VariableText2 snippetVariableResolver;

    public String getId() {
        return "org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation";
    }

    public String getLabel() {
        return Messages.ProcessingOperation_RunRConsoleSnippet_label;
    }

    public String getInfo() {
        String label = this.getLabel();
        String code = (String)this.snippetValue.getValue();
        return String.valueOf(label) + ":  " + this.limitInfo(code);
    }

    protected void init(DocProcessingConfigStepTab tab) {
        super.init(tab);
        Realm realm = this.getRealm();
        this.snippetValue = new WritableValue(realm, (Object)"", String.class);
    }

    protected Composite createControl(Composite parent) {
        Composite composite = super.createControl(parent);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.snippetVariableResolver = new VariableText2(this.getTab().getStepVariables());
        Label label = new Label(composite, 0);
        label.setText(Messages.ProcessingOperation_RunRConsoleSnippetSettings_RCode_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TemplateVariableProcessor templateVariableProcessor = new TemplateVariableProcessor();
        RTemplateSourceViewerConfigurator configurator = new RTemplateSourceViewerConfigurator(RCore.getWorkbenchAccess(), templateVariableProcessor);
        SnippetEditor1 editor = new SnippetEditor1((SourceEditorViewerConfigurator)configurator, null, (IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.statet.r.ui/launchingconfig", true){

            protected void fillToolMenu(Menu menu) {
                MenuItem item = new MenuItem(menu, 8);
                item.setText(SharedMessages.InsertVariable_label);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CustomizableVariableSelectionDialog dialog = new CustomizableVariableSelectionDialog(this.getTextControl().getShell());
                        dialog.addVariableFilter(VariableFilterUtils.EXCLUDE_JAVA_FILTER);
                        dialog.setAdditionals(RunRConsoleSnippetOperationSettings.this.snippetVariableResolver.getExtraVariables().values());
                        if (dialog.open() != 0) {
                            return;
                        }
                        String variable = dialog.getVariableExpression();
                        if (variable == null) {
                            return;
                        }
                        this.getTextControl().insert(variable);
                        this.getTextControl().setFocus();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText(Messages.ProcessingOperation_Insert_InFileLocVariable_label);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getTextControl().insert("${resource_loc}");
                        this.getTextControl().setFocus();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText(Messages.ProcessingOperation_Insert_OutFileLocVariable_label);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getTextControl().insert("${resource_loc:${out_file_path}}");
                        this.getTextControl().setFocus();
                    }
                });
            }
        };
        editor.create(composite, 0x2000B02);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = LayoutUtils.hintHeight((StyledText)editor.getSourceViewer().getTextWidget(), (int)5);
        editor.getControl().setLayoutData((Object)gd);
        this.snippetEditor = editor;
        return composite;
    }

    protected void addBindings(DataBindingContext dbc) {
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.snippetEditor.getTextControl()), this.snippetValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)new VariableTextValidator(this.snippetVariableResolver, Messages.ProcessingOperation_RunRConsoleSnippet_RCode_error_SpecInvalid_message))), null);
    }

    protected void load(Map<String, String> config) {
        String code = config.get("org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation/RSnippet.code");
        this.snippetValue.setValue((Object)(code != null ? code : ""));
    }

    protected void save(Map<String, String> config) {
        String code = (String)this.snippetValue.getValue();
        config.put("org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation/RSnippet.code", code);
    }
}

