/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.ui.BracketLevel;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ui.sourceediting.ISmartInsertSettings;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.nico.ui.console.InputSourceViewer;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.rsource.RSourceIndenter;
import org.eclipse.statet.r.core.rsource.ast.RScanner;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.statet.r.ui.sourceediting.RBracketLevel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class RAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy
implements ISourceEditorAddon {
    private static final char[] CURLY_BRACKETS = new char[]{'{', '}'};
    private static final StringParserInput DEFAULT_PARSER_INPUT = new StringParserInput();
    private final ISourceEditor editor;
    private final ITextEditorExtension3 editor3;
    private final DocContentSections documentContentInfo;
    private final SourceViewer viewer;
    private final RealTypeListener typeListener;
    private final IRCoreAccess rCoreAccess;
    private final REditorOptions editorOptions;
    private AbstractDocument document;
    private TextRegion validRange;
    private RHeuristicTokenScanner scanner;
    private RCodeStyleSettings rCodeStyle;
    private RSourceIndenter indenter;
    private boolean ignoreCommands = false;

    public RAutoEditStrategy(IRCoreAccess rCoreAccess, ISourceEditor editor) {
        assert (rCoreAccess != null);
        assert (editor != null);
        this.editor = editor;
        this.documentContentInfo = editor.getDocumentContentInfo();
        this.rCoreAccess = rCoreAccess;
        this.editorOptions = RUIPlugin.getInstance().getREditorSettings(rCoreAccess.getPrefs());
        assert (this.editorOptions != null);
        this.viewer = this.editor.getViewer();
        this.editor3 = editor instanceof SourceEditor1 ? (SourceEditor1)editor : null;
        this.typeListener = new RealTypeListener();
    }

    public void install(ISourceEditor editor) {
        assert (editor.getViewer() == this.viewer);
        this.viewer.prependVerifyKeyListener((VerifyKeyListener)this.typeListener);
    }

    public void uninstall() {
        this.viewer.removeVerifyKeyListener((VerifyKeyListener)this.typeListener);
    }

    private final ITypedRegion initCustomization(int offset, int c) throws BadLocationException, BadPartitioningException {
        assert (this.document != null);
        if (this.scanner == null) {
            this.scanner = this.createScanner();
        }
        this.rCodeStyle = this.rCoreAccess.getRCodeStyle();
        ITypedRegion partition = this.document.getPartition(this.scanner.getDocumentPartitioning(), offset, true);
        this.validRange = partition instanceof TreePartition ? this.getValidRange(offset, (TreePartition)partition, c) : new BasicTextRegion(0, this.document.getLength());
        return this.validRange != null ? partition : null;
    }

    protected RHeuristicTokenScanner createScanner() {
        return RHeuristicTokenScanner.create((DocContentSections)this.documentContentInfo);
    }

    protected TextRegion getValidRange(int offset, TreePartition partition, int c) {
        return new BasicTextRegion(0, this.document.getLength());
    }

    protected final IDocument getDocument() {
        return this.document;
    }

    protected final DocContentSections getDocumentContentInfo() {
        return this.documentContentInfo;
    }

    private final void quitCustomization() {
        this.document = null;
        this.rCodeStyle = null;
    }

    private final boolean isSmartInsertEnabled() {
        return this.editor3 != null ? this.editor3.getInsertMode() == ITextEditorExtension3.SMART_INSERT : this.editorOptions.isSmartInsertEnabledByDefault();
    }

    private final boolean isBlockSelection() {
        StyledText textWidget = this.viewer.getTextWidget();
        return textWidget.getBlockSelection() && textWidget.getSelectionRanges().length > 2;
    }

    private final boolean isClosedBracket(int backwardOffset, int forwardOffset, int searchType) {
        int[] balance = new int[3];
        int n = searchType;
        balance[n] = balance[n] + 1;
        this.scanner.configureDefaultPartitions((IDocument)this.document);
        balance = this.scanner.computeBracketBalance(backwardOffset, forwardOffset, balance, searchType);
        return balance[searchType] <= 0;
    }

    private final boolean isClosedString(int offset, int end, boolean endVirtual, char sep) {
        this.scanner.configure((IDocument)this.document);
        boolean in = true;
        char[] chars = new char[]{sep, '\\'};
        while (offset < end) {
            if ((offset = this.scanner.scanForward(offset, end, chars)) == -1) {
                offset = end;
                break;
            }
            ++offset;
            if (this.scanner.getChar() == '\\') {
                ++offset;
                continue;
            }
            boolean bl = in = !in;
        }
        return offset == end && !in ^ endVirtual;
    }

    private boolean isCharAt(int offset, char c) throws BadLocationException {
        return offset >= this.validRange.getStartOffset() && offset < this.validRange.getEndOffset() && this.document.getChar(offset) == c;
    }

    private boolean isValueChar(int offset) throws BadLocationException {
        if (offset >= this.validRange.getStartOffset() && offset < this.validRange.getEndOffset()) {
            char c = this.document.getChar(offset);
            return c == '\"' || c == '\'' || c == '`' || Character.isLetterOrDigit((int)c);
        }
        return false;
    }

    private boolean isAfterRoxygen(int offset) throws BadLocationException {
        IRegion prevLineInfo;
        this.scanner.configure((IDocument)this.document);
        int line = this.document.getLineOfOffset(offset);
        return line > 0 && this.scanner.findAnyNonBlankBackward(offset, this.document.getLineOffset(line) - 1, false) == -1 && (prevLineInfo = this.document.getLineInformation(line - 1)).getLength() > 0 && TextUtilities.getPartition((IDocument)this.document, (String)this.scanner.getDocumentPartitioning(), (int)(prevLineInfo.getOffset() + prevLineInfo.getLength() - 1), (boolean)false).getType() == "R.Roxygen";
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (this.ignoreCommands || !c.doit || c.text == null) {
            return;
        }
        if (!this.isSmartInsertEnabled() || this.isBlockSelection()) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        try {
            this.document = (AbstractDocument)d;
            ITypedRegion partition = this.initCustomization(c.offset, -1);
            if (partition == null) {
                return;
            }
            try {
                String contentType = partition.getType();
                if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                    if (c.length == 0 && TextUtilities.equals((String[])d.getLegalLineDelimiters(), (String)c.text) != -1) {
                        this.smartIndentOnNewLine(c, contentType);
                    } else if (c.text.length() > 1 && this.editorOptions.isSmartPasteEnabled()) {
                        this.smartPaste(c);
                    }
                }
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "An error occurred when customizing action for document command in R auto edit strategy.", (Throwable)e));
            }
        }
        finally {
            this.quitCustomization();
        }
    }

    private boolean customizeKeyPressed(char c) {
        if (!this.isSmartInsertEnabled() || !UIAccess.isOkToUse((Viewer)this.viewer) || this.isBlockSelection()) {
            return false;
        }
        try {
            this.document = (AbstractDocument)this.viewer.getDocument();
            ITextSelection selection = (ITextSelection)this.viewer.getSelection();
            ITypedRegion partition = this.initCustomization(selection.getOffset(), c);
            if (partition == null) {
                return false;
            }
            String contentType = partition.getType();
            this.ignoreCommands = true;
            DocumentCommand command = new DocumentCommand(){};
            command.offset = selection.getOffset();
            command.length = selection.getLength();
            command.doit = true;
            command.shiftsCaret = true;
            command.caretOffset = -1;
            int linkedMode = -1;
            int linkedModeOffset = -1;
            boolean contextInfo = false;
            int cEnd = command.offset + command.length;
            block16 : switch (c) {
                case '\t': {
                    if (!(!IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && contentType != "R.Comment" && contentType != "R.Roxygen" || command.length != 0 && this.document.getLineOfOffset(command.offset) != this.document.getLineOfOffset(cEnd))) {
                        command.text = "\t";
                        switch (this.smartIndentOnTab(command)) {
                            case -1: {
                                return false;
                            }
                            case 0: {
                                break;
                            }
                            case 1: {
                                break block16;
                            }
                        }
                        if (this.rCodeStyle.getReplaceOtherTabsWithSpaces()) {
                            IndentUtil indentation = new IndentUtil((IDocument)this.document, (IIndentSettings)this.rCodeStyle);
                            command.text = indentation.createTabSpacesCompletionString(indentation.getColumn(command.offset));
                            break;
                        }
                    }
                    return false;
                }
                case '}': {
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                        command.text = "}";
                        this.smartIndentOnClosingBracket(command);
                        break;
                    }
                    return false;
                }
                case '{': {
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                        command.text = "{";
                        if (this.editorOptions.isSmartCurlyBracketsEnabled() && !this.isValueChar(cEnd)) {
                            if (!this.isClosedBracket(command.offset, cEnd, 0)) {
                                command.text = "{}";
                                linkedMode = 0x1000001;
                            } else if (this.isCharAt(cEnd, '}')) {
                                linkedMode = 1;
                            }
                        }
                        linkedModeOffset = this.smartIndentOnFirstLineCharDefault2(command);
                        break;
                    }
                    return false;
                }
                case '(': {
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                        command.text = "(";
                        if (this.editorOptions.isSmartRoundBracketsEnabled() && !this.isValueChar(cEnd)) {
                            if (!this.isClosedBracket(command.offset, cEnd, 1)) {
                                command.text = "()";
                                linkedMode = 0x1000002;
                            } else if (this.isCharAt(cEnd, ')')) {
                                linkedMode = 2;
                            }
                        }
                        if (!this.isValueChar(command.offset - 1)) break;
                        contextInfo = true;
                        break;
                    }
                    return false;
                }
                case ')': {
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                        command.text = ")";
                        this.smartIndentOnFirstLineCharDefault2(command);
                        break;
                    }
                    return false;
                }
                case '[': {
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
                        command.text = "[";
                        if (!this.editorOptions.isSmartSquareBracketsEnabled() || this.isValueChar(cEnd)) break;
                        if (!this.isClosedBracket(command.offset, cEnd, 2)) {
                            command.text = "[]";
                            if (TextUtil.countBackward((IDocument)this.document, (int)command.offset, (char)'[') % 2 == 1 && this.isCharAt(cEnd, ']')) {
                                linkedMode = 0x1000003;
                                break;
                            }
                            linkedMode = 0x1000002;
                            break;
                        }
                        if (!this.isCharAt(cEnd, ']')) break;
                        linkedMode = 2;
                        break;
                    }
                    return false;
                }
                case '%': {
                    IRegion line;
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && this.editorOptions.isSmartSpecialPercentEnabled()) {
                        line = this.document.getLineInformationOfOffset(cEnd);
                        this.scanner.configure((IDocument)this.document, "R.Op.Infix");
                        if (this.scanner.count(cEnd, line.getOffset() + line.getLength(), '%') % 2 == 0) {
                            command.text = "%%";
                            linkedMode = 0x1000002;
                            break;
                        }
                    }
                    return false;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    IRegion line;
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && this.editorOptions.isSmartStringsEnabled() && !this.isValueChar(cEnd) && !this.isValueChar(command.offset - 1) && !this.isClosedString(cEnd, (line = this.document.getLineInformationOfOffset(cEnd)).getOffset() + line.getLength(), false, c)) {
                        command.text = new String(new char[]{c, c});
                        linkedMode = 0x1000002;
                        break;
                    }
                    return false;
                }
                case '\n': {
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) || contentType == "R.Comment") {
                        command.text = TextUtilities.getDefaultLineDelimiter((IDocument)this.document);
                        this.smartIndentOnNewLine(command, contentType);
                        break;
                    }
                    if (contentType == "R.Roxygen") {
                        command.text = TextUtilities.getDefaultLineDelimiter((IDocument)this.document);
                        this.smartIndentAfterNewLine1(command, command.text);
                        break;
                    }
                    return false;
                }
                case '#': {
                    if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && this.isAfterRoxygen(command.offset)) {
                        command.text = "#' ";
                        break;
                    }
                    return false;
                }
                default: {
                    assert (false);
                    return false;
                }
            }
            if (command.text.length() > 0 && this.editor.isEditable(true)) {
                this.viewer.getTextWidget().setRedraw(false);
                try {
                    this.document.replace(command.offset, command.length, command.text);
                    int cursor = command.caretOffset >= 0 ? command.caretOffset : command.offset + command.text.length();
                    selection = new TextSelection((IDocument)this.document, cursor, 0);
                    this.viewer.setSelection((ISelection)selection, true);
                    if (linkedMode >= 0) {
                        if (linkedModeOffset < 0) {
                            linkedModeOffset = command.offset;
                        }
                        this.createLinkedMode(linkedModeOffset, c, linkedMode).enter();
                    }
                }
                finally {
                    this.viewer.getTextWidget().setRedraw(true);
                }
                if (contextInfo && this.viewer.canDoOperation(14)) {
                    this.viewer.doOperation(14);
                }
            }
            return true;
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "An error occurred when customizing action for pressed key in R auto edit strategy.", (Throwable)e));
        }
        finally {
            this.ignoreCommands = false;
            this.quitCustomization();
        }
        return false;
    }

    private Position[] smartIndentLine2(DocumentCommand c, boolean indentCurrentLine, int setCaret, Position[] tracePos) throws BadLocationException, BadPartitioningException, CoreException {
        int dummyDocEnd;
        int line;
        String smartAppend;
        int smartEnd;
        if (this.editor3 == null) {
            return tracePos;
        }
        int cEnd = c.offset + c.length;
        TextRegion validRegion = this.validRange;
        if (cEnd > validRegion.getEndOffset()) {
            return tracePos;
        }
        this.scanner.configure((IDocument)this.document);
        if (this.endsWithNewLine(c.text)) {
            IRegion cEndLine = this.document.getLineInformationOfOffset(cEnd);
            int validEnd = cEndLine.getOffset() + cEndLine.getLength() <= validRegion.getEndOffset() ? cEndLine.getOffset() + cEndLine.getLength() : validRegion.getEndOffset();
            int next = this.scanner.findAnyNonBlankForward(cEnd, validEnd, false);
            smartEnd = next >= 0 ? next : validEnd;
            switch (this.scanner.getChar()) {
                case '&': 
                case '{': 
                case '|': 
                case '}': {
                    smartAppend = "";
                    break;
                }
                default: {
                    smartAppend = "DUMMY+";
                    break;
                }
            }
        } else {
            smartEnd = cEnd;
            smartAppend = "";
        }
        int shift = 0;
        if (c.offset < validRegion.getStartOffset() || c.offset > validRegion.getEndOffset()) {
            return tracePos;
        }
        if (c.offset > 2500 && (line = this.document.getLineOfOffset(c.offset) - 40) >= 10) {
            shift = this.document.getLineOffset(line);
            ITypedRegion partition = this.document.getPartition(this.scanner.getDocumentPartitioning(), shift, true);
            if (!IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(partition.getType())) {
                shift = partition.getOffset();
            }
        }
        if (shift < validRegion.getStartOffset()) {
            shift = validRegion.getStartOffset();
        }
        if ((dummyDocEnd = cEnd + 1500) > validRegion.getEndOffset()) {
            dummyDocEnd = validRegion.getEndOffset();
        }
        StringBuilder s = new StringBuilder(c.offset - shift + c.text.length() + (smartEnd - cEnd) + smartAppend.length() + (dummyDocEnd - smartEnd));
        s.append(this.document.get(shift, c.offset - shift));
        s.append(c.text);
        if (smartEnd - cEnd > 0) {
            s.append(this.document.get(cEnd, smartEnd - cEnd));
        }
        s.append(smartAppend);
        s.append(this.document.get(smartEnd, dummyDocEnd - smartEnd));
        String text = s.toString();
        int dummyCoffset = c.offset - shift;
        int dummyCend = dummyCoffset + c.text.length();
        Document dummyDoc = new Document(text);
        StringParserInput parserInput = Display.getCurrent() == Display.getDefault() ? DEFAULT_PARSER_INPUT.reset(text) : new StringParserInput(text);
        int dummyFirstLine = dummyDoc.getLineOfOffset(dummyCoffset);
        int dummyLastLine = dummyDoc.getLineOfOffset(dummyCend);
        if (!indentCurrentLine) {
            ++dummyFirstLine;
        }
        if (dummyFirstLine > dummyLastLine) {
            return tracePos;
        }
        RScanner scanner = new RScanner(1);
        SourceComponent rootNode = scanner.scanSourceUnit(parserInput.init());
        if (this.indenter == null) {
            this.indenter = new RSourceIndenter(this.scanner);
        }
        this.indenter.setup(this.rCoreAccess);
        TextEdit edit = this.indenter.getIndentEdits((AbstractDocument)dummyDoc, (AstNode)rootNode, 0, dummyFirstLine, dummyLastLine);
        Position cPos = new Position(dummyCoffset, c.text.length());
        dummyDoc.addPosition(cPos);
        if (tracePos != null) {
            int i = 0;
            while (i < tracePos.length) {
                tracePos[i].offset -= shift;
                dummyDoc.addPosition(tracePos[i]);
                ++i;
            }
        }
        c.length = c.length + edit.getLength() - TextUtil.overlaps((int)edit.getOffset(), (int)edit.getExclusiveEnd(), (int)dummyCoffset, (int)dummyCend);
        if (edit.getOffset() < dummyCoffset) {
            dummyCoffset = edit.getOffset();
            c.offset = shift + dummyCoffset;
        }
        edit.apply((IDocument)dummyDoc, 0);
        int dummyChangeEnd = edit.getExclusiveEnd();
        dummyCend = cPos.getOffset() + cPos.getLength();
        if (!cPos.isDeleted && dummyCend > dummyChangeEnd) {
            dummyChangeEnd = dummyCend;
        }
        c.text = dummyDoc.get(dummyCoffset, dummyChangeEnd - dummyCoffset);
        if (setCaret != 0) {
            c.caretOffset = shift + this.indenter.getNewIndentOffset(dummyFirstLine + setCaret - 1);
            c.shiftsCaret = false;
        }
        this.indenter.clear();
        if (tracePos != null) {
            int i = 0;
            while (i < tracePos.length) {
                tracePos[i].offset += shift;
                ++i;
            }
        }
        return tracePos;
    }

    private final boolean endsWithNewLine(String text) {
        int i = text.length() - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (c == '\r' || c == '\n') {
                return true;
            }
            if (c != ' ' && c != '\t') {
                return false;
            }
            --i;
        }
        return false;
    }

    private void smartIndentOnNewLine(DocumentCommand c, String partitionType) throws BadLocationException, BadPartitioningException, CoreException {
        int before = c.offset - 1;
        int behind = c.offset + c.length;
        String lineDelimiter = c.text;
        if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(partitionType) && before >= 0 && behind < this.validRange.getEndOffset() && this.document.getChar(before) == '{' && this.document.getChar(behind) == '}') {
            c.text = String.valueOf(c.text) + c.text;
        }
        try {
            this.smartIndentLine2(c, false, 1, null);
        }
        catch (Exception e) {
            RUIPlugin.logError(100, "An error occurred while customize a command in R auto edit strategy (algorithm 2).", e);
            this.smartIndentAfterNewLine1(c, lineDelimiter);
        }
    }

    private void smartIndentAfterNewLine1(DocumentCommand c, String lineDelimiter) throws BadLocationException, BadPartitioningException, CoreException {
        StringBuilder sb = new StringBuilder(c.text);
        int nlIndex = lineDelimiter.length();
        int line = this.document.getLineOfOffset(c.offset);
        int checkOffset = Math.max(0, c.offset);
        ITypedRegion partition = this.document.getPartition(this.scanner.getDocumentPartitioning(), checkOffset, true);
        if (partition.getType() == "R.Comment") {
            checkOffset = partition.getOffset();
        } else if (partition.getType() == "R.Roxygen") {
            checkOffset = -1;
            if (c.length == 0 && line + 1 < this.document.getNumberOfLines()) {
                int offset = this.document.getLineOffset(line + 1);
                this.scanner.configure((IDocument)this.document);
                int next = this.scanner.findAnyNonBlankForward(offset, -2, true);
                if (next >= 0 && this.scanner.getPartition(next).getType() == "R.Roxygen") {
                    sb.append("#' ");
                }
            }
            this.scanner.configure((IDocument)this.document);
        }
        IndentUtil util = new IndentUtil((IDocument)this.document, (IIndentSettings)this.rCodeStyle);
        int column = util.getLineIndent(line, false)[0];
        if (checkOffset > 0) {
            this.scanner.configure((IDocument)this.document);
            int match = this.scanner.findAnyNonBlankBackward(checkOffset, this.document.getLineOffset(line) - 1, false);
            if (match >= 0 && this.document.getChar(match) == '{') {
                String indent = util.createIndentString(util.getNextLevelColumn(column, 1));
                sb.insert(nlIndex, indent);
                nlIndex += indent.length() + lineDelimiter.length();
            }
        }
        if (nlIndex <= sb.length()) {
            sb.insert(nlIndex, util.createIndentString(column));
        }
        c.text = sb.toString();
    }

    private int smartIndentOnTab(DocumentCommand c) throws BadLocationException {
        IRegion line = this.document.getLineInformation(this.document.getLineOfOffset(c.offset));
        this.scanner.configure((IDocument)this.document);
        int first = this.scanner.findAnyNonBlankBackward(c.offset, line.getOffset() - 1, false);
        if (first != -1) {
            return 0;
        }
        IndentUtil indentation = new IndentUtil((IDocument)this.document, (IIndentSettings)this.rCodeStyle);
        int column = indentation.getColumn(c.offset);
        if (this.editorOptions.getSmartInsertTabAction() != ISmartInsertSettings.TabAction.INSERT_TAB_CHAR) {
            c.text = indentation.createIndentCompletionString(column);
        }
        return 1;
    }

    private void smartIndentOnClosingBracket(DocumentCommand c) throws BadLocationException {
        int lineOffset = this.document.getLineOffset(this.document.getLineOfOffset(c.offset));
        this.scanner.configure((IDocument)this.document);
        if (this.scanner.findAnyNonBlankBackward(c.offset, lineOffset - 1, false) != -1) {
            return;
        }
        try {
            Position cursorPos = new Position(c.offset + 1, 0);
            this.smartIndentLine2(c, true, 0, new Position[]{cursorPos});
            c.caretOffset = cursorPos.getOffset();
            return;
        }
        catch (Exception e) {
            RUIPlugin.logError(100, "An error occurred while customize a command in R auto edit strategy (algorithm 2).", e);
            this.smartIndentOnClosingBracket1(c);
            return;
        }
    }

    private void smartIndentOnClosingBracket1(DocumentCommand c) throws BadLocationException {
        int lineOffset = this.document.getLineOffset(this.document.getLineOfOffset(c.offset));
        int blockStart = this.scanner.findOpeningPeer(lineOffset, CURLY_BRACKETS);
        if (blockStart == -1) {
            return;
        }
        IndentUtil util = new IndentUtil((IDocument)this.document, (IIndentSettings)this.rCodeStyle);
        int column = util.getLineIndent(this.document.getLineOfOffset(blockStart), false)[0];
        c.text = String.valueOf(util.createIndentString(column)) + c.text;
        c.length += c.offset - lineOffset;
        c.offset = lineOffset;
    }

    private int smartIndentOnFirstLineCharDefault2(DocumentCommand c) throws BadLocationException {
        int lineOffset = this.document.getLineOffset(this.document.getLineOfOffset(c.offset));
        this.scanner.configure((IDocument)this.document);
        if (this.scanner.findAnyNonBlankBackward(c.offset, lineOffset - 1, false) != -1) {
            return c.offset;
        }
        try {
            Position cursorPos = new Position(c.offset + 1, 0);
            this.smartIndentLine2(c, true, 0, new Position[]{cursorPos});
            c.caretOffset = cursorPos.getOffset();
            return c.caretOffset - 1;
        }
        catch (Exception e) {
            RUIPlugin.logError(100, "An error occurred while customize a command in R auto edit strategy (algorithm 2).", e);
            return -1;
        }
    }

    private void smartPaste(DocumentCommand c) throws BadLocationException {
        int lineOffset = this.document.getLineOffset(this.document.getLineOfOffset(c.offset));
        this.scanner.configure((IDocument)this.document);
        boolean firstLine = this.scanner.findAnyNonBlankBackward(c.offset, lineOffset - 1, false) == -1;
        try {
            this.smartIndentLine2(c, firstLine, 0, null);
        }
        catch (Exception e) {
            RUIPlugin.logError(100, "An error occurred while customize a command in R auto edit strategy (algorithm 2).", e);
        }
    }

    private LinkedModeUI createLinkedMode(int offset, char type, int mode) throws BadLocationException {
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        LinkedPositionGroup group = new LinkedPositionGroup();
        BracketLevel.InBracketPosition position = RBracketLevel.createPosition(type, (IDocument)this.document, offset + 1, 0, pos++);
        group.addPosition((LinkedPosition)position);
        model.addGroup(group);
        model.forceInstall();
        RBracketLevel level = new RBracketLevel(model, this.getDocument(), this.getDocumentContentInfo(), (List<LinkedPosition>)ImCollections.newList((Object)position), mode & 0xFFFF0000 | (this.viewer instanceof InputSourceViewer ? 1 : 0));
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)this.viewer);
        ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        ui.setExitPosition((ITextViewer)this.viewer, offset + (mode & 0xFF), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    private class RealTypeListener
    implements VerifyKeyListener {
        private RealTypeListener() {
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '#': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '[': 
                case '`': 
                case '{': 
                case '}': {
                    event.doit = !RAutoEditStrategy.this.customizeKeyPressed(event.character);
                    return;
                }
                case '\t': {
                    if (event.stateMask == 0) {
                        event.doit = !RAutoEditStrategy.this.customizeKeyPressed(event.character);
                    }
                    return;
                }
                case '\n': 
                case '\r': {
                    if (RAutoEditStrategy.this.editor3 != null) {
                        event.doit = !RAutoEditStrategy.this.customizeKeyPressed('\n');
                    }
                    return;
                }
            }
        }
    }
}

