/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.swt.graphics.FontData;

public class DefaultBrowserInformationInput
extends BrowserInformationControlInput {
    private static Formatter FORMATTER;
    public static final int FORMAT_NONE = 0;
    public static final int FORMAT_HTMLBODY_INPUT = 1;
    public static final int FORMAT_TEXT_INPUT = 2;
    public static final int FORMAT_SOURCE_INPUT = 3;
    private final String fName;
    private final String fHtml;

    public DefaultBrowserInformationInput(BrowserInformationControlInput previous, String name, String content, int formatting) {
        super(previous);
        this.fName = name;
        this.fHtml = this.getFormatter().format(content, formatting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Formatter getFormatter() {
        Class<DefaultBrowserInformationInput> clazz = DefaultBrowserInformationInput.class;
        synchronized (DefaultBrowserInformationInput.class) {
            if (FORMATTER == null) {
                FORMATTER = new Formatter();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return FORMATTER;
        }
    }

    public String getInputName() {
        return this.fName;
    }

    public Object getInputElement() {
        return this.fHtml;
    }

    public String getHtml() {
        return this.fHtml;
    }

    private static class Formatter
    implements IPropertyChangeListener,
    Disposable {
        private static final Pattern TAB_PATTERN = Pattern.compile("\\\t");
        private String STYLE_SHEET;

        public Formatter() {
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            LTKUIPlugin.getInstance().addStoppingListener(this);
            this.updateStyleSheet();
        }

        public void dispose() {
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
            FORMATTER = null;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.jface.dialogfont")) {
                this.updateStyleSheet();
            }
        }

        private void updateStyleSheet() {
            String style = "html         { font-family: sans-serif; font-size: 9pt; font-style: normal; font-weight: normal; }\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt { font-size: 1em; }\npre          { font-family: monospace; }\nhtml         { margin: 0px; padding: 0px }body         { overflow: auto; margin-top: 0.25em; margin-bottom: 0.5em; margin-left: 0.25em; margin-right: 0.25em; }\nh1           { margin-top: 0.3em; margin-bottom: 0.04em; }\nh2           { margin-top: 2em; margin-bottom: 0.25em; }\nh3           { margin-top: 1.7em; margin-bottom: 0.25em; }\nh4           { margin-top: 2em; margin-bottom: 0.3em; }\nh5           { margin-top: 0px; margin-bottom: 0px; }\np            { margin-top: 1em; margin-bottom: 1em; }\nul           { margin-top: 0px; margin-bottom: 1em; }\nli           { margin-top: 0px; margin-bottom: 0px; }\nli p         { margin-top: 0px; margin-bottom: 0px; }\nol           { margin-top: 0px; margin-bottom: 1em; }\ndl           { margin-top: 0px; margin-bottom: 1em; }\ndt           { margin-top: 0px; margin-bottom: 0px; font-weight: bold; }\ndd           { margin-top: 0px; margin-bottom: 0px; }\na:link       { color: #0000FF; }\na:hover      { color: #000080; }\na:visited    { text-decoration: underline; }\nh4           { font-style: italic; }\nstrong       { font-weight: bold; }\nem           { font-style: italic; }\nvar          { font-style: italic; }\nth           { font-weight: bold; }\n";
            try {
                FontData[] fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont");
                if (fontData != null && fontData.length > 0) {
                    style = style.replace("9pt", String.valueOf(fontData[0].getHeight()) + "pt");
                    style = style.replace("sans-serif", "sans-serif, '" + fontData[0].getName() + "'");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.STYLE_SHEET = style;
        }

        String format(String content, int formatting) {
            StringBuffer s;
            switch (formatting) {
                case 0: {
                    return content;
                }
                case 2: {
                    content = HTMLPrinter.convertToHTMLContent((String)content);
                    s = new StringBuffer(content.length() + 1000);
                    s.append(content);
                    break;
                }
                case 3: {
                    content = HTMLPrinter.convertToHTMLContent((String)content);
                    Matcher matcher = TAB_PATTERN.matcher(content);
                    if (matcher.find()) {
                        content = matcher.replaceAll("    ");
                    }
                    s = new StringBuffer(content.length() + 1000);
                    s.append("<pre>");
                    s.append(content);
                    s.append("</pre>");
                    break;
                }
                case 1: {
                    s = new StringBuffer(content.length() + 1000);
                    s.append(content);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported format");
                }
            }
            HTMLPrinter.insertPageProlog((StringBuffer)s, (int)0, (String)this.STYLE_SHEET);
            HTMLPrinter.addPageEpilog((StringBuffer)s);
            return s.toString();
        }
    }
}

