/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

abstract class ExpressionList
extends RAstNode {
    final List<Expression> expressions = new ArrayList<Expression>();

    ExpressionList() {
    }

    @Override
    public final boolean hasChildren() {
        return this.expressions.size() > 0;
    }

    @Override
    public final RAstNode[] getChildren() {
        int n = this.expressions.size();
        RAstNode[] children = new RAstNode[n];
        int i = 0;
        while (i < n) {
            children[i] = this.expressions.get((int)i).node;
            ++i;
        }
        return children;
    }

    @Override
    public final int getChildIndex(AstNode child) {
        int i = this.expressions.size() - 1;
        while (i >= 0) {
            if (this.expressions.get((int)i).node == child) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public final int getChildCount() {
        return this.expressions.size();
    }

    @Override
    public final RAstNode getChild(int i) {
        return this.expressions.get((int)i).node;
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.acceptChildrenExpr(visitor, this.expressions);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        for (Expression expr : this.expressions) {
            visitor.visit((AstNode)expr.node);
        }
    }

    @Override
    final Expression getExpr(RAstNode child) {
        int i = this.expressions.size() - 1;
        while (i >= 0) {
            if (this.expressions.get((int)i).node == child) {
                return this.expressions.get(i);
            }
            --i;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return null;
    }

    @Override
    final Expression getRightExpr() {
        return null;
    }

    Expression appendNewExpr() {
        Expression expr = new Expression();
        this.expressions.add(expr);
        return expr;
    }

    void setSeparator(int offset) {
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        return 4864;
    }
}

