/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.layer.DataLayer;
import org.eclipse.statet.ecommons.waltable.resize.MultiColumnResizeCommand;

public class MultiColumnResizeCommandHandler
extends AbstractLayerCommandHandler<MultiColumnResizeCommand> {
    private final DataLayer dataLayer;

    public MultiColumnResizeCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<MultiColumnResizeCommand> getCommandClass() {
        return MultiColumnResizeCommand.class;
    }

    @Override
    protected boolean doCommand(MultiColumnResizeCommand command) {
        LRangeList.ValueIterator columnIter = new LRangeList.ValueIterator(command.getPositions());
        while (columnIter.hasNext()) {
            long columnPosition = columnIter.nextValue();
            this.dataLayer.setColumnWidthByPosition(columnPosition, command.getColumnWidth(columnPosition));
        }
        return true;
    }
}

