/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.statet.ltk.refactoring.core.DynamicValidationChange;

public final class DynamicValidationRefactoringChange
extends DynamicValidationChange {
    private final RefactoringDescriptor descriptor;
    private ReorgExecutionLog executionLog;

    public DynamicValidationRefactoringChange(RefactoringDescriptor descriptor, String name) {
        super(name);
        assert (descriptor != null);
        this.descriptor = descriptor;
    }

    public DynamicValidationRefactoringChange(RefactoringDescriptor descriptor, String name, Change[] changes, ReorgExecutionLog executionLog) {
        super(name, changes);
        assert (descriptor != null);
        this.descriptor = descriptor;
        this.executionLog = executionLog;
    }

    public ChangeDescriptor getDescriptor() {
        return new RefactoringChangeDescriptor(this.descriptor);
    }

    public Change perform(IProgressMonitor progress) throws CoreException {
        try {
            return super.perform(progress);
        }
        catch (OperationCanceledException e) {
            if (this.executionLog != null) {
                this.executionLog.markAsCanceled();
            }
            throw e;
        }
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ReorgExecutionLog.class) {
            return (T)this.executionLog;
        }
        return (T)super.getAdapter(adapterType);
    }
}

