/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.IModelManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;

public abstract class SourceUnitModelContainer<U extends ISourceUnit, M extends ISourceUnitModelInfo> {
    private final WorkingContext mode;
    private final U unit;
    private AstInfo astInfo;
    private M modelInfo;

    public SourceUnitModelContainer(U unit) {
        this.unit = unit;
        this.mode = this.getMode(unit);
    }

    public abstract boolean isContainerFor(String var1);

    public abstract Class<?> getAdapterClass();

    protected WorkingContext getMode(U su) {
        if (su instanceof IWorkspaceSourceUnit) {
            return su.getWorkingContext();
        }
        return null;
    }

    protected final WorkingContext getMode() {
        return this.mode;
    }

    public U getSourceUnit() {
        return this.unit;
    }

    public SourceContent getParseContent(IProgressMonitor monitor) {
        return this.unit.getContent(monitor);
    }

    public AstInfo getAstInfo(boolean ensureSync, IProgressMonitor monitor) {
        if (ensureSync) {
            this.getModelManager().reconcile(this, 1, monitor);
        }
        return this.astInfo;
    }

    public M getModelInfo(int syncLevel, IProgressMonitor monitor) {
        if ((syncLevel & 0x1000000) != 0) {
            this.clear();
        }
        if ((syncLevel & 0xF) >= 2) {
            M currentModel = this.modelInfo;
            if ((syncLevel & 0x2000000) != 0 || currentModel == null || currentModel.getStamp().getSourceStamp() == 0L || currentModel.getStamp().getSourceStamp() != this.unit.getContentStamp(monitor)) {
                this.getModelManager().reconcile(this, syncLevel, monitor);
            }
        }
        return this.modelInfo;
    }

    protected abstract IModelManager getModelManager();

    public void clear() {
        this.astInfo = null;
        this.modelInfo = null;
    }

    public AstInfo getCurrentAst() {
        if (this.mode == LTK.PERSISTENCE_CONTEXT) {
            M model = this.getCurrentModel();
            if (model != null) {
                return model.getAst();
            }
            return null;
        }
        return this.astInfo;
    }

    public void setAst(AstInfo ast) {
        if (this.mode == LTK.PERSISTENCE_CONTEXT) {
            return;
        }
        this.astInfo = ast;
    }

    public M getCurrentModel() {
        return this.modelInfo;
    }

    public void setModel(M modelInfo) {
        if (modelInfo != null && (this.astInfo == null || this.astInfo.getStamp().equals(modelInfo.getAst().getStamp()))) {
            this.setAst(modelInfo.getAst());
        }
        this.modelInfo = modelInfo;
    }

    public ProblemRequestor createProblemRequestor() {
        return null;
    }
}

