/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.ClassLoaderUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.server.util.PathEntry;

@NonNullByDefault
public abstract class PathEntryProvider {
    private static final String FILE_PROTOCOL_REGEX = "\\Qfile:/\\E";
    private static final String JAR_FILE_PROTOCOL_REGEX = "\\Qjar:file:/\\E";
    private static final String BUNDLE_ID_REGEX = "[a-z]+(?:\\.?[a-z]+)*";
    private static final String VER_1_REGEX = "\\_\\d+\\.\\d+[^!/]+";
    private static final String VER_2_REGEX = "\\-\\d+\\.\\d+[^!/]+";
    private static final String JAR_REGEX = "\\Q.jar\\E";
    private static final String AUTODETECT_REGEX = "(?:(\\Qfile:/\\E.*)/[a-z]+(?:\\.?[a-z]+)*\\Q/bin/\\E|(\\Qjar:file:/\\E.*)/[a-z]+(?:\\.?[a-z]+)*(?:(\\_\\d+\\.\\d+[^!/]+)|(\\-\\d+\\.\\d+[^!/]+))?\\Q.jar\\E\\Q!/\\E)";
    private static final Pattern AUTODETECT_PATTERN = Pattern.compile("(?:(\\Qfile:/\\E.*)/[a-z]+(?:\\.?[a-z]+)*\\Q/bin/\\E|(\\Qjar:file:/\\E.*)/[a-z]+(?:\\.?[a-z]+)*(?:(\\_\\d+\\.\\d+[^!/]+)|(\\-\\d+\\.\\d+[^!/]+))?\\Q.jar\\E\\Q!/\\E)");
    private static final Pattern JAR_VER_0_PATTERN = Pattern.compile("(.+?)\\Q.jar\\E");
    private static final Pattern JAR_VER_1_PATTERN = Pattern.compile("(.+?)\\_\\d+\\.\\d+[^!/]+\\Q.jar\\E");
    private static final Pattern JAR_VER_2_PATTERN = Pattern.compile("(.+?)\\-\\d+\\.\\d+[^!/]+\\Q.jar\\E");
    private final ImList<Path> baseDirectories;
    private final List<Closeable> closeables;

    public static PathEntryProvider detectLibPaths(Class<?> refClass, @Nullable List<Path> expliciteBaseDirectories) throws RjInitFailedException {
        String refUrl = null;
        try {
            refUrl = ClassLoaderUtils.getClassLocationUrlString(refClass);
            return PathEntryProvider.detectLibPaths(refUrl, expliciteBaseDirectories);
        }
        catch (Exception e) {
            throw new RjInitFailedException(String.format("Failed to autodetect RJ library location\n\tclass= %1$s\n\turl= %2$s", refClass != null ? refClass.getName() : "<NA>", refUrl != null ? String.valueOf('\'') + refUrl + '\'' : "<NA>"), e);
        }
    }

    static PathEntryProvider detectLibPaths(String refUrl, @Nullable List<Path> expliciteBaseDirectories) throws Exception {
        ImList closeables = ImCollections.emptyList();
        try {
            Matcher matcher = AUTODETECT_PATTERN.matcher(refUrl);
            if (matcher.matches()) {
                PathEntryProvider provider;
                ImList baseDirectories;
                Path detectedBaseDirectory;
                URI detectedBaseUri;
                String s;
                int detectedType;
                if (matcher.start(1) != -1) {
                    detectedType = 1;
                    s = (String)ObjectUtils.nonNullAssert((Object)matcher.group(1));
                    detectedBaseUri = new URI(s);
                } else if (matcher.start(2) != -1) {
                    detectedType = 2;
                    s = (String)ObjectUtils.nonNullAssert((Object)matcher.group(2));
                    detectedBaseUri = s.indexOf("!/") == -1 ? new URI(s.substring(4)) : new URI(s);
                } else {
                    throw new IllegalStateException();
                }
                while (true) {
                    try {
                        detectedBaseDirectory = Paths.get(detectedBaseUri);
                    }
                    catch (FileSystemNotFoundException e) {
                        HashMap<String, String> fsEnv = new HashMap<String, String>();
                        fsEnv.put("create", "true");
                        try {
                            FileSystem fileSystem = FileSystems.newFileSystem(detectedBaseUri, fsEnv);
                        }
                        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {}
                        continue;
                    }
                    break;
                }
                detectedBaseDirectory = detectedBaseDirectory.normalize();
                if (expliciteBaseDirectories != null && !expliciteBaseDirectories.isEmpty()) {
                    ArrayList<Path> uniqueList = new ArrayList<Path>();
                    for (Path baseDirectory : expliciteBaseDirectories) {
                        if (uniqueList.contains(baseDirectory = baseDirectory.normalize())) continue;
                        uniqueList.add(baseDirectory);
                    }
                    if (!uniqueList.contains(detectedBaseDirectory)) {
                        uniqueList.add(detectedBaseDirectory);
                    }
                    baseDirectories = ImCollections.toList(uniqueList);
                } else {
                    baseDirectories = ImCollections.newList((Object)detectedBaseDirectory);
                }
                if (detectedType == 1) {
                    provider = new DevBinPathEntryProvider((ImList<Path>)baseDirectories, (List<Closeable>)closeables);
                } else {
                    Pattern fileNamePattern = matcher.start(3) != -1 ? JAR_VER_1_PATTERN : (matcher.start(4) != -1 ? JAR_VER_2_PATTERN : JAR_VER_0_PATTERN);
                    provider = new JarFilePathEntryProvider((ImList<Path>)baseDirectories, fileNamePattern, (List<Closeable>)closeables);
                }
                closeables = null;
                DevBinPathEntryProvider devBinPathEntryProvider = provider;
                return devBinPathEntryProvider;
            }
            throw new UnsupportedOperationException("url= " + refUrl);
        }
        finally {
            if (closeables != null) {
                PathEntryProvider.close((List<Closeable>)closeables);
            }
        }
    }

    private static void close(List<Closeable> closeables) {
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.server", "An error occurred when disposing closable of path entry provider.", (Throwable)e));
            }
        }
    }

    protected PathEntryProvider(ImList<Path> baseDirectories, List<Closeable> closeables) {
        this.baseDirectories = baseDirectories;
        this.closeables = closeables;
    }

    public void dispose() {
        PathEntryProvider.close(this.closeables);
    }

    protected ImList<Path> getBaseDirectories() {
        return this.baseDirectories;
    }

    public void getEntries(List<PathEntry> entries) {
        for (Path baseDirectory : this.baseDirectories) {
            try {
                this.getEntries(baseDirectory, entries);
            }
            catch (Exception e) {
                CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.server", String.format("An error occurred when looking for path entries in '%1$s'.", baseDirectory), (Throwable)e));
            }
        }
    }

    protected abstract void getEntries(Path var1, List<PathEntry> var2) throws IOException;

    public int hashCode() {
        return this.getClass().hashCode() + this.baseDirectories.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            PathEntryProvider other = (PathEntryProvider)obj;
            return this.baseDirectories.equals(other.baseDirectories);
        }
        return false;
    }

    public static class DevBinPathEntryProvider
    extends PathEntryProvider {
        public DevBinPathEntryProvider(ImList<Path> baseDirectories, List<Closeable> closeables) {
            super(baseDirectories, closeables);
        }

        @Override
        public void getEntries(Path baseDirectory, List<PathEntry> entries) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DirectoryStream<Path> children = Files.newDirectoryStream(baseDirectory);){
                for (Path child : children) {
                    Path devBin = child.resolve("bin");
                    if (!Files.isDirectory(devBin, new LinkOption[0])) continue;
                    String bundleId = child.getFileName().toString();
                    entries.add(new PathEntry(bundleId, devBin){

                        @Override
                        public @Nullable Path getResourcePath(String resource) {
                            Path path = super.getResourcePath(resource);
                            if (path != null) {
                                return path;
                            }
                            path = this.getPath().resolveSibling(resource);
                            if (Files.exists(path, new LinkOption[0])) {
                                return path;
                            }
                            return null;
                        }
                    });
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static class JarFilePathEntryProvider
    extends PathEntryProvider {
        private final Pattern namePattern;

        public JarFilePathEntryProvider(ImList<Path> baseDirectories, Pattern namePattern, List<Closeable> closeables) {
            super(baseDirectories, closeables);
            this.namePattern = namePattern;
        }

        @Override
        public void getEntries(Path baseDirectory, List<PathEntry> entries) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DirectoryStream<Path> children = Files.newDirectoryStream(baseDirectory);){
                for (Path child : children) {
                    Matcher nameMatcher = this.namePattern.matcher(child.getFileName().toString());
                    if (!nameMatcher.matches() || !Files.isRegularFile(child, new LinkOption[0])) continue;
                    String bundleId = (String)ObjectUtils.nonNullAssert((Object)nameMatcher.group(1));
                    entries.add(new PathEntry.Jar(bundleId, child));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Nullable String getBundleId(String fileName) {
            Matcher nameMatcher = this.namePattern.matcher(fileName);
            if (nameMatcher.matches()) {
                return nameMatcher.group(1);
            }
            return null;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.namePattern.hashCode() * 17;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) && this.namePattern.pattern().equals(((JarFilePathEntryProvider)obj).namePattern.pattern());
        }
    }
}

