/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.ui.actions.CollapseAllHandler;
import org.eclipse.statet.ecommons.ui.actions.ExpandAllHandler;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractEditorOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable,
IPostSelectionProvider {
    private TreeViewer fTreeViewer;
    private ISelection fCurrentSelection;
    private final FastList<ISelectionChangedListener> fSelectionListeners = new FastList(ISelectionChangedListener.class);
    private final ISelectionChangedListener fSelectionListener = new SelectionChangeNotify(this.fSelectionListeners);
    private final FastList<ISelectionChangedListener> fPostSelectionListeners = new FastList(ISelectionChangedListener.class);
    private final ISelectionChangedListener fPostSelectionListener = new SelectionChangeNotify(this.fPostSelectionListeners);
    private int fIgnoreSelection;
    private final String fContextMenuID;
    private Menu fContextMenu;
    private final HandlerCollection fHandlers = new HandlerCollection();
    private final FastList<IHandler2> fHandlersToUpdate = new FastList(IHandler2.class);

    public AbstractEditorOutlinePage(String contextMenuId) {
        this.fContextMenuID = contextMenuId;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    protected abstract IDialogSettings getDialogSettings();

    public void createControl(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        viewer.setUseHashlookup(true);
        this.configureViewer(viewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        this.fTreeViewer = viewer;
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractEditorOutlinePage.this.fCurrentSelection = event.getSelection();
            }
        });
        final IPageSite site = this.getSite();
        this.initActions((IServiceLocator)site, this.fHandlers);
        this.fSelectionListeners.add((Object)new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AbstractEditorOutlinePage.this.getControl().isVisible()) {
                    IHandler2[] handlers;
                    EvaluationContext evaluationContext = new EvaluationContext(null, (Object)event.getSelection());
                    evaluationContext.addVariable("activeSite", (Object)site);
                    evaluationContext.addVariable("selection", (Object)event.getSelection());
                    IHandler2[] iHandler2Array = handlers = (IHandler2[])AbstractEditorOutlinePage.this.fHandlersToUpdate.toArray();
                    int n = handlers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IHandler2 handler = iHandler2Array[n2];
                        handler.setEnabled((Object)evaluationContext);
                        ++n2;
                    }
                }
            }
        });
        this.contributeToActionBars((IServiceLocator)site, site.getActionBars(), this.fHandlers);
        this.hookContextMenu();
        this.init();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager(this.fContextMenuID, this.fContextMenuID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                AbstractEditorOutlinePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fContextMenu = menuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(this.fContextMenu);
        this.getSite().registerContextMenu(this.fContextMenuID, menuManager, (ISelectionProvider)this.fTreeViewer);
    }

    public Control getControl() {
        if (this.fTreeViewer != null) {
            return this.fTreeViewer.getControl();
        }
        return null;
    }

    public void setFocus() {
        TreeViewer viewer = this.getViewer();
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            viewer.getTree().setFocus();
        }
    }

    protected abstract void configureViewer(TreeViewer var1);

    protected void init() {
    }

    protected void beginIgnoreSelection() {
        ++this.fIgnoreSelection;
    }

    protected void endIgnoreSelection(boolean async) {
        if (async) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractEditorOutlinePage abstractEditorOutlinePage = AbstractEditorOutlinePage.this;
                    abstractEditorOutlinePage.fIgnoreSelection = abstractEditorOutlinePage.fIgnoreSelection - 1;
                }
            });
        } else {
            --this.fIgnoreSelection;
        }
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
        TreeViewer viewer = this.getViewer();
        this.fPostSelectionListeners.add((Object)new DefaultSelectionListener());
        viewer.addSelectionChangedListener(this.fSelectionListener);
        viewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        AbstractHandler handler = new CollapseAllHandler((AbstractTreeViewer)this.getViewer()){

            @Override
            public Object execute(ExecutionEvent event) {
                TreeViewer viewer = AbstractEditorOutlinePage.this.getViewer();
                if (UIAccess.isOkToUse((Viewer)viewer)) {
                    AbstractEditorOutlinePage.this.beginIgnoreSelection();
                    try {
                        Object object = super.execute(event);
                        return object;
                    }
                    finally {
                        AbstractEditorOutlinePage.this.endIgnoreSelection(true);
                    }
                }
                return null;
            }
        };
        handlers.add("org.eclipse.ui.navigate.collapseAll", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)handler);
        handler = new ExpandAllHandler((AbstractTreeViewer)this.getViewer());
        handlers.add("org.eclipse.ui.navigate.expandAll", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.ui.navigate.expandAll", (IHandler)handler);
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("view.expand"));
        toolBarManager.appendToGroup("view.expand", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.navigate.collapseAll", 8), handlers));
        toolBarManager.add((IContributionItem)new Separator("view.sort"));
        Separator viewFilter = new Separator("view.filter");
        viewFilter.setVisible(false);
        toolBarManager.add((IContributionItem)viewFilter);
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
    }

    public void dispose() {
        this.fHandlers.dispose();
        this.fHandlersToUpdate.clear();
        this.fPostSelectionListeners.clear();
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
            this.fContextMenu = null;
        }
    }

    protected TreeViewer getViewer() {
        return this.fTreeViewer;
    }

    protected abstract void selectInEditor(ISelection var1);

    protected void registerHandlerToUpdate(IHandler2 handler) {
        this.fHandlersToUpdate.add((Object)handler);
    }

    public void setSelection(ISelection selection) {
        TreeViewer viewer = this.getViewer();
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            viewer.setSelection(selection);
        }
    }

    public ISelection getSelection() {
        ISelection selection = this.fCurrentSelection;
        if (selection != null) {
            return selection;
        }
        if (this.fTreeViewer != null) {
            return this.fTreeViewer.getSelection();
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionListeners.remove((Object)listener);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return null;
    }

    protected abstract class AbstractToggleHandler
    extends AbstractHandler
    implements IElementUpdater {
        private final String fSettingsKey;
        private final String fCommandId;
        private final int fTime;
        private boolean fIsChecked;

        public AbstractToggleHandler(String checkSettingsKey, boolean checkSettingsDefault, String commandId, int expensive) {
            boolean on;
            assert (checkSettingsKey != null);
            this.fSettingsKey = checkSettingsKey;
            this.fCommandId = commandId;
            this.fTime = expensive;
            IDialogSettings settings = AbstractEditorOutlinePage.this.getDialogSettings();
            this.fIsChecked = on = settings.get(this.fSettingsKey) == null ? checkSettingsDefault : AbstractEditorOutlinePage.this.getDialogSettings().getBoolean(this.fSettingsKey);
            this.apply(on);
        }

        protected void init() {
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, element);
            try {
                element.setChecked(this.isChecked());
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }

        public boolean isChecked() {
            return this.fIsChecked;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            this.fIsChecked = !this.fIsChecked;
            final boolean on = this.fIsChecked;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractToggleHandler.this.apply(on);
                    AbstractEditorOutlinePage.this.getDialogSettings().put(AbstractToggleHandler.this.fSettingsKey, on);
                }
            };
            if (this.fTime == 0) {
                runnable.run();
            } else {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
            }
            if (this.fCommandId != null) {
                WorkbenchUIUtils.refreshCommandElements(this.fCommandId, (IHandler2)this, null);
            }
            return null;
        }

        protected abstract void apply(boolean var1);
    }

    private class DefaultSelectionListener
    implements ISelectionChangedListener {
        private DefaultSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (AbstractEditorOutlinePage.this.fIgnoreSelection == 0) {
                AbstractEditorOutlinePage.this.selectInEditor(event.getSelection());
            }
        }
    }

    private static class SelectionChangeNotify
    extends SafeRunnable
    implements ISelectionChangedListener {
        private final FastList<ISelectionChangedListener> fSelectionListeners;
        private SelectionChangedEvent fCurrentEvent;
        private ISelectionChangedListener fCurrentListener;

        public SelectionChangeNotify(FastList<ISelectionChangedListener> listenerList) {
            this.fSelectionListeners = listenerList;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fCurrentEvent = event;
            ISelectionChangedListener[] listeners = (ISelectionChangedListener[])this.fSelectionListeners.toArray();
            int i = 0;
            while (i < listeners.length) {
                this.fCurrentListener = listeners[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
        }

        public void run() {
            this.fCurrentListener.selectionChanged(this.fCurrentEvent);
        }
    }
}

