/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD, NullDefaultLocation.TYPE_BOUND, NullDefaultLocation.TYPE_ARGUMENT, NullDefaultLocation.ARRAY_CONTENTS})
public class EnhTemplateStore
extends ContributionTemplateStore {
    public static final String USER_TEMPLATE_ID_PREFIX = "User.";
    private final ContextTypeRegistry registry;
    private final CopyOnWriteIdentityListSet<Runnable> listeners = new CopyOnWriteIdentityListSet();

    public EnhTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
        this.registry = registry;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        return this.registry;
    }

    public void addListener(Runnable listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Runnable listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyListeners() {
        for (Runnable runnable : this.listeners.toList()) {
            runnable.run();
        }
    }

    public ImList<EnhTemplatePersistenceData> getTemplateDatas(boolean includeDeleted) {
        return ImCollections.newList((Object[])this.getTemplateData(includeDeleted));
    }

    public EnhTemplatePersistenceData[] getTemplateData(boolean includeDeleted) {
        List internalDatas = this.internalGetTemplates();
        ArrayList<EnhTemplatePersistenceData> datasList = new ArrayList<EnhTemplatePersistenceData>(internalDatas.size());
        for (org.eclipse.text.templates.TemplatePersistenceData data : internalDatas) {
            if (!includeDeleted && data.isDeleted()) continue;
            datasList.add((EnhTemplatePersistenceData)data);
        }
        return datasList.toArray(new EnhTemplatePersistenceData[datasList.size()]);
    }

    public @Nullable EnhTemplatePersistenceData getTemplateData(String id) {
        ObjectUtils.nonNullAssert((Object)id);
        List internalDatas = this.internalGetTemplates();
        for (org.eclipse.text.templates.TemplatePersistenceData data : internalDatas) {
            if (!id.equals(data.getId())) continue;
            return (EnhTemplatePersistenceData)data;
        }
        return null;
    }

    protected void internalAdd(org.eclipse.text.templates.TemplatePersistenceData data) {
        if (!data.isCustom()) {
            EnhTemplatePersistenceData enhData = data instanceof EnhTemplatePersistenceData ? (EnhTemplatePersistenceData)data : new EnhTemplatePersistenceData(data.getTemplate(), data.isEnabled(), (String)ObjectUtils.nonNullAssert((Object)data.getId()));
            super.internalAdd((TemplatePersistenceData)enhData);
        }
    }

    public void add(org.eclipse.text.templates.TemplatePersistenceData data) {
        this.doAdd(data);
    }

    private @Nullable EnhTemplatePersistenceData doAdd(org.eclipse.text.templates.TemplatePersistenceData data) {
        EnhTemplatePersistenceData enhData;
        String id = data.getId();
        if (id != null && !id.startsWith(USER_TEMPLATE_ID_PREFIX)) {
            enhData = this.getTemplateData(id);
            if (enhData != null) {
                enhData.setTemplate(data.getTemplate());
                enhData.setDeleted(data.isDeleted());
                enhData.setEnabled(data.isEnabled());
                return enhData;
            }
            id = null;
        }
        if (data.isDeleted()) {
            return null;
        }
        if (id == null || this.getTemplateData(id) != null) {
            while (this.getTemplateData(id = USER_TEMPLATE_ID_PREFIX + UUID.randomUUID()) != null) {
            }
        }
        enhData = new EnhTemplatePersistenceData(data.getTemplate(), data.isEnabled(), id);
        super.add((TemplatePersistenceData)enhData);
        return enhData;
    }

    public void delete(org.eclipse.text.templates.TemplatePersistenceData data) {
        super.delete(data);
    }

    public void load() throws IOException {
        super.load();
    }

    public void save() throws IOException {
        super.save();
        this.notifyListeners();
    }

    public void restoreDefaults(boolean doSave) {
        super.restoreDefaults(doSave);
        if (doSave) {
            this.notifyListeners();
        }
    }

    public Template[] getTemplates() {
        return super.getTemplates();
    }

    public Template[] getTemplates(@Nullable String contextTypeId) {
        return super.getTemplates(contextTypeId);
    }

    public @Nullable Template findTemplateById(String id) {
        return super.findTemplateById(id);
    }

    public @Nullable Template findTemplate(String name, @Nullable String contextTypeId) {
        return super.findTemplate(name, contextTypeId);
    }

    public @Nullable Template findTemplate(String name) {
        return super.findTemplate(name);
    }

    protected void internalAdd(TemplatePersistenceData data) {
        this.internalAdd((org.eclipse.text.templates.TemplatePersistenceData)data);
    }

    public void add(TemplatePersistenceData data) {
        this.add((org.eclipse.text.templates.TemplatePersistenceData)data);
    }

    public void delete(TemplatePersistenceData data) {
        this.delete((org.eclipse.text.templates.TemplatePersistenceData)data);
    }

    public WorkingCopy getWorkingCopy() {
        return new WorkingCopy();
    }

    public static class EnhTemplatePersistenceData
    extends TemplatePersistenceData {
        private final Template orgTemplate;
        private final boolean orgIsEnabled;

        public EnhTemplatePersistenceData(Template template, boolean enabled, String id) {
            super(template, enabled, id);
            this.orgTemplate = template;
            this.orgIsEnabled = enabled;
        }

        public String getId() {
            return super.getId();
        }

        public boolean isUserAdded() {
            return this.getId().startsWith(EnhTemplateStore.USER_TEMPLATE_ID_PREFIX);
        }

        public boolean isCustom() {
            return this.isUserAdded() || super.isCustom();
        }

        public void setTemplate(Template template) {
            super.setTemplate(template);
        }

        public Template getTemplate() {
            return super.getTemplate();
        }
    }

    public class WorkingCopy
    extends TemplateStore {
        private final Map<org.eclipse.text.templates.TemplatePersistenceData, EnhTemplatePersistenceData> copy2enh;

        private WorkingCopy() {
            super((IPreferenceStore)new PreferenceStore(), "templates");
            this.copy2enh = new IdentityHashMap<org.eclipse.text.templates.TemplatePersistenceData, EnhTemplatePersistenceData>();
            this.loadFromEnh(true);
        }

        private void addExt(EnhTemplatePersistenceData enhData, Map<EnhTemplatePersistenceData, org.eclipse.text.templates.TemplatePersistenceData> previous, boolean loadCustom) {
            Object data = previous.get((Object)enhData);
            if (data != null) {
                data.revert();
            } else {
                data = new EnhTemplatePersistenceData(enhData.orgTemplate, enhData.orgIsEnabled, enhData.getId());
            }
            if (data.isUserAdded()) {
                super.add(data);
            } else {
                super.internalAdd(data);
            }
            if (loadCustom) {
                data.setTemplate(enhData.getTemplate());
                data.setDeleted(enhData.isDeleted());
                data.setEnabled(enhData.isEnabled());
            } else if (data.isUserAdded()) {
                data.setDeleted(true);
            }
            this.copy2enh.put((org.eclipse.text.templates.TemplatePersistenceData)data, enhData);
        }

        private void loadFromEnh(boolean loadCustom) {
            IdentityHashMap<EnhTemplatePersistenceData, org.eclipse.text.templates.TemplatePersistenceData> previous = new IdentityHashMap<EnhTemplatePersistenceData, org.eclipse.text.templates.TemplatePersistenceData>(this.copy2enh.size());
            for (org.eclipse.text.templates.TemplatePersistenceData data : this.copy2enh.keySet()) {
                if (!(data instanceof EnhTemplatePersistenceData)) continue;
                previous.put(this.copy2enh.get(data), data);
            }
            this.copy2enh.clear();
            try {
                super.load();
            }
            catch (IOException data) {
                // empty catch block
            }
            ImList<EnhTemplatePersistenceData> enhDatas = EnhTemplateStore.this.getTemplateDatas(true);
            for (EnhTemplatePersistenceData enhData : enhDatas) {
                this.addExt(enhData, previous, loadCustom);
            }
        }

        private void saveToEnh() {
            List internalDatas = this.internalGetTemplates();
            for (org.eclipse.text.templates.TemplatePersistenceData data : internalDatas) {
                EnhTemplatePersistenceData enhData = this.copy2enh.get(data);
                if (!data.isDeleted()) {
                    if (enhData != null) {
                        enhData.setTemplate(data.getTemplate());
                        enhData.setDeleted(false);
                        enhData.setEnabled(data.isEnabled());
                        continue;
                    }
                    enhData = EnhTemplateStore.this.doAdd(data);
                    if (enhData == null) continue;
                    this.copy2enh.put(data, enhData);
                    continue;
                }
                if (enhData == null) continue;
                EnhTemplateStore.this.delete(enhData);
            }
        }

        public void load() {
            this.loadFromEnh(true);
        }

        public void save() throws IOException {
            this.saveToEnh();
            EnhTemplateStore.this.save();
        }

        public void add(org.eclipse.text.templates.TemplatePersistenceData data) {
            super.add(data);
        }

        public void delete(org.eclipse.text.templates.TemplatePersistenceData data) {
            data.setDeleted(true);
        }

        public void restoreDeleted() {
            super.restoreDeleted();
        }

        public void restoreDefaults(boolean doSave) {
            if (doSave) {
                EnhTemplateStore.this.restoreDefaults(doSave);
                this.loadFromEnh(true);
            } else {
                this.loadFromEnh(false);
            }
        }

        protected void internalAdd(TemplatePersistenceData data) {
            this.internalAdd((org.eclipse.text.templates.TemplatePersistenceData)data);
        }

        public void add(TemplatePersistenceData data) {
            this.add((org.eclipse.text.templates.TemplatePersistenceData)data);
        }

        public void delete(TemplatePersistenceData data) {
            this.delete((org.eclipse.text.templates.TemplatePersistenceData)data);
        }
    }
}

