/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ClassLoaderUtils {
    private static final String JAR_START = "jar:";
    private static final String FILE_START = "file:";
    private static final String JAR_SEPARATOR = "!/";

    public static String getClassLocationUrlString(Class<?> refClass) {
        String urlString = ClassLoaderUtils.getUrlStringByClassloader(refClass);
        return urlString;
    }

    private static @Nullable String getUrlStringByDomain(Class<?> refClass) {
        CodeSource source;
        block5: {
            source = refClass.getProtectionDomain().getCodeSource();
            if (source != null) break block5;
            return null;
        }
        try {
            URI url = source.getLocation().toURI();
            String s = url.toString();
            if (s.endsWith(".jar")) {
                StringBuilder sb = new StringBuilder(s.length());
                if (!s.startsWith(JAR_START)) {
                    sb.append(JAR_START);
                }
                sb.append(s);
                sb.append(JAR_SEPARATOR);
                return sb.toString();
            }
            return s;
        }
        catch (SecurityException | URISyntaxException e) {
            return null;
        }
    }

    private static String getUrlStringByClassloader(Class<?> refClass) {
        try {
            String resourceName = String.valueOf(refClass.getName().replace('.', '/')) + ".class";
            URI url = refClass.getClassLoader().getResource(resourceName).toURI();
            String s = url.toString();
            if (s.endsWith(resourceName)) {
                return s.substring(0, s.length() - resourceName.length());
            }
            throw new UnsupportedOperationException("url= " + url);
        }
        catch (URISyntaxException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String toJClassPathEntryString(String url) {
        String fileUrl = url;
        if (url.startsWith(JAR_START)) {
            int separatorIdx = url.indexOf(JAR_SEPARATOR);
            if (separatorIdx != url.length() - 2) {
                throw new UnsupportedOperationException("url= " + url);
            }
            fileUrl = url.substring(JAR_START.length(), separatorIdx);
        }
        if (!fileUrl.startsWith(FILE_START)) {
            throw new UnsupportedOperationException("url= " + url);
        }
        try {
            URI uri = new URI(fileUrl);
            Path path = Paths.get(uri);
            return path.toString();
        }
        catch (URISyntaxException e) {
            throw new UnsupportedOperationException("url= " + url, e);
        }
    }

    private ClassLoaderUtils() {
    }
}

