/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;

@NonNullByDefault
public final class RHelpSearchMatchImpl
implements RHelpSearchMatch {
    private final RHelpPage page;
    private final float score;
    private final int matchCount;
    private final RHelpSearchMatch.MatchFragment @Nullable [] bestFragments;

    public RHelpSearchMatchImpl(RHelpPage page, float score, int matchCount, RHelpSearchMatch.MatchFragment @Nullable [] bestFragments) {
        this.page = page;
        this.score = score;
        this.matchCount = matchCount;
        this.bestFragments = bestFragments;
    }

    public RHelpSearchMatchImpl(RHelpPage page, float score) {
        this.page = page;
        this.score = score;
        this.matchCount = -1;
        this.bestFragments = null;
    }

    @Override
    public RHelpPage getPage() {
        return this.page;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public int getMatchCount() {
        return this.matchCount;
    }

    @Override
    public RHelpSearchMatch.MatchFragment @Nullable [] getBestFragments() {
        return this.bestFragments;
    }

    public int hashCode() {
        return this.page.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof RHelpSearchMatch && this.page.equals(((RHelpSearchMatch)obj).getPage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPage());
        sb.append(" (score= ").append(this.getScore()).append(")");
        return sb.toString();
    }

    public static class Fragment
    implements RHelpSearchMatch.MatchFragment {
        private final String field;
        private final String text;

        public Fragment(String field, String text) {
            this.field = field;
            this.text = text;
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public @Nullable String getFieldLabel() {
            if (this.field == "alias" || this.field == "alias.txt") {
                return "Topic";
            }
            if (this.field == "title.txt") {
                return "Title";
            }
            if (this.field == "concept.txt") {
                return "Concept";
            }
            if (this.field == "descr.txt") {
                return "Description";
            }
            if (this.field == "authors.txt") {
                return "Author(s)";
            }
            if (this.field == "examples.txt") {
                return "Examples";
            }
            return null;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.field);
            sb.append(": ");
            sb.append(this.text);
            return sb.toString();
        }
    }
}

