/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.runtime.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.BasicProgressMonitor;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;

@NonNullByDefault
public class StatusUtils {
    private static final IStatus[] NO_ECHILDREN = new IStatus[0];

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus convert(org.eclipse.statet.jcommons.status.Status status) {
        if (status.isMultiStatus()) {
            ImList children = status.getChildren();
            IStatus[] convertedChildren = new IStatus[children.size()];
            int i = 0;
            while (i < convertedChildren.length) {
                convertedChildren[i] = StatusUtils.convert((org.eclipse.statet.jcommons.status.Status)children.get(i));
                ++i;
            }
            return new EMultiStatus(status, convertedChildren);
        }
        if (status == Statuses.OK_STATUS) {
            return Status.OK_STATUS;
        }
        if (status == Statuses.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        return new EStatus(status);
    }

    public static org.eclipse.statet.jcommons.status.Status convert(IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            Object[] convertedChildren = new org.eclipse.statet.jcommons.status.Status[children.length];
            int i = 0;
            while (i < convertedChildren.length) {
                convertedChildren[i] = StatusUtils.convert(children[i]);
                ++i;
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), status.getMessage(), status.getException(), ImCollections.newList((Object[])convertedChildren));
        }
        if (status == Status.OK_STATUS) {
            return Statuses.OK_STATUS;
        }
        if (status == Status.CANCEL_STATUS) {
            return Statuses.CANCEL_STATUS;
        }
        if (status instanceof EStatus) {
            return ((EStatus)status).status;
        }
        return Statuses.newStatus((int)status.getSeverity(), (String)status.getPlugin(), (int)status.getCode(), (String)status.getMessage(), (Throwable)status.getException());
    }

    public static CoreException convert(StatusException e) {
        CoreException convertedException = new CoreException(StatusUtils.convert(e.getStatus()));
        e.setStackTrace(e.getStackTrace());
        return convertedException;
    }

    public static StatusException convert(CoreException e) {
        StatusException convertedException = new StatusException(StatusUtils.convert(e.getStatus()));
        convertedException.setStackTrace(e.getStackTrace());
        return convertedException;
    }

    public static ProgressMonitor convert(@Nullable IProgressMonitor eMonitor, String name, int totalWork) {
        if (eMonitor == null) {
            return new NullProgressMonitor();
        }
        EProgressData data = new EProgressData(eMonitor);
        BasicProgressMonitor convertedMonitor = new BasicProgressMonitor((BasicProgressMonitor.ProgressData)data);
        if (totalWork > 0) {
            eMonitor.beginTask(name, 0x40000000);
            convertedMonitor.beginTask(name, totalWork);
        } else {
            eMonitor.beginTask(name, -1);
            convertedMonitor.beginTask(name, -1);
            data.workRemaining = -1;
        }
        return convertedMonitor;
    }

    public static ProgressMonitor convert(@Nullable IProgressMonitor eMonitor, int totalWork) {
        return StatusUtils.convert(eMonitor, "", totalWork);
    }

    public static ProgressMonitor convert(@Nullable IProgressMonitor eMonitor) {
        return StatusUtils.convert(eMonitor, "", 1);
    }

    public static IProgressMonitor convert(@Nullable ProgressMonitor m, String name, int totalWork) {
        if (m == null) {
            return new org.eclipse.core.runtime.NullProgressMonitor();
        }
        EProgressMonitor convertedMonitor = new EProgressMonitor(m);
        convertedMonitor.beginTask(name, totalWork);
        return convertedMonitor;
    }

    public static IProgressMonitor convert(@Nullable ProgressMonitor m, int totalWork) {
        return StatusUtils.convert(m, "", totalWork);
    }

    public static IProgressMonitor convert(@Nullable ProgressMonitor m) {
        if (m == null) {
            return new org.eclipse.core.runtime.NullProgressMonitor();
        }
        return new EProgressMonitor(m);
    }

    private static class EMultiStatus
    extends EStatus {
        private final IStatus[] children;

        public EMultiStatus(org.eclipse.statet.jcommons.status.Status status, IStatus[] children) {
            super(status);
            this.children = children;
        }

        @Override
        public boolean isMultiStatus() {
            return true;
        }

        @Override
        public IStatus[] getChildren() {
            return this.children;
        }
    }

    private static class EProgressData
    extends BasicProgressMonitor.ProgressData {
        private static final int TOTAL = 0x40000000;
        private final IProgressMonitor monitor;
        private int workRemaining = 0x40000000;

        public EProgressData(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        protected void setCanceled(boolean state) {
            this.monitor.setCanceled(state);
        }

        protected void onDataChanged(byte data) {
            switch (data) {
                case 2: {
                    this.monitor.subTask("");
                    this.monitor.setTaskName(this.getMainTaskName());
                    break;
                }
                case 4: {
                    this.monitor.subTask(this.getSubTaskName());
                    break;
                }
                case 16: {
                    if (this.workRemaining < 0) break;
                    int workRemaining = (int)(this.getProgress() * 1.073741824E9);
                    if (workRemaining < this.workRemaining) {
                        this.monitor.worked(this.workRemaining - workRemaining);
                    }
                    this.workRemaining = workRemaining;
                    break;
                }
                case 64: {
                    if (!(this.monitor instanceof IProgressMonitorWithBlocking)) break;
                    org.eclipse.statet.jcommons.status.Status blocked = this.getBlocked();
                    if (blocked != null) {
                        ((IProgressMonitorWithBlocking)this.monitor).setBlocked(StatusUtils.convert(blocked));
                        break;
                    }
                    ((IProgressMonitorWithBlocking)this.monitor).clearBlocked();
                }
            }
        }
    }

    private static class EProgressMonitor
    implements IProgressMonitorWithBlocking {
        private static final org.eclipse.statet.jcommons.status.Status BLOCKED_NO_DETAIL = new InfoStatus("unknown", "blocked");
        private final ProgressMonitor m;
        private int workRemaining;

        public EProgressMonitor(ProgressMonitor m) {
            this.m = m;
        }

        public void beginTask(String name, int totalWork) {
            this.workRemaining = totalWork;
            this.m.beginTask(name, totalWork);
        }

        public void setTaskName(String name) {
            this.m.beginTask(name, this.workRemaining);
        }

        public void subTask(String name) {
            this.m.beginSubTask(name);
        }

        public boolean isCanceled() {
            return this.m.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.m.setCanceled(value);
        }

        public void worked(int work) {
            if (this.workRemaining > 0 && work > 0) {
                if (work > this.workRemaining) {
                    work = this.workRemaining;
                }
                this.workRemaining -= work;
                this.m.addWorked(work);
            }
        }

        public void done() {
            this.workRemaining = 0;
            this.m.setWorkRemaining(0);
        }

        public void internalWorked(double work) {
        }

        public void setBlocked(@Nullable IStatus reason) {
            this.m.setBlocked(reason != null ? StatusUtils.convert(reason) : BLOCKED_NO_DETAIL);
        }

        public void clearBlocked() {
            this.m.clearBlocked();
        }
    }

    private static class EStatus
    implements IStatus {
        private final org.eclipse.statet.jcommons.status.Status status;

        public EStatus(org.eclipse.statet.jcommons.status.Status status) {
            this.status = status;
        }

        public int getSeverity() {
            return this.status.getSeverity() & 0xFF;
        }

        public boolean isOK() {
            return this.status.getSeverity() == 0;
        }

        public boolean matches(int severityMask) {
            return (this.status.getSeverity() & severityMask) != 0;
        }

        public String getPlugin() {
            return this.status.getBundleId();
        }

        public int getCode() {
            return this.status.getCode();
        }

        public String getMessage() {
            return this.status.getMessage();
        }

        public @Nullable Throwable getException() {
            return this.status.getException();
        }

        public boolean isMultiStatus() {
            return false;
        }

        public IStatus[] getChildren() {
            return NO_ECHILDREN;
        }

        public String toString() {
            return this.status.toString();
        }
    }
}

