/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.util;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.statet.ltk.core.LTKUtils;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;

public class ElementComparator
implements Comparator<IModelElement> {
    private final Collator unitComparator = Collator.getInstance();
    private final Collator elementComparator;

    public ElementComparator() {
        this(Collator.getInstance());
    }

    public ElementComparator(Collator elementComparator) {
        this.elementComparator = elementComparator;
    }

    @Override
    public int compare(IModelElement e1, IModelElement e2) {
        ISourceUnit u1 = LTKUtils.getSourceUnit(e1);
        ISourceUnit u2 = LTKUtils.getSourceUnit(e2);
        int result = 0;
        if (u1 != null && u2 != null) {
            if (u1 != u2) {
                result = this.unitComparator.compare(u1.getId(), u2.getId());
            }
            if (result != 0) {
                return result;
            }
            if (e1 instanceof ISourceElement) {
                if (e2 instanceof ISourceElement) {
                    return this.compareSourceElementsInUnit((ISourceElement)e1, (ISourceElement)e2);
                }
                return -1000000;
            }
            if (e2 instanceof ISourceElement) {
                return 1000000;
            }
            return this.elementComparator.compare(e1.getId(), e2.getId());
        }
        if (u1 == null && u2 != null) {
            return Integer.MAX_VALUE;
        }
        if (u2 == null && u1 != null) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    protected int compareSourceElementsInUnit(ISourceElement e1, ISourceElement e2) {
        return e1.getSourceRange().getStartOffset() - e2.getSourceRange().getStartOffset();
    }
}

