/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.data;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;

public class DefaultColumnHeaderDataProvider
implements IDataProvider {
    private final String[] propertyNames;
    private Map<String, String> propertyToLabelMap;

    public DefaultColumnHeaderDataProvider(String[] columnLabels) {
        this.propertyNames = columnLabels;
    }

    public DefaultColumnHeaderDataProvider(String[] propertyNames, Map<String, String> propertyToLabelMap) {
        this.propertyNames = propertyNames;
        this.propertyToLabelMap = propertyToLabelMap;
    }

    public String getColumnHeaderLabel(long columnIndex) {
        String label;
        if (columnIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        String propertyName = this.propertyNames[(int)columnIndex];
        if (this.propertyToLabelMap != null && (label = this.propertyToLabelMap.get(propertyName)) != null) {
            return label;
        }
        return propertyName;
    }

    @Override
    public long getColumnCount() {
        return this.propertyNames.length;
    }

    @Override
    public long getRowCount() {
        return 1L;
    }

    @Override
    public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
        return this.getColumnHeaderLabel(columnIndex);
    }

    @Override
    public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

