/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.Ast;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Assignment;
import org.eclipse.statet.r.core.rsource.ast.Block;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.GenericVisitor;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.rsource.ast.Symbol;

public class RAst
extends Ast {
    public static final FCall.Arg[] NO_ARGS = new FCall.Arg[0];
    private static final int FAIL = -1;
    private static final int ELLIPSIS = -2;
    private static final int TEST_PARTIAL = -3;
    private static final int TEST_POSITION = -4;

    public static RAstNode findLowestFDefAssignment(AstNode root, int offset) {
        LowestFDefAssignmentSearchVisitor visitor = new LowestFDefAssignmentSearchVisitor(offset);
        try {
            root.accept((AstVisitor)visitor);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return visitor.assignment;
    }

    public static RAstNode[] findDeepestCommands(AstNode root, int startOffset, int endOffset) {
        DeepestCommandsSearchVisitor visitor = new DeepestCommandsSearchVisitor(startOffset, endOffset);
        try {
            root.accept((AstVisitor)visitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return visitor.commands.toArray(new RAstNode[visitor.commands.size()]);
    }

    public static RAstNode findNextCommands(AstNode root, int offset) {
        NextCommandsSearchVisitor visitor = new NextCommandsSearchVisitor(offset);
        try {
            root.accept((AstVisitor)visitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return visitor.next;
    }

    public static AssignExpr checkAssign(RAstNode node) {
        switch (node.getNodeType()) {
            case A_RIGHT: 
            case A_EQUALS: 
            case A_LEFT: {
                Assignment assignNode = (Assignment)node;
                if (assignNode.isSearchOperator()) {
                    return new AssignExpr(node, AssignExpr.GLOBAL, assignNode.getTargetChild(), assignNode.getSourceChild());
                }
                return new AssignExpr(node, AssignExpr.LOCAL, assignNode.getTargetChild(), assignNode.getSourceChild());
            }
            case F_CALL: {
                FCall callNode = (FCall)node;
                RAstNode refChild = callNode.getRefChild();
                if (refChild.getNodeType() != NodeType.SYMBOL) break;
                Symbol symbol = (Symbol)refChild;
                if (symbol.text == null || !symbol.text.equals("assign")) break;
                FCallArgMatch args = RAst.matchArgs(callNode.getArgsChild(), RCoreFunctions.DEFAULT.BASE_ASSIGN_args);
                return new AssignExpr(node, AssignExpr.LOCAL, args.allocatedArgs[0], args.allocatedArgs[1]);
            }
            case F_CALL_ARGS: {
                return RAst.checkAssign(node.getRParent());
            }
            case F_CALL_ARG: {
                return RAst.checkAssign(node.getRParent().getRParent());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static FCallArgMatch matchArgs(FCall.Args argsNode, ArgsDefinition argsDef) {
        block32: {
            nodeArgsCount = argsNode.getChildCount();
            defArgsCount = argsDef.size();
            allocatedArgs = defArgsCount > 0 ? new FCall.Arg[defArgsCount] : RAst.NO_ARGS;
            ellipsisDefIdx = argsDef.indexOf("...");
            match = new int[nodeArgsCount];
            ellipsisCount = 0;
            failCount = 0;
            testPartial = false;
            testPosition = false;
            nodeIdx = 0;
            while (nodeIdx < nodeArgsCount) {
                argNode = argsNode.getChild(nodeIdx);
                if (argNode.hasName()) {
                    arg = argsDef.get(argNode.getNameChild().getText());
                    if (arg != null && arg.index != ellipsisDefIdx) {
                        if (allocatedArgs[arg.index] == null) {
                            allocatedArgs[arg.index] = argNode;
                            match[nodeIdx] = arg.index;
                        } else {
                            ++failCount;
                            match[nodeIdx] = -1;
                        }
                    } else {
                        testPartial = true;
                        match[nodeIdx] = -3;
                    }
                } else {
                    testPosition = true;
                    match[nodeIdx] = -4;
                }
                ++nodeIdx;
            }
            ellipsisType = ellipsisDefIdx >= 0 ? -2 : -1;
            v0 = testStop = ellipsisDefIdx >= 0 ? ellipsisDefIdx : defArgsCount;
            if (!testPartial) break block32;
            partialArgs = null;
            nodeIdx = 0;
            while (nodeIdx < nodeArgsCount) {
                block30: {
                    if (match[nodeIdx] != -3) break block30;
                    argNode = argsNode.getChild(nodeIdx);
                    name = argNode.getNameChild().getText();
                    matchIdx = -1;
                    defIdx = 0;
                    while (defIdx < testStop) {
                        if (allocatedArgs[defIdx] == null && argsDef.get((int)defIdx).name.startsWith(name)) {
                            if (matchIdx >= 0) {
                                ++failCount;
                                match[nodeIdx] = -1;
                                break block30;
                            }
                            matchIdx = defIdx;
                        }
                        ++defIdx;
                    }
                    if (matchIdx < 0) ** GOTO lbl-1000
                    if (partialArgs == null) {
                        partialArgs = new FCall.Arg[testStop];
                        partialArgs[matchIdx] = argNode;
                        match[nodeIdx] = matchIdx;
                    } else if (partialArgs[matchIdx] == null) {
                        partialArgs[matchIdx] = argNode;
                        match[nodeIdx] = matchIdx;
                    } else lbl-1000:
                    // 2 sources

                    {
                        ++ellipsisCount;
                        match[nodeIdx] = ellipsisType;
                    }
                }
                ++nodeIdx;
            }
            if (partialArgs != null) {
                i = 0;
                while (i < testStop) {
                    if (partialArgs[i] != null) {
                        allocatedArgs[i] = partialArgs[i];
                    }
                    ++i;
                }
            }
        }
        if (testPosition) {
            defIdx = 0;
            nodeIdx = 0;
            while (nodeIdx < nodeArgsCount) {
                block31: {
                    if (match[nodeIdx] == -4) {
                        while (defIdx < testStop) {
                            if (allocatedArgs[defIdx] == null) {
                                match[nodeIdx] = defIdx;
                                allocatedArgs[defIdx++] = argsNode.getChild(nodeIdx);
                                break block31;
                            }
                            ++defIdx;
                        }
                        match[nodeIdx] = ellipsisType;
                        ++ellipsisCount;
                    }
                }
                ++nodeIdx;
            }
        }
        if (ellipsisType != -2) {
            failCount += ellipsisCount;
            ellipsisCount = 0;
        }
        ellipsisArgs = ellipsisCount > 0 ? new FCall.Arg[ellipsisCount] : RAst.NO_ARGS;
        v1 = otherArgs = failCount > 0 ? new FCall.Arg[failCount] : RAst.NO_ARGS;
        if (ellipsisCount > 0 || failCount > 0) {
            ellipsisIdx = 0;
            otherIdx = 0;
            nodeIdx = 0;
            while (nodeIdx < nodeArgsCount) {
                switch (match[nodeIdx]) {
                    case -2: {
                        ellipsisArgs[ellipsisIdx++] = argsNode.getChild(nodeIdx);
                        match[nodeIdx] = ellipsisDefIdx;
                        break;
                    }
                    case -1: {
                        otherArgs[otherIdx++] = argsNode.getChild(nodeIdx);
                    }
                }
                ++nodeIdx;
            }
        }
        return new FCallArgMatch(argsDef, argsNode, allocatedArgs, ellipsisArgs, otherArgs, match);
    }

    public static Position getElementNamePosition(RAstNode node) {
        switch (node.getNodeType()) {
            case SYMBOL: {
                if (node.getOperator(0) == RTerminal.SYMBOL_G) {
                    if ((node.getStatusCode() & 0xFFFF0) == 69904) {
                        return new Position(node.getStartOffset() + 1, node.getLength() - 1);
                    }
                    return new Position(node.getStartOffset() + 1, node.getLength() - 2);
                }
                return new Position(node.getStartOffset(), node.getLength());
            }
            case STRING_CONST: {
                if ((node.getStatusCode() & 0xFFFF0) == 69904) {
                    return new Position(node.getStartOffset() + 1, node.getLength() - 1);
                }
                return new Position(node.getStartOffset() + 1, node.getLength() - 2);
            }
        }
        return null;
    }

    public static TextRegion getElementNameRegion(RAstNode node) {
        switch (node.getNodeType()) {
            case SYMBOL: {
                if (node.getOperator(0) == RTerminal.SYMBOL_G) {
                    if ((node.getStatusCode() & 0xFFFF0) == 69904) {
                        return new BasicTextRegion(node.getStartOffset() + 1, node.getEndOffset());
                    }
                    return new BasicTextRegion(node.getStartOffset() + 1, node.getEndOffset() - 1);
                }
                return node;
            }
            case STRING_CONST: {
                if ((node.getStatusCode() & 0xFFFF0) == 69904) {
                    return new BasicTextRegion(node.getStartOffset() + 1, node.getEndOffset());
                }
                return new BasicTextRegion(node.getStartOffset() + 1, node.getEndOffset() - 1);
            }
        }
        return node;
    }

    public static boolean hasErrors(RAstNode node) {
        return (node.getStatusCode() & 0x1010000) != 0;
    }

    public static int[] computeRExpressionIndex(RAstNode node, RAstNode baseNode) {
        IntArrayList topdown = new IntArrayList();
        block8: while (node != baseNode) {
            RAstNode parent = node.getRParent();
            switch (parent.getNodeType()) {
                case SOURCELINES: 
                case F_DEF_ARGS: 
                case F_CALL: {
                    topdown.add(parent.getChildIndex(node) + 1);
                    node = parent;
                    break;
                }
                case BLOCK: 
                case GROUP: 
                case SUB_INDEXED_S: 
                case SUB_INDEXED_D: 
                case NS_GET: 
                case NS_GET_INT: 
                case SUB_NAMED_PART: 
                case SUB_NAMED_SLOT: 
                case POWER: 
                case SIGN: 
                case SEQ: 
                case SPECIAL: 
                case MULT: 
                case ADD: 
                case RELATIONAL: 
                case NOT: 
                case AND: 
                case OR: 
                case MODEL: 
                case A_RIGHT: 
                case A_EQUALS: 
                case A_LEFT: 
                case A_COLON: 
                case C_IF: 
                case C_FOR: 
                case C_WHILE: 
                case C_REPEAT: 
                case F_DEF: 
                case HELP: {
                    topdown.add(parent.getChildIndex(node) + 2);
                    node = parent;
                    break;
                }
                case SUB_INDEXED_ARGS: {
                    if (parent == baseNode) continue block8;
                    topdown.add(parent.getChildIndex(node) + 3);
                    node = parent.getRParent();
                    break;
                }
                case C_IN: 
                case F_CALL_ARGS: {
                    if (parent == baseNode) continue block8;
                    topdown.add(parent.getChildIndex(node) + 2);
                    node = parent.getRParent();
                    break;
                }
                case SUB_INDEXED_ARG: 
                case F_DEF_ARG: 
                case F_CALL_ARG: {
                    node = parent;
                    break;
                }
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException("Unexpected parent: type= " + (Object)((Object)node.getNodeType()));
                }
            }
        }
        int l = topdown.size();
        int[] path = new int[l];
        int i = 0;
        while (i < l) {
            path[i++] = topdown.getAt(l - i);
        }
        return path;
    }

    public static List<RAstNode> computeRExpressionNodes(RAstNode node, RAstNode baseNode) {
        ArrayList<RAstNode> nodes = new ArrayList<RAstNode>();
        while (node != baseNode) {
            switch (node.getNodeType()) {
                case SOURCELINES: 
                case STRING_CONST: 
                case NUM_CONST: 
                case NULL_CONST: 
                case SYMBOL: 
                case BLOCK: 
                case GROUP: 
                case SUB_INDEXED_S: 
                case SUB_INDEXED_D: 
                case NS_GET: 
                case NS_GET_INT: 
                case SUB_NAMED_PART: 
                case SUB_NAMED_SLOT: 
                case POWER: 
                case SIGN: 
                case SEQ: 
                case SPECIAL: 
                case MULT: 
                case ADD: 
                case RELATIONAL: 
                case NOT: 
                case AND: 
                case OR: 
                case MODEL: 
                case A_RIGHT: 
                case A_EQUALS: 
                case A_LEFT: 
                case A_COLON: 
                case C_IF: 
                case C_FOR: 
                case C_WHILE: 
                case C_REPEAT: 
                case F_DEF: 
                case F_DEF_ARGS: 
                case F_CALL: 
                case HELP: {
                    nodes.add(node);
                    node = node.getRParent();
                    break;
                }
                case SUB_INDEXED_ARGS: 
                case SUB_INDEXED_ARG: 
                case C_IN: 
                case F_DEF_ARG: 
                case F_CALL_ARGS: 
                case F_CALL_ARG: {
                    node = node.getRParent();
                    break;
                }
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException("Unexpected parent: type= " + (Object)((Object)node.getNodeType()));
                }
            }
        }
        if (nodes.size() > 1) {
            Collections.reverse(nodes);
        }
        return nodes;
    }

    /*
     * Unable to fully structure code
     */
    public static RAstNode getRRootNode(RAstNode node, IRegion region) {
        if (region != null) ** GOTO lbl10
        return node.getRRoot();
lbl-1000:
        // 1 sources

        {
            parent = node.getRParent();
            beginDiff = region.getOffset() - parent.getStartOffset();
            if (beginDiff > 0 || (endDiff = region.getOffset() + region.getLength() - parent.getEndOffset()) < 0) {
                return node;
            }
            if (beginDiff == 0 && endDiff == 0) {
                return parent.getNodeType() == NodeType.SOURCELINES ? node : parent;
            }
            node = parent;
lbl10:
            // 2 sources

            ** while (node.getRParent() != null)
        }
lbl11:
        // 1 sources

        return node;
    }

    public static boolean isParentChild(RAstNode parent, RAstNode child) {
        while ((child = child.getRParent()) != null) {
            if (child != parent) continue;
            return true;
        }
        return false;
    }

    public static Object toJava(RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            return RAst.parseNum(node.getText());
                        }
                        case NUM_INT: {
                            return RAst.parseInt(node.getText());
                        }
                        case TRUE: {
                            return Boolean.TRUE;
                        }
                        case FALSE: {
                            return Boolean.FALSE;
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static Integer toJavaInt(RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            Double num = RAst.parseNum(node.getText());
                            if (num == null || num != Math.rint(num)) break;
                            return num.intValue();
                        }
                        case NUM_INT: {
                            return RAst.parseInt(node.getText());
                        }
                        case TRUE: {
                            return 1;
                        }
                        case FALSE: {
                            return 0;
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static Float toJavaFloat(RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            Double num = RAst.parseNum(node.getText());
                            if (num == null || !(Math.abs(num) <= 3.4028234663852886E38)) break;
                            return Float.valueOf(num.floatValue());
                        }
                        case NUM_INT: {
                            Integer num = RAst.parseInt(node.getText());
                            if (num == null) break;
                            return Float.valueOf(num.floatValue());
                        }
                        case TRUE: {
                            return Float.valueOf(1.0f);
                        }
                        case FALSE: {
                            return Float.valueOf(0.0f);
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static Double toJavaDouble(RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            Double num = RAst.parseNum(node.getText());
                            if (num == null) break;
                            return (double)num;
                        }
                        case NUM_INT: {
                            Integer num = RAst.parseInt(node.getText());
                            if (num == null) break;
                            return num.doubleValue();
                        }
                        case TRUE: {
                            return 1.0;
                        }
                        case FALSE: {
                            return 0.0;
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static Double parseNum(String text) {
        if (text != null && !text.isEmpty()) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Integer parseInt(String text) {
        if (text != null && !text.isEmpty()) {
            try {
                if (text.endsWith("L")) {
                    text = text.substring(0, text.length() - 1);
                }
                if (text.startsWith("0x")) {
                    text = text.substring(2);
                    return Integer.parseInt(text, 16);
                }
                return Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static class AssignExpr {
        public static final Object GLOBAL = new Object();
        public static final Object LOCAL = new Object();
        public final Object environment;
        public final RAstNode assignNode;
        public final RAstNode targetNode;
        public final RAstNode valueNode;

        public AssignExpr(RAstNode assign, Object env, RAstNode target, RAstNode source) {
            this.assignNode = assign;
            this.environment = env;
            this.targetNode = target;
            this.valueNode = source;
        }
    }

    private static class DeepestCommandsSearchVisitor
    extends GenericVisitor
    implements AstVisitor {
        private final int startOffset;
        private final int stopOffset;
        private RAstNode container;
        private final List<RAstNode> commands = new ArrayList<RAstNode>();

        public DeepestCommandsSearchVisitor(int startOffset, int stopOffset) {
            this.startOffset = startOffset;
            this.stopOffset = stopOffset;
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node instanceof RAstNode) {
                ((RAstNode)node).acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                node.acceptInChildren((AstVisitor)this);
                return;
            }
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (node.endOffset >= this.startOffset && (this.startOffset == this.stopOffset ? this.stopOffset >= node.startOffset : this.stopOffset > node.startOffset) && this.container != null && this.container == node.rParent) {
                this.commands.add(node);
            }
            if (node.startOffset <= this.startOffset && this.stopOffset <= node.endOffset) {
                node.acceptInRChildren(this);
                return;
            }
        }

        @Override
        public void visit(Block node) throws InvocationTargetException {
            if (node.startOffset <= this.startOffset && this.stopOffset <= node.endOffset) {
                this.commands.clear();
                if (node.startOffset == this.startOffset && this.stopOffset == node.endOffset) {
                    this.commands.add(node);
                    this.container = null;
                    return;
                }
                this.container = node;
                node.acceptInRChildren(this);
                if (this.commands.isEmpty() && node.endOffset > this.startOffset) {
                    this.commands.add(node);
                }
                return;
            }
        }

        @Override
        public void visit(SourceComponent node) throws InvocationTargetException {
            if (node.endOffset >= this.startOffset && this.stopOffset >= node.startOffset) {
                this.commands.clear();
                this.container = node;
                node.acceptInRChildren(this);
                return;
            }
        }
    }

    public static final class FCallArgMatch {
        public final ArgsDefinition argsDef;
        public final FCall.Args argsNode;
        public final FCall.Arg[] allocatedArgs;
        public final FCall.Arg[] ellipsisArgs;
        public final FCall.Arg[] otherArgs;
        public final int[] argsNode2argsDef;

        private FCallArgMatch(ArgsDefinition argsDef, FCall.Args argsNode, FCall.Arg[] allocatedArgs, FCall.Arg[] ellipsisArgs, FCall.Arg[] otherArgs, int[] argsNode2argsDef) {
            this.argsDef = argsDef;
            this.argsNode = argsNode;
            this.allocatedArgs = allocatedArgs;
            this.ellipsisArgs = ellipsisArgs;
            this.otherArgs = otherArgs;
            this.argsNode2argsDef = argsNode2argsDef;
        }

        public FCall.Arg getArgNode(String name) {
            int idx = this.argsDef.indexOf(name);
            if (idx >= 0) {
                return this.allocatedArgs[idx];
            }
            return null;
        }

        public FCall.Arg getArgNode(int callArgIdx) {
            if (callArgIdx >= 0) {
                return this.allocatedArgs[callArgIdx];
            }
            return null;
        }

        public RAstNode getArgValueNode(String name) {
            int idx = this.argsDef.indexOf(name);
            if (idx >= 0 && this.allocatedArgs[idx] != null) {
                return this.allocatedArgs[idx].getValueChild();
            }
            return null;
        }

        public RAstNode getArgValueNode(int callArgIdx) {
            if (callArgIdx >= 0 && this.allocatedArgs[callArgIdx] != null) {
                return this.allocatedArgs[callArgIdx].getValueChild();
            }
            return null;
        }

        public ArgsDefinition.Arg getArgDef(int callArgIdx) {
            if (callArgIdx >= 0 && this.argsDef.size() > 0) {
                if (callArgIdx < this.argsNode2argsDef.length) {
                    if (this.argsNode2argsDef[callArgIdx] >= 0) {
                        return this.argsDef.get(this.argsNode2argsDef[callArgIdx]);
                    }
                } else if (callArgIdx == 0 && this.argsNode2argsDef.length == 0) {
                    return this.argsDef.get(0);
                }
            }
            return null;
        }

        public String toString() {
            return Arrays.toString(this.argsNode2argsDef);
        }
    }

    private static class LowestFDefAssignmentSearchVisitor
    extends GenericVisitor
    implements AstVisitor {
        private final int startOffset;
        private final int stopOffset;
        private boolean inAssignment;
        private RAstNode assignment;

        public LowestFDefAssignmentSearchVisitor(int offset) {
            this.startOffset = offset;
            this.stopOffset = offset;
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node instanceof RAstNode) {
                ((RAstNode)node).acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                node.acceptInChildren((AstVisitor)this);
                return;
            }
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                node.acceptInRChildren(this);
                return;
            }
        }

        @Override
        public void visit(Assignment node) throws InvocationTargetException {
            if (this.inAssignment) {
                node.getSourceChild().acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                this.inAssignment = true;
                node.getSourceChild().acceptInR(this);
                this.inAssignment = false;
                return;
            }
        }

        @Override
        public void visit(FDef node) throws InvocationTargetException {
            if (this.inAssignment || node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                RAstNode take = node;
                RAstNode candidate = node.getRParent();
                AssignExpr assign = null;
                while ((assign = RAst.checkAssign(candidate)) != null && assign.valueNode == take) {
                    take = assign.assignNode;
                    candidate = take.getRParent();
                }
                this.assignment = take;
                throw new OperationCanceledException();
            }
        }
    }

    private static class NextCommandsSearchVisitor
    extends GenericVisitor
    implements AstVisitor {
        private final int offset;
        private RAstNode container;
        private RAstNode next;

        public NextCommandsSearchVisitor(int offset) {
            this.offset = offset;
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node instanceof RAstNode) {
                ((RAstNode)node).acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.offset && this.offset >= node.getStartOffset()) {
                node.acceptInChildren((AstVisitor)this);
                return;
            }
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (this.next == null && node.startOffset >= this.offset) {
                if (this.container != null && this.container == node.rParent) {
                    this.next = node;
                    return;
                }
                node.acceptInRChildren(this);
                return;
            }
        }

        @Override
        public void visit(Block node) throws InvocationTargetException {
            if (this.next == null) {
                if (node.startOffset >= this.offset) {
                    if (this.container != null && this.container == node.rParent) {
                        this.next = node;
                        return;
                    }
                    node.acceptInRChildren(this);
                    return;
                }
                if (node.endOffset >= this.offset) {
                    this.container = node;
                    node.acceptInRChildren(this);
                    return;
                }
            }
        }

        @Override
        public void visit(SourceComponent node) throws InvocationTargetException {
            if (this.next == null) {
                AstNode parent = node.getParent();
                if (node.endOffset >= this.offset && (parent == null || parent.getStartOffset() <= this.offset && this.offset <= parent.getEndOffset())) {
                    this.container = node;
                    node.acceptInRChildren(this);
                    return;
                }
            }
        }
    }
}

