/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

public abstract class Dummy
extends RAstNode {
    Dummy(int status) {
        super(status);
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    final void updateStartOffset() {
        Expression left = this.getLeftExpr();
        if (left != null && left.node != null) {
            this.startOffset = left.node.startOffset;
        }
    }

    @Override
    final void updateEndOffset() {
        Expression right = this.getRightExpr();
        if (right != null && right.node != null) {
            this.endOffset = right.node.endOffset;
        }
    }

    static class Operator
    extends Dummy {
        final Expression leftExpr = new Expression();
        final Expression rightExpr = new Expression();

        Operator(int status) {
            super(status);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.ERROR;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return null;
        }

        @Override
        public final boolean hasChildren() {
            return true;
        }

        @Override
        public final int getChildCount() {
            return 2;
        }

        @Override
        public final RAstNode getChild(int index) {
            switch (index) {
                case 0: {
                    return this.leftExpr.node;
                }
                case 1: {
                    return this.rightExpr.node;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public final RAstNode[] getChildren() {
            return new RAstNode[]{this.leftExpr.node, this.rightExpr.node};
        }

        @Override
        public final int getChildIndex(AstNode child) {
            if (this.leftExpr.node == child) {
                return 0;
            }
            if (this.rightExpr.node == child) {
                return 1;
            }
            return -1;
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
            if (this.leftExpr.node != null) {
                this.leftExpr.node.acceptInR(visitor);
            }
            this.rightExpr.node.acceptInR(visitor);
        }

        public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            if (this.leftExpr.node != null) {
                visitor.visit((AstNode)this.leftExpr.node);
            }
            visitor.visit((AstNode)this.rightExpr.node);
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.ERROR;
        }

        @Override
        final Expression getExpr(RAstNode child) {
            if (this.rightExpr.node == child) {
                return this.rightExpr;
            }
            if (this.leftExpr.node == child) {
                return this.leftExpr;
            }
            return null;
        }

        @Override
        final Expression getLeftExpr() {
            return this.leftExpr;
        }

        @Override
        final Expression getRightExpr() {
            return this.rightExpr;
        }

        @Override
        final int getMissingExprStatus(Expression expr) {
            if (expr == this.leftExpr) {
                return 70432;
            }
            if (expr == this.rightExpr) {
                return 70448;
            }
            throw new IllegalArgumentException();
        }
    }

    static class Terminal
    extends Dummy {
        String text;

        Terminal(int status) {
            super(status);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.ERROR_TERM;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return null;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final boolean hasChildren() {
            return false;
        }

        @Override
        public final int getChildCount() {
            return 0;
        }

        @Override
        public final RAstNode getChild(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public final RAstNode[] getChildren() {
            return NO_CHILDREN;
        }

        @Override
        public final int getChildIndex(AstNode child) {
            return -1;
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) {
        }

        public final void acceptInChildren(AstVisitor visitor) {
        }

        @Override
        final Expression getExpr(RAstNode child) {
            return null;
        }

        @Override
        final Expression getLeftExpr() {
            return null;
        }

        @Override
        final Expression getRightExpr() {
            return null;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.ERROR_TERM;
        }

        @Override
        final int getMissingExprStatus(Expression expr) {
            throw new IllegalArgumentException();
        }
    }
}

