/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.internal.eutils.autonature.ConfigManager;
import org.eclipse.statet.internal.eutils.autonature.ResourceListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String BUNDLE_ID = "org.eclipse.statet.eutils.autonature";
    public static final String ENABLED_PREF_KEY = "enabled";
    private static Activator instance;
    private ConfigManager configManager;
    private ResourceListener listener;

    public static Activator getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        ILog log;
        Activator plugin = Activator.getInstance();
        if (plugin != null && (log = plugin.getLog()) != null) {
            log.log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.configManager = new ConfigManager();
        InstanceScope.INSTANCE.getNode(BUNDLE_ID).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }

    public void runStartup() {
        this.updateMonitor(true);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(ENABLED_PREF_KEY)) {
            this.updateMonitor(false);
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMonitor(boolean startup) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        boolean enabled = Platform.getPreferencesService().getBoolean(BUNDLE_ID, ENABLED_PREF_KEY, true, null);
        Activator activator = this;
        synchronized (activator) {
            if (enabled) {
                if (this.listener == null) {
                    this.listener = new ResourceListener(this.configManager);
                }
                workspace.addResourceChangeListener((IResourceChangeListener)this.listener, 1);
            } else if (this.listener != null) {
                workspace.removeResourceChangeListener((IResourceChangeListener)this.listener);
            }
        }
    }
}

