/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.tools.internal.editor.SelectDRepresentationElementsListener;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DiagramSelectDRepresentationElementsListener
extends SelectDRepresentationElementsListener {
    public static final Predicate<Notification> IS_RECONNECT = new Predicate<Notification>(){

        public boolean apply(Notification input) {
            if (input.getEventType() == 1 && (DiagramPackage.eINSTANCE.getDEdge_SourceNode().equals(input.getFeature()) || DiagramPackage.eINSTANCE.getDEdge_TargetNode().equals(input.getFeature()))) {
                return input.getOldValue() != null && input.getNewValue() != null && !input.getOldValue().equals(input.getNewValue());
            }
            return false;
        }
    };
    private static final NotificationFilter DEFAULT_NOTIFICATION_FILTER_FOR_DIAGRAM = NotificationFilter.createFeatureFilter((EStructuralFeature)ViewpointPackage.Literals.UI_STATE__ELEMENTS_TO_SELECT).or(NotificationFilter.NOT_TOUCH.and(SessionEventBrokerImpl.asFilter((Predicate)DanglingRefRemovalTrigger.IS_ATTACHMENT)).and(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION).or(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION_ELEMENT)))).or(NotificationFilter.NOT_TOUCH.and(NotificationFilter.createNotifierTypeFilter((EClassifier)DiagramPackage.Literals.DEDGE).and(SessionEventBrokerImpl.asFilter(IS_RECONNECT))));

    public DiagramSelectDRepresentationElementsListener(DialectEditor editor, boolean selectOnlyViewWithNewSemanticTarget) {
        super(editor, selectOnlyViewWithNewSemanticTarget, DEFAULT_NOTIFICATION_FILTER_FOR_DIAGRAM);
    }

    protected boolean analyseNotifications(ResourceSetChangeEvent event, DRepresentation currentRep, List<DRepresentationElement> keptNotifiedElements) {
        boolean elementsToSelectUpdated = false;
        EList attachedEObjects = null;
        for (Notification n : event.getNotifications()) {
            Object feature = n.getFeature();
            if (!ViewpointPackage.Literals.UI_STATE__ELEMENTS_TO_SELECT.equals(feature) && !ViewpointPackage.Literals.DREPRESENTATION__UI_STATE.equals(feature)) {
                Set notificationValues = DiagramPackage.eINSTANCE.getDEdge_SourceNode().equals(n.getFeature()) || DiagramPackage.eINSTANCE.getDEdge_TargetNode().equals(n.getFeature()) ? Set.of((DEdge)n.getNotifier()) : this.getAttachmentNotificationValues(n);
                for (DRepresentationElement elt : notificationValues) {
                    if (currentRep != new DRepresentationElementQuery(elt).getParentRepresentation()) continue;
                    if (attachedEObjects == null && this.isSelectOnlyViewWithNewSemanticTarget()) {
                        TransactionChangeDescription changeDescription = event.getTransaction().getChangeDescription();
                        attachedEObjects = changeDescription.getObjectsToDetach();
                    }
                    if (this.isSelectOnlyViewWithNewSemanticTarget() && !this.isViewWithNewSemanticTarget((Collection)attachedEObjects, elt) || EcoreUtil.isAncestor(keptNotifiedElements, (EObject)elt)) continue;
                    keptNotifiedElements.add(elt);
                }
                continue;
            }
            elementsToSelectUpdated = true;
        }
        return elementsToSelectUpdated;
    }

    protected void setSelectionInAsyncExec(DialectEditor dialectEditor, List<DRepresentationElement> elementsToSelect) {
        if (dialectEditor instanceof DDiagramEditor) {
            ((DDiagramEditor)dialectEditor).enableFireNotification();
        }
        super.setSelectionInAsyncExec(dialectEditor, elementsToSelect);
    }
}

