/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.util.SameLifelinePredicate;
import org.eclipse.sirius.ext.base.Option;

public class EventFinder {
    private final ISequenceEvent context;
    private final Lifeline lifeline;
    private Range expansionZone;
    private Predicate<ISequenceEvent> eventsToIgnore;
    private boolean reconnect;
    private boolean reparent;
    private Function<ISequenceEvent, Range> verticalRangeFunction = new Function<ISequenceEvent, Range>(){

        public Range apply(ISequenceEvent from) {
            return from.getVerticalRange();
        }
    };
    private Map<AbstractNodeEvent, ISequenceEvent> reparented = new HashMap<AbstractNodeEvent, ISequenceEvent>();

    public EventFinder(Lifeline context) {
        this.context = context;
        this.lifeline = context;
    }

    public EventFinder(AbstractNodeEvent context) {
        this.context = context;
        Preconditions.checkArgument((boolean)context.getLifeline().some());
        this.lifeline = (Lifeline)context.getLifeline().get();
    }

    public EventFinder(ISequenceEvent context, Lifeline lifeline) {
        this.context = context;
        this.lifeline = lifeline;
    }

    public void setVerticalRangefunction(Function<ISequenceEvent, Range> rangeFunction) {
        if (this.verticalRangeFunction != null) {
            this.verticalRangeFunction = rangeFunction;
        }
    }

    public void setReconnection(boolean mode) {
        this.reconnect = mode;
    }

    public boolean isReconnection() {
        return this.reconnect;
    }

    public void setReparent(boolean mode) {
        this.reparent = mode;
    }

    public boolean isReparent() {
        return this.reparent;
    }

    public void setExpansionZone(Range expansionZone) {
        this.expansionZone = expansionZone;
    }

    public void setEventsToIgnore(Predicate<ISequenceEvent> eventsToIgnore) {
        this.eventsToIgnore = eventsToIgnore;
    }

    public ISequenceEvent findMostSpecificEvent(final Range range) {
        if (this.context instanceof Message) {
            return null;
        }
        ISequenceEvent result = null;
        boolean contextIncludesRange = this.contextIncludesRange(range);
        if (contextIncludesRange && this.context != null && !this.shouldIgnore().apply((Object)this.context)) {
            boolean okForReparent;
            boolean okForReconnection = !this.isReconnection() || !Message.NO_RECONNECTABLE_EVENTS.apply((Object)this.context);
            boolean bl = okForReparent = !this.isReparent() || !AbstractNodeEvent.NO_REPARENTABLE_EVENTS.apply((Object)this.context);
            if (okForReconnection && okForReparent) {
                result = this.context;
            }
        }
        if (contextIncludesRange || this.isReparent()) {
            SameLifelinePredicate sameLifeline = new SameLifelinePredicate(this.lifeline);
            Predicate<ISequenceEvent> includeRange = new Predicate<ISequenceEvent>(){

                public boolean apply(ISequenceEvent ise) {
                    return EventFinder.this.includeRange(ise, range);
                }
            };
            ArrayList<ISequenceEvent> eventsToInspect = new ArrayList<ISequenceEvent>();
            if ((this.reconnect || this.reparent) && (this.context instanceof AbstractNodeEvent || this.context instanceof Lifeline)) {
                for (View view : Iterables.filter((Iterable)this.context.getNotationView().getChildren(), View.class)) {
                    Option<ISequenceEvent> ise = ISequenceElementAccessor.getISequenceEvent(view);
                    if (ise == null || !ise.some() || this.reparented.containsKey(ise.get())) continue;
                    eventsToInspect.add((ISequenceEvent)ise.get());
                }
                for (Map.Entry entry : this.reparented.entrySet()) {
                    if (entry.getValue() != this.context) continue;
                    eventsToInspect.add((ISequenceEvent)entry.getKey());
                }
            } else {
                eventsToInspect.addAll(this.context.getSubEvents());
            }
            for (ISequenceEvent iSequenceEvent : Iterables.filter(eventsToInspect, (Predicate)Predicates.and((Predicate[])new Predicate[]{includeRange, Predicates.not(this.shouldIgnore()), sameLifeline}))) {
                EventFinder childFinder = new EventFinder(iSequenceEvent, this.lifeline);
                childFinder.setReconnection(this.isReconnection());
                childFinder.setReparent(this.isReparent());
                childFinder.setEventsToIgnore(this.eventsToIgnore);
                childFinder.setExpansionZone(this.expansionZone);
                childFinder.setVerticalRangefunction(this.verticalRangeFunction);
                childFinder.setReparented(this.reparented);
                ISequenceEvent moreSpecific = childFinder.findMostSpecificEvent(range);
                if (moreSpecific == null) continue;
                result = moreSpecific;
                break;
            }
        }
        return result;
    }

    private boolean contextIncludesRange(Range range) {
        return this.includeRange(this.context, range);
    }

    private boolean includeRange(ISequenceEvent ise, Range range) {
        Range currentContextRange = (Range)this.verticalRangeFunction.apply((Object)ise);
        return this.getRangeAfterExpansion(currentContextRange).includes(range);
    }

    private Predicate<ISequenceEvent> shouldIgnore() {
        if (this.eventsToIgnore == null) {
            return Predicates.alwaysFalse();
        }
        return this.eventsToIgnore;
    }

    private Range getRangeAfterExpansion(Range range) {
        if (this.expansionZone != null && range.includesAtLeastOneBound(this.expansionZone)) {
            return range.union(this.expansionZone);
        }
        return range;
    }

    public void setReparented(Map<AbstractNodeEvent, ISequenceEvent> newParents) {
        this.reparented.putAll(newParents);
    }
}

