/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceDiagramQuery;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractMessageCreationValidator;
import org.eclipse.sirius.ext.base.Option;

public class DefaultMessageCreationValidator
extends AbstractMessageCreationValidator {
    @Override
    public boolean isValid(CreateConnectionRequest request) {
        boolean valid = super.isValid(request);
        valid = valid && this.validateNotCreatingMessageOnState() && this.validateNotCreatingMessageInInteractionUse() && this.validateNotCreatingMessageInDifferentOperands();
        valid = valid && this.checkTargetLifelineNotExplicitlyCreatedAtUpperTime() && this.checkTargetLifelineNotExplicitlyDestroyedAtLowerTime();
        return valid;
    }

    private boolean checkTargetLifelineNotExplicitlyCreatedAtUpperTime() {
        boolean valid = true;
        SequenceDiagram sequenceDiagram = this.sequenceElementSource.getDiagram();
        SequenceDiagramQuery sequenceDiagramQuery = new SequenceDiagramQuery(sequenceDiagram);
        for (ISequenceEvent sequenceEvent : Iterables.filter((Iterable)sequenceDiagramQuery.getAllSequenceEventsUpperThan(this.firstClickLocation.y), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class)))) {
            if (!this.isCreateMessageFor(sequenceEvent, ((Lifeline)this.sequenceElementTarget.getLifeline().get()).getInstanceRole())) continue;
            valid = false;
            break;
        }
        return valid;
    }

    private boolean checkTargetLifelineNotExplicitlyDestroyedAtLowerTime() {
        boolean valid = true;
        SequenceDiagram sequenceDiagram = this.sequenceElementSource.getDiagram();
        SequenceDiagramQuery sequenceDiagramQuery = new SequenceDiagramQuery(sequenceDiagram);
        for (ISequenceEvent sequenceEvent : Iterables.filter((Iterable)sequenceDiagramQuery.getAllSequenceEventsLowerThan(this.firstClickLocation.y), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class)))) {
            if (!this.isDestroyMessageFor(sequenceEvent, ((Lifeline)this.sequenceElementTarget.getLifeline().get()).getInstanceRole())) continue;
            valid = false;
            break;
        }
        return valid;
    }

    protected boolean isSequenceEventOfLifeline(ISequenceEvent sequenceEvent, Option<Lifeline> lifelineTarget) {
        Option lifeline = sequenceEvent.getLifeline();
        if (sequenceEvent instanceof Message) {
            lifeline = ((Message)sequenceEvent).getSourceElement().getLifeline();
        }
        return lifeline.equals(lifelineTarget);
    }

    protected boolean isMessageTargeting(ISequenceEvent sequenceEvent, Option<Lifeline> lifelineTarget) {
        boolean result = false;
        if (sequenceEvent instanceof Message) {
            Message message = (Message)sequenceEvent;
            result = message.getTargetElement().getLifeline().equals(lifelineTarget);
        }
        return result;
    }

    private boolean validateNotCreatingMessageInDifferentOperands() {
        boolean result = true;
        Option sourceParentOperand = null;
        if (this.sequenceElementSource instanceof Lifeline) {
            sourceParentOperand = ((Lifeline)this.sequenceElementSource).getParentOperand(this.secondClickLocation.y);
        } else if (this.sequenceElementSource instanceof AbstractNodeEvent) {
            sourceParentOperand = ((AbstractNodeEvent)this.sequenceElementSource).getParentOperand(this.secondClickLocation.y);
        } else if (this.sequenceElementSource instanceof ISequenceEvent) {
            sourceParentOperand = ((ISequenceEvent)this.sequenceElementSource).getParentOperand();
        } else if (this.sequenceElementSource instanceof InstanceRole) {
            sourceParentOperand = ((Lifeline)((InstanceRole)this.sequenceElementSource).getLifeline().get()).getParentOperand(this.secondClickLocation.y);
        }
        Option targetParentOperand = null;
        if (this.sequenceElementTarget instanceof Lifeline) {
            targetParentOperand = ((Lifeline)this.sequenceElementTarget).getParentOperand(this.secondClickLocation.y);
        } else if (this.sequenceElementTarget instanceof AbstractNodeEvent) {
            targetParentOperand = ((AbstractNodeEvent)this.sequenceElementTarget).getParentOperand(this.secondClickLocation.y);
        } else if (this.sequenceElementTarget instanceof ISequenceEvent) {
            targetParentOperand = ((ISequenceEvent)this.sequenceElementTarget).getParentOperand();
        } else if (this.sequenceElementTarget instanceof InstanceRole) {
            targetParentOperand = ((Lifeline)((InstanceRole)this.sequenceElementTarget).getLifeline().get()).getParentOperand(this.secondClickLocation.y);
        }
        if (targetParentOperand != null && sourceParentOperand != null) {
            result = targetParentOperand.equals((Object)sourceParentOperand);
        }
        return result;
    }

    private boolean validateNotCreatingMessageOnState() {
        boolean result = true;
        Option lifelineOption = this.sequenceElementTarget.getLifeline();
        if (!lifelineOption.some()) {
            result = false;
        } else {
            Lifeline lifeline = (Lifeline)lifelineOption.get();
            for (State state : lifeline.getDiagram().getAllStates()) {
                if (!((Lifeline)state.getLifeline().get()).equals((Object)lifeline) || !state.getVerticalRange().includes(this.firstClickLocation.y)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean validateNotCreatingMessageInInteractionUse() {
        Option lifeline = this.sequenceElementTarget.getLifeline();
        Predicate<InteractionUse> interactionUseOnRealTargetLocation = new Predicate<InteractionUse>(){

            public boolean apply(InteractionUse input) {
                return input.getVerticalRange().includes(DefaultMessageCreationValidator.this.firstClickLocation.y);
            }
        };
        return lifeline.some() && !Iterables.any((Iterable)((Lifeline)lifeline.get()).getAllCoveringInteractionUses(), (Predicate)interactionUseOnRealTargetLocation);
    }

    protected boolean isCreateMessageFor(ISequenceEvent sequenceEvent, InstanceRole createdInstanceRole) {
        boolean result = false;
        if (sequenceEvent instanceof Message) {
            Message createMessage = (Message)sequenceEvent;
            result = createMessage.getKind() == Message.Kind.CREATION && createMessage.getTargetElement().equals(createdInstanceRole);
        }
        return result;
    }

    protected boolean isDestroyMessageFor(ISequenceEvent sequenceEvent, InstanceRole destroyedInstanceRole) {
        boolean result = false;
        if (sequenceEvent instanceof Message) {
            Message createMessage = (Message)sequenceEvent;
            boolean bl = result = createMessage.getKind() == Message.Kind.DESTRUCTION;
            if (createMessage.getTargetElement() instanceof EndOfLife) {
                EndOfLife endOfLife = (EndOfLife)createMessage.getTargetElement();
                result = ((Lifeline)endOfLife.getLifeline().get()).getInstanceRole().equals((Object)destroyedInstanceRole);
            } else {
                result = false;
            }
        }
        return result;
    }
}

