/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.borderednode;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.description.style.Side;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class CanonicalDBorderItemLocator {
    private static final int NB_SIDES = 4;
    private int preferredSide = 8;
    private Dimension borderItemOffset = new Dimension(1, 1);
    private Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private Node container;
    private boolean borderItemHasMoved;
    private int currentSide = 8;
    private BitSet authorizedSides = new BitSet(29);
    private Rectangle parentBorder;
    private boolean snapToGrid;
    private int gridSpacing = 0;

    public CanonicalDBorderItemLocator(Node containerNode, int preferredSide) {
        this.container = containerNode;
        this.preferredSide = preferredSide;
        this.initAuthorizedSides();
    }

    public CanonicalDBorderItemLocator(Node containerNode, int preferredSide, boolean snapToGrid, int gridSpacing) {
        this(containerNode, preferredSide);
        this.snapToGrid = snapToGrid;
        this.gridSpacing = gridSpacing;
    }

    public void setBorderItemOffset(Dimension borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public Dimension getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setConstraint(Rectangle constraint) {
        if (!constraint.equals((Object)this.getConstraint())) {
            this.borderItemHasMoved = true;
        }
        this.constraint = constraint;
        if (constraint.getTopLeft().x == 0 || constraint.getTopLeft().y == 0) {
            this.setCurrentSideOfParent(this.getPreferredSideOfParent());
        }
    }

    protected Rectangle getConstraint() {
        return this.constraint;
    }

    public void setCurrentSideOfParent(int side) {
        this.currentSide = side;
    }

    public int getPreferredSideOfParent() {
        return this.preferredSide;
    }

    public static int findClosestSideOfParent(Rectangle proposedBounds, Rectangle parentBorder) {
        return CanonicalDBorderItemLocator.findClosestSideOfParent(proposedBounds, parentBorder, null, false, 0);
    }

    private static int findClosestSideOfParent(Rectangle proposedBounds, Rectangle parentBorder, BitSet authorizedSides, boolean snapToGrid, int gridSpacing) {
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedBounds.getCenter();
        boolean northAuthorized = true;
        boolean southAuthorized = true;
        boolean eastAuthorized = true;
        boolean westAuthorized = true;
        if (authorizedSides != null && !authorizedSides.isEmpty()) {
            northAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 1);
            southAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 4);
            eastAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 16);
            westAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 8);
        }
        int position = !eastAuthorized || CanonicalDBorderItemLocator.canHandleWestSide(parentCenter, childCenter, northAuthorized, southAuthorized, westAuthorized) ? CanonicalDBorderItemLocator.handleWestSide(parentBorder, parentCenter, proposedBounds, northAuthorized, southAuthorized, westAuthorized, snapToGrid, gridSpacing) : CanonicalDBorderItemLocator.handleEastSide(parentBorder, parentCenter, proposedBounds, northAuthorized, southAuthorized, eastAuthorized, snapToGrid, gridSpacing);
        return position;
    }

    private static boolean canHandleWestSide(Point parentCenter, Point childCenter, boolean northAuthorized, boolean southAuthorized, boolean westAuthorized) {
        return (westAuthorized || southAuthorized || northAuthorized) && childCenter.x < parentCenter.x;
    }

    private static int handleWestSide(Rectangle parentBorder, Point parentCenter, Rectangle borderNodeBounds, boolean northAuthorized, boolean southAuthorized, boolean westAuthorized, boolean snapToGrid, int gridSpacing) {
        int position = !southAuthorized || (westAuthorized || northAuthorized) && borderNodeBounds.getCenter().y < parentCenter.y ? CanonicalDBorderItemLocator.handleNorthWest(parentBorder, borderNodeBounds, northAuthorized, westAuthorized, snapToGrid, gridSpacing) : CanonicalDBorderItemLocator.handleSouthWest(parentBorder, borderNodeBounds, southAuthorized, westAuthorized, snapToGrid, gridSpacing);
        return position;
    }

    private static int handleNorthWest(Rectangle parentBounds, Rectangle borderNodeBounds, boolean northAuthorized, boolean westAuthorized, boolean snapToGrid, int gridSpacing) {
        int position = 0;
        Point borderNodeCenter = borderNodeBounds.getCenter();
        if (!northAuthorized || !westAuthorized) {
            position = northAuthorized ? 1 : 8;
        } else {
            Point parentTopLeft = parentBounds.getTopLeft();
            Point childLocation = borderNodeBounds.getTopLeft();
            if (snapToGrid && childLocation.y < parentTopLeft.y && childLocation.x < parentTopLeft.x) {
                position = CanonicalDBorderItemLocator.findNorthOrWestPreviousLocationSnappedToGridAndInsideParentBounds(parentBounds, borderNodeBounds, gridSpacing);
            }
            if (position == 0) {
                position = borderNodeCenter.y < parentTopLeft.y ? 1 : (borderNodeCenter.x - parentTopLeft.x <= borderNodeCenter.y - parentTopLeft.y ? 8 : 1);
            }
        }
        return position;
    }

    private static int handleSouthWest(Rectangle parentBounds, Rectangle borderNodeBounds, boolean southAuthorized, boolean westAuthorized, boolean snapToGrid, int gridSpacing) {
        int position = 0;
        Point borderNodeCenter = borderNodeBounds.getCenter();
        if (!southAuthorized || !westAuthorized) {
            position = southAuthorized ? 4 : 8;
        } else {
            Point parentBottomLeft = parentBounds.getBottomLeft();
            Point childLocation = borderNodeBounds.getTopLeft();
            if (snapToGrid && childLocation.y > parentBottomLeft.y && childLocation.x < parentBottomLeft.x) {
                position = CanonicalDBorderItemLocator.findWestOrSouthPreviousLocationSnappedToGridAndInsideParentBounds(parentBounds, borderNodeBounds, gridSpacing);
            }
            if (position == 0) {
                position = borderNodeCenter.y > parentBottomLeft.y ? 4 : (borderNodeCenter.x - parentBottomLeft.x <= parentBottomLeft.y - borderNodeCenter.y ? 8 : 4);
            }
        }
        return position;
    }

    private static int handleEastSide(Rectangle parentBounds, Point parentCenter, Rectangle borderNodeBounds, boolean northAuthorized, boolean southAuthorized, boolean eastAuthorized, boolean snapToGrid, int gridSpacing) {
        int position = !southAuthorized || (eastAuthorized || northAuthorized) && borderNodeBounds.getCenter().y < parentCenter.y ? CanonicalDBorderItemLocator.handleNorthEast(parentBounds, borderNodeBounds, northAuthorized, eastAuthorized, snapToGrid, gridSpacing) : CanonicalDBorderItemLocator.handleSouthEast(parentBounds, borderNodeBounds, southAuthorized, eastAuthorized, snapToGrid, gridSpacing);
        return position;
    }

    private static int handleNorthEast(Rectangle parentBounds, Rectangle borderNodeBounds, boolean northAuthorized, boolean eastAuthorized, boolean snapToGrid, int gridSpacing) {
        int position = 0;
        Point borderNodeCenter = borderNodeBounds.getCenter();
        if (!eastAuthorized || !northAuthorized) {
            position = eastAuthorized ? 16 : 1;
        } else {
            Point parentTopRight = parentBounds.getTopRight();
            Point childLocation = borderNodeBounds.getTopLeft();
            if (snapToGrid && childLocation.y < parentTopRight.y && childLocation.x > parentTopRight.x) {
                position = CanonicalDBorderItemLocator.findNorthOrEastPreviousLocationSnappedToGridAndInsideParentBounds(parentBounds, borderNodeBounds, gridSpacing);
            }
            if (position == 0) {
                position = borderNodeCenter.y < parentTopRight.y ? 1 : (parentTopRight.x - borderNodeCenter.x <= borderNodeCenter.y - parentTopRight.y ? 16 : 1);
            }
        }
        return position;
    }

    private static int handleSouthEast(Rectangle parentBounds, Rectangle borderNodeBounds, boolean southAuthorized, boolean eastAuthorized, boolean snapToGrid, int gridSpacing) {
        int position = 0;
        Point borderNodeCenter = borderNodeBounds.getCenter();
        if (!eastAuthorized || !southAuthorized) {
            position = eastAuthorized ? 16 : 4;
        } else {
            Point parentBottomRight = parentBounds.getBottomRight();
            Point childLocation = borderNodeBounds.getTopLeft();
            if (snapToGrid && childLocation.y > parentBottomRight.y && childLocation.x > parentBottomRight.x) {
                position = CanonicalDBorderItemLocator.findEastOrSouthPreviousLocationSnappedToGridAndInsideParentBounds(parentBounds, borderNodeBounds, gridSpacing);
            }
            if (position == 0) {
                position = borderNodeCenter.y > parentBottomRight.y ? 4 : (parentBottomRight.x - borderNodeCenter.x <= parentBottomRight.y - borderNodeCenter.y ? 16 : 4);
            }
        }
        return position;
    }

    private static int findNorthOrWestPreviousLocationSnappedToGridAndInsideParentBounds(Rectangle parentBounds, Rectangle borderNodeBounds, int gridSpacing) {
        int position = 0;
        Point location = borderNodeBounds.getLocation();
        double parentMinX = parentBounds.getLocation().preciseX();
        double parentMaxX = parentMinX + parentBounds.preciseWidth();
        double parentMinY = parentBounds.getLocation().preciseY();
        double parentMaxY = parentMinY + parentBounds.preciseHeight();
        while (!(parentMaxX < location.preciseX() && parentMaxY < location.preciseY() || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) || CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            location.translate(CanonicalDBorderItemLocator.getGapForNextGridStep(location.x, gridSpacing), CanonicalDBorderItemLocator.getGapForNextGridStep(location.y, gridSpacing));
        }
        if (!(location.equals((Object)borderNodeBounds.getLocation()) || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) && CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            position = CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) ? 1 : 8;
        }
        return position;
    }

    private static int findWestOrSouthPreviousLocationSnappedToGridAndInsideParentBounds(Rectangle parentBounds, Rectangle borderNodeBounds, int gridSpacing) {
        int position = 0;
        Point location = borderNodeBounds.getLocation();
        double parentMinX = parentBounds.getLocation().preciseX();
        double parentMaxX = parentMinX + parentBounds.preciseWidth();
        double parentMinY = parentBounds.getLocation().preciseY();
        double parentMaxY = parentMinY + parentBounds.preciseHeight();
        while (!(parentMaxX < location.preciseX() && parentMinY > location.preciseY() || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) || CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            location.translate(CanonicalDBorderItemLocator.getGapForNextGridStep(location.x, gridSpacing), -CanonicalDBorderItemLocator.getGapForPreviousGridStep(location.y, gridSpacing));
        }
        if (!(location.equals((Object)borderNodeBounds.getLocation()) || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) && CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            position = CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) ? 4 : 8;
        }
        return position;
    }

    private static int findEastOrSouthPreviousLocationSnappedToGridAndInsideParentBounds(Rectangle parentBounds, Rectangle borderNodeBounds, int gridSpacing) {
        int position = 0;
        Point location = borderNodeBounds.getLocation();
        double parentMinX = parentBounds.getLocation().preciseX();
        double parentMaxX = parentMinX + parentBounds.preciseWidth();
        double parentMinY = parentBounds.getLocation().preciseY();
        double parentMaxY = parentMinY + parentBounds.preciseHeight();
        while (!(parentMinX > location.preciseX() && parentMinY > location.preciseY() || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) || CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            location.translate(-CanonicalDBorderItemLocator.getGapForPreviousGridStep(location.x, gridSpacing), -CanonicalDBorderItemLocator.getGapForPreviousGridStep(location.y, gridSpacing));
        }
        if (!(location.equals((Object)borderNodeBounds.getLocation()) || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) && CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            position = CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) ? 4 : 16;
        }
        return position;
    }

    private static int findNorthOrEastPreviousLocationSnappedToGridAndInsideParentBounds(Rectangle parentBounds, Rectangle borderNodeBounds, int gridSpacing) {
        int position = 0;
        Point location = borderNodeBounds.getLocation();
        double parentMinX = parentBounds.getLocation().preciseX();
        double parentMaxX = parentMinX + parentBounds.preciseWidth();
        double parentMinY = parentBounds.getLocation().preciseY();
        double parentMaxY = parentMinY + parentBounds.preciseHeight();
        while (!(parentMinX > location.preciseX() && parentMaxY < location.preciseY() || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) || CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            location.translate(-CanonicalDBorderItemLocator.getGapForPreviousGridStep(location.x, gridSpacing), -CanonicalDBorderItemLocator.getGapForPreviousGridStep(location.y, gridSpacing));
        }
        if (!(location.equals((Object)borderNodeBounds.getLocation()) || CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) && CanonicalDBorderItemLocator.isInBounds(location.preciseY(), parentMinY, parentMaxY))) {
            position = CanonicalDBorderItemLocator.isInBounds(location.preciseX(), parentMinX, parentMaxX) ? 1 : 16;
        }
        return position;
    }

    private static int getGapForNextGridStep(int currentCoordinate, int gridSpacing) {
        return CanonicalDBorderItemLocator.getGapForNextGridStep(currentCoordinate, gridSpacing, Integer.MIN_VALUE);
    }

    private static int getGapForNextGridStep(int currentCoordinate, int gridSpacing, int levelToPass) {
        int remainder = Math.abs(currentCoordinate % gridSpacing);
        int gap = gridSpacing - remainder;
        if (levelToPass != Integer.MIN_VALUE && currentCoordinate + gap < levelToPass) {
            return gap + CanonicalDBorderItemLocator.getGapForNextGridStep(currentCoordinate + gap, gridSpacing, levelToPass);
        }
        return gap;
    }

    private static int getGapForPreviousGridStep(int currentCoordinate, int gridSpacing) {
        return CanonicalDBorderItemLocator.getGapForPreviousGridStep(currentCoordinate, gridSpacing, Integer.MIN_VALUE);
    }

    private static int getGapForPreviousGridStep(int currentCoordinate, int gridSpacing, int levelToPass) {
        int gap = gridSpacing;
        int remainder = Math.abs(currentCoordinate % gridSpacing);
        if (remainder > 0) {
            gap = remainder;
        }
        if (levelToPass != Integer.MIN_VALUE && currentCoordinate - gap > levelToPass) {
            return gap + CanonicalDBorderItemLocator.getGapForPreviousGridStep(currentCoordinate - gap, gridSpacing, levelToPass);
        }
        return gap;
    }

    private static boolean isInBounds(double value, double min, double max) {
        return min < value && value < max;
    }

    private void updateAuthorizedSide(DNode borderNode) {
        this.initAuthorizedSides();
        DNodeQuery query = new DNodeQuery(borderNode);
        List forbiddenSides = query.getForbiddenSide();
        if (forbiddenSides.size() != Side.VALUES.size()) {
            for (Side side : forbiddenSides) {
                if (Side.WEST.getName().equals(side.getName())) {
                    this.authorizedSides.clear(8);
                    continue;
                }
                if (Side.EAST.getName().equals(side.getName())) {
                    this.authorizedSides.clear(16);
                    continue;
                }
                if (Side.NORTH.getName().equals(side.getName())) {
                    this.authorizedSides.clear(1);
                    continue;
                }
                if (!Side.SOUTH.getName().equals(side.getName())) continue;
                this.authorizedSides.clear(4);
            }
        }
    }

    private void initAuthorizedSides() {
        this.authorizedSides.clear();
        this.authorizedSides.set(8);
        this.authorizedSides.set(4);
        this.authorizedSides.set(16);
        this.authorizedSides.set(1);
    }

    private static boolean isAuthorized(BitSet authorizedSides, int side) {
        return authorizedSides.get(side);
    }

    public void relocate(Node borderItem) {
        EObject element = borderItem.getElement();
        if (element instanceof DNode) {
            this.updateAuthorizedSide((DNode)element);
        }
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
        if (this.borderItemHasMoved) {
            int closestSide = CanonicalDBorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder(), this.authorizedSides, this.snapToGrid, this.gridSpacing);
            this.setPreferredSideOfParent(closestSide);
            this.setCurrentSideOfParent(closestSide);
            this.borderItemHasMoved = false;
        }
    }

    private Point locateOnBorder(Rectangle suggestedLocation, int suggestedSide, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        Dimension nodeSize = suggestedLocation.getSize();
        if (circuitCount < 4 && this.conflicts(recommendedLocation, nodeSize, portsNodesToIgnore).some()) {
            Rectangle newRecommendedLocationBounds = new Rectangle(recommendedLocation, nodeSize);
            recommendedLocation = suggestedSide == 8 ? this.locateOnWestBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : (suggestedSide == 4 ? this.locateOnSouthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : (suggestedSide == 16 ? this.locateOnEastBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : this.locateOnNorthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore)));
        }
        return recommendedLocation;
    }

    private Option<Rectangle> conflicts(Point recommendedLocation, Dimension nodeSize, Collection<Node> portsNodesToIgnore) {
        Rectangle recommendedRect = new Rectangle(recommendedLocation.x, recommendedLocation.y, nodeSize.width, nodeSize.height);
        EList borderItems = this.container.getPersistedChildren();
        ListIterator iterator = borderItems.listIterator();
        while (iterator.hasNext()) {
            LayoutConstraint borderItemLayoutConstraint;
            Node borderItem = (Node)iterator.next();
            boolean takeIntoAccount = true;
            ViewQuery viewQuery = new ViewQuery((View)borderItem);
            NodeQuery nodeQuery = new NodeQuery(borderItem);
            if (!nodeQuery.isBorderedNode() && !viewQuery.isForNameEditPartOnBorder()) {
                takeIntoAccount = false;
            }
            if (!this.isVisible(borderItem) || !takeIntoAccount || !((borderItemLayoutConstraint = borderItem.getLayoutConstraint()) instanceof Bounds)) continue;
            Dimension extendedDimension = this.getExtendedDimension(borderItem);
            Rectangle borderItemBounds = GMFHelper.getAbsoluteBounds(borderItem, true);
            if (extendedDimension != null) {
                borderItemBounds = PortLayoutHelper.getUncollapseCandidateLocation(extendedDimension, borderItemBounds, this.getParentBorder());
            }
            if (portsNodesToIgnore.contains(borderItem) || !borderItemBounds.intersects(recommendedRect)) continue;
            return Options.newSome((Object)borderItemBounds);
        }
        return Options.newNone();
    }

    private boolean isVisible(Node node) {
        EObject element = node.getElement();
        if (element instanceof DDiagramElement) {
            return ((DDiagramElement)element).isVisible() && node.isVisible();
        }
        return node.isVisible();
    }

    private Dimension getExtendedDimension(Node node) {
        DDiagramElementQuery diagramElementQuery;
        if (node.getElement() instanceof DDiagramElement && (diagramElementQuery = new DDiagramElementQuery((DDiagramElement)node.getElement())).isCollapsed()) {
            NodeQuery nodeQuery = new NodeQuery(node);
            return nodeQuery.getOriginalDimensionBeforeCollapse();
        }
        return null;
    }

    protected Point locateOnParent(Rectangle suggestedLocation, int suggestedSide, Node borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = suggestedLocation.getSize();
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8 || suggestedSide == 16) {
            if (suggestedSide == 8 && suggestedLocation.x != westX) {
                newX = westX;
            } else if (suggestedSide == 16 && suggestedLocation.x != eastX) {
                newX = eastX;
            }
            int nextGap = 0;
            int previousGap = 0;
            if (this.snapToGrid) {
                nextGap = CanonicalDBorderItemLocator.getGapForNextGridStep(suggestedLocation.y, this.gridSpacing, parentFigureY);
                previousGap = CanonicalDBorderItemLocator.getGapForPreviousGridStep(suggestedLocation.y, this.gridSpacing, bounds.getBottomRight().y - borderItemSize.height);
                if (suggestedLocation.y % this.gridSpacing != 0) {
                    newY = previousGap < nextGap ? suggestedLocation.y - previousGap : suggestedLocation.y + nextGap;
                }
            }
            if (borderItemSize.width > bounds.width) {
                newY = parentFigureY - (borderItemSize.height - bounds.height) / 2;
            } else if (newY < parentFigureY) {
                if (this.snapToGrid) {
                    newY = suggestedLocation.y + nextGap;
                    if (newY > bounds.getBottomLeft().y - borderItemSize.height) {
                        newY = parentFigureY;
                    }
                } else {
                    newY = parentFigureY;
                }
            } else if (newY > bounds.getBottomLeft().y - borderItemSize.height) {
                if (this.snapToGrid) {
                    newY = suggestedLocation.y - previousGap;
                    if (newY < parentFigureY) {
                        newY = bounds.getBottomLeft().y - borderItemSize.height;
                    }
                } else {
                    newY = bounds.getBottomLeft().y - borderItemSize.height;
                }
            }
        } else if (suggestedSide == 4 || suggestedSide == 1) {
            if (suggestedSide == 4 && suggestedLocation.y != southY) {
                newY = southY;
            } else if (suggestedSide == 1 && suggestedLocation.y != northY) {
                newY = northY;
            }
            int nextGap = 0;
            int previousGap = 0;
            if (this.snapToGrid) {
                nextGap = CanonicalDBorderItemLocator.getGapForNextGridStep(suggestedLocation.x, this.gridSpacing, parentFigureX);
                previousGap = CanonicalDBorderItemLocator.getGapForPreviousGridStep(suggestedLocation.x, this.gridSpacing, bounds.getBottomRight().x - borderItemSize.width);
                if (suggestedLocation.x % this.gridSpacing != 0) {
                    newX = previousGap < nextGap ? suggestedLocation.x - previousGap : suggestedLocation.x + nextGap;
                }
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (newX < parentFigureX) {
                if (this.snapToGrid) {
                    newX = suggestedLocation.x + nextGap;
                    if (newX > bounds.getBottomRight().x - borderItemSize.width) {
                        newX = parentFigureX;
                    }
                } else {
                    newX = parentFigureX;
                }
            } else if (newX > bounds.getBottomRight().x - borderItemSize.width) {
                if (this.snapToGrid) {
                    newX = suggestedLocation.x - previousGap;
                    if (newX < parentFigureX) {
                        newX = bounds.getBottomRight().x - borderItemSize.width;
                    }
                } else {
                    newX = bounds.getBottomRight().x - borderItemSize.width;
                }
            }
        }
        return new Point(newX, newY);
    }

    protected Point locateOnSouthBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightHorizontalGap = 0;
        int leftHorizontalGap = 0;
        int next = this.getNextAuthorizedSide(4);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.setX(rightTestPoint.x + rightHorizontalGap);
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == rightTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    rightHorizontalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (this.snapToGrid) {
                        rightHorizontalGap = this.computeGapWithSnapToGrid(rightTestPoint.x, rightHorizontalGap);
                    }
                    if (rightTestPoint.x + rightHorizontalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft && resultLocation == null) {
                leftTestPoint.setX(leftTestPoint.x - leftHorizontalGap);
                optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == leftTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    leftHorizontalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                    if (this.snapToGrid) {
                        leftHorizontalGap = this.computeGapWithSnapToGrid(leftTestPoint.x, leftHorizontalGap);
                    }
                    if (leftTestPoint.x - leftHorizontalGap < this.getParentBorder().getTopLeft().x) {
                        isStillFreeSpaceToTheLeft = false;
                    }
                } else {
                    resultLocation = leftTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft || isStillFreeSpaceToTheRight) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 16) continue;
            int nextYLocation = ((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1;
            if (this.snapToGrid) {
                nextYLocation = Math.min(nextYLocation, rightTestPoint.y - this.getGapForPreviousGridStep(rightTestPoint.y));
            }
            recommendedLocationForNextSide = new Point(rightTestPoint.x + rightHorizontalGap, nextYLocation);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnNorthBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightHorizontalGap = 0;
        int leftHorizontalGap = 0;
        int next = this.getNextAuthorizedSide(1);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.setX(rightTestPoint.x + rightHorizontalGap);
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == rightTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    rightHorizontalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (this.snapToGrid) {
                        rightHorizontalGap = this.computeGapWithSnapToGrid(rightTestPoint.x, rightHorizontalGap);
                    }
                    if (rightTestPoint.x + rightHorizontalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft && resultLocation == null) {
                leftTestPoint.setX(leftTestPoint.x - leftHorizontalGap);
                optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == leftTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    leftHorizontalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                    if (this.snapToGrid) {
                        leftHorizontalGap = this.computeGapWithSnapToGrid(leftTestPoint.x, leftHorizontalGap);
                    }
                    if (leftTestPoint.x - leftHorizontalGap < this.getParentBorder().getTopLeft().x) {
                        isStillFreeSpaceToTheLeft = false;
                    }
                } else {
                    resultLocation = leftTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft || isStillFreeSpaceToTheRight) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 8) continue;
            int nextYLocation = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height + 1;
            if (this.snapToGrid) {
                nextYLocation = Math.max(nextYLocation, leftTestPoint.y + this.getGapForNextGridStep(leftTestPoint.y));
            }
            recommendedLocationForNextSide = new Point(leftTestPoint.x - leftHorizontalGap, nextYLocation);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnWestBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        int next = this.getNextAuthorizedSide(8);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceBelow) {
                belowTestPoint.setY(belowTestPoint.y + belowVerticalGap);
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == belowTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (this.snapToGrid) {
                        belowVerticalGap = this.computeGapWithSnapToGrid(belowTestPoint.y, belowVerticalGap);
                    }
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (isStillFreeSpaceAbove && resultLocation == null) {
                aboveTestPoint.setY(aboveTestPoint.y - aboveVerticalGap);
                optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == aboveTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                    if (this.snapToGrid) {
                        aboveVerticalGap = this.computeGapWithSnapToGrid(aboveTestPoint.y, aboveVerticalGap);
                    }
                    if (aboveTestPoint.y - aboveVerticalGap < this.getParentBorder().getTopRight().y) {
                        isStillFreeSpaceAbove = false;
                    }
                } else {
                    resultLocation = aboveTestPoint;
                }
            }
            if (isStillFreeSpaceBelow || isStillFreeSpaceAbove) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 4) continue;
            int nextXLocation = belowTestPoint.x + ((Rectangle)optionalConflictingRectangle.get()).width + 1;
            if (this.snapToGrid) {
                nextXLocation = Math.max(nextXLocation, belowTestPoint.x + this.getGapForNextGridStep(belowTestPoint.x));
            }
            recommendedLocationForNextSide = new Point(nextXLocation, belowTestPoint.y + belowVerticalGap);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnEastBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        int next = this.getNextAuthorizedSide(16);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceBelow) {
                belowTestPoint.setY(belowTestPoint.y + belowVerticalGap);
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == belowTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (this.snapToGrid) {
                        belowVerticalGap = this.computeGapWithSnapToGrid(belowTestPoint.y, belowVerticalGap);
                    }
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (isStillFreeSpaceAbove && resultLocation == null) {
                aboveTestPoint.setY(aboveTestPoint.y - aboveVerticalGap);
                optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == aboveTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                    if (this.snapToGrid) {
                        aboveVerticalGap = this.computeGapWithSnapToGrid(aboveTestPoint.y, aboveVerticalGap);
                    }
                    if (aboveTestPoint.y - aboveVerticalGap < this.getParentBorder().getTopRight().y) {
                        isStillFreeSpaceAbove = false;
                    }
                } else {
                    resultLocation = aboveTestPoint;
                }
            }
            if (isStillFreeSpaceBelow || isStillFreeSpaceAbove) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 1) continue;
            int nextXLocation = ((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1;
            if (this.snapToGrid) {
                nextXLocation = Math.min(nextXLocation, aboveTestPoint.x - this.getGapForPreviousGridStep(aboveTestPoint.x));
            }
            recommendedLocationForNextSide = new Point(nextXLocation, aboveTestPoint.y - aboveVerticalGap);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    private int computeGapWithSnapToGrid(int currentCoordinate, int proposedGap) {
        int gapForNextGridStep = this.getGapForNextGridStep(currentCoordinate);
        return gapForNextGridStep < proposedGap ? proposedGap + this.gridSpacing - proposedGap % this.gridSpacing : gapForNextGridStep;
    }

    public void setPreferredSideOfParent(int preferredSide) {
        this.preferredSide = preferredSide;
        this.setCurrentSideOfParent(preferredSide);
    }

    private Point getPreferredLocation(Node borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        return ptAbsoluteLocation;
    }

    public int getCurrentSideOfParent() {
        return this.currentSide;
    }

    private Point getAbsoluteToBorder(Point ptRelativeOffset) {
        Point parentOrigin = this.getParentBorder().getTopLeft();
        return parentOrigin.translate(ptRelativeOffset);
    }

    private Rectangle getParentBorder() {
        if (this.parentBorder == null) {
            NodeQuery nodeQuery = new NodeQuery(this.container);
            this.parentBorder = nodeQuery.getHandleBounds();
        }
        return this.parentBorder;
    }

    public void setParentBorderBounds(Rectangle parentBounds) {
        this.parentBorder = parentBounds;
    }

    private Dimension getSize(Node borderItem) {
        return GMFHelper.getBounds(borderItem).getSize();
    }

    public Point getValidLocation(Rectangle proposedBounds, Node borderItem, Collection<Node> portsNodesToIgnore) {
        EObject element = borderItem.getElement();
        if (element instanceof DNode) {
            this.updateAuthorizedSide((DNode)element);
        }
        Rectangle realBounds = new Rectangle(proposedBounds);
        Dimension oldOffset = this.getBorderItemOffset();
        NodeQuery nodeQuery = new NodeQuery(borderItem);
        boolean isCollapsed = nodeQuery.isCollapsed();
        if (isCollapsed) {
            Dimension extendedDimension = nodeQuery.getOriginalDimensionBeforeCollapse();
            this.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            if (extendedDimension.height != proposedBounds.height || extendedDimension.width != proposedBounds.width) {
                Rectangle extendedBounds = PortLayoutHelper.getUncollapseCandidateLocation(extendedDimension, proposedBounds, this.getParentBorder());
                realBounds.setBounds(extendedBounds);
            }
        }
        int side = CanonicalDBorderItemLocator.findClosestSideOfParent(proposedBounds, this.getParentBorder(), this.authorizedSides, this.snapToGrid, this.gridSpacing);
        Point newTopLeft = this.locateOnBorder(realBounds, side, 4 - this.getNumberOfAuthorizedSides(), borderItem, portsNodesToIgnore);
        if (isCollapsed) {
            this.setBorderItemOffset(oldOffset);
            Rectangle collapsedBounds = PortLayoutHelper.getCollapseCandidateLocation(nodeQuery.getCollapsedSize(), new Rectangle(newTopLeft, nodeQuery.getOriginalDimensionBeforeCollapse()), this.getParentBorder());
            newTopLeft = collapsedBounds.getLocation();
        }
        return newTopLeft;
    }

    private int getNextAuthorizedSide(int currentSide) {
        return this.getNextAuthorizedSide(currentSide, currentSide);
    }

    private int getNextAuthorizedSide(int currentSide, int initialSide) {
        int nextAuthorized = 0;
        int nextSide = this.getNextSide(currentSide);
        if (initialSide != nextSide) {
            nextAuthorized = this.authorizedSides.get(nextSide) ? nextSide : this.getNextAuthorizedSide(nextSide, initialSide);
        }
        return nextAuthorized;
    }

    private int getNextSide(int current) {
        int next = 0;
        switch (current) {
            case 8: {
                next = 4;
                break;
            }
            case 4: {
                next = 16;
                break;
            }
            case 16: {
                next = 1;
                break;
            }
            case 1: {
                next = 8;
                break;
            }
        }
        return next;
    }

    private int getNumberOfAuthorizedSides() {
        return this.authorizedSides.cardinality();
    }

    private int getGapForNextGridStep(int currentCoordinate) {
        return CanonicalDBorderItemLocator.getGapForNextGridStep(currentCoordinate, this.gridSpacing);
    }

    private int getGapForPreviousGridStep(int currentCoordinate) {
        return CanonicalDBorderItemLocator.getGapForPreviousGridStep(currentCoordinate, this.gridSpacing);
    }
}

