/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.policy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class CompoundEditPolicy
implements EditPolicy {
    private List<EditPolicy> delegatedEditPolicies = new LinkedList<EditPolicy>();
    private EditPart host;
    private boolean allowNullCommand;

    public void setAllowNullCommand(boolean allowNullCommand) {
        this.allowNullCommand = allowNullCommand;
    }

    public boolean isAllowNullCommand() {
        return this.allowNullCommand;
    }

    public void activate() {
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext()) {
            iterEditPolicies.next().activate();
        }
    }

    public void deactivate() {
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext()) {
            iterEditPolicies.next().deactivate();
        }
    }

    public void eraseSourceFeedback(Request request) {
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext()) {
            iterEditPolicies.next().eraseSourceFeedback(request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext()) {
            iterEditPolicies.next().eraseTargetFeedback(request);
        }
    }

    public Command getCommand(Request request) {
        CompoundCommand ret = null;
        ListIterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.listIterator();
        while (iterEditPolicies.hasNext()) {
            EditPolicy editPolicy = (EditPolicy)iterEditPolicies.next();
            Command command = editPolicy.getCommand(request);
            if (command == null && !this.isAllowNullCommand()) continue;
            if (ret == null) {
                ret = new CompoundCommand();
            }
            ret.add(command);
        }
        boolean containsOnlyNullCommands = true;
        if (ret != null) {
            for (Object c : ret.getCommands()) {
                if (c == null) continue;
                containsOnlyNullCommands = false;
                break;
            }
        }
        return containsOnlyNullCommands ? null : ret;
    }

    public EditPart getHost() {
        return this.host;
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart res = null;
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext() && res == null) {
            EditPolicy next = iterEditPolicies.next();
            res = next.getTargetEditPart(request);
        }
        return res;
    }

    public void setHost(EditPart editpart) {
        this.host = editpart;
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext()) {
            iterEditPolicies.next().setHost(editpart);
        }
    }

    public void showSourceFeedback(Request request) {
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext()) {
            iterEditPolicies.next().showSourceFeedback(request);
        }
    }

    public void showTargetFeedback(Request request) {
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext()) {
            iterEditPolicies.next().showTargetFeedback(request);
        }
    }

    public boolean understandsRequest(Request request) {
        boolean res = false;
        Iterator<EditPolicy> iterEditPolicies = this.delegatedEditPolicies.iterator();
        while (iterEditPolicies.hasNext() && !res) {
            res = iterEditPolicies.next().understandsRequest(request);
        }
        return res;
    }

    public void addEditPolicy(EditPolicy editPolicy) {
        if (editPolicy == null) {
            throw new IllegalArgumentException(Messages.CompoundEditPolicy_nullEditPolicyMsg);
        }
        this.delegatedEditPolicies.add(editPolicy);
    }

    public void removeEditPolicy(EditPolicy policy) {
        this.delegatedEditPolicies.remove(policy);
    }

    public List<EditPolicy> getEditPolicies() {
        return this.delegatedEditPolicies;
    }
}

