/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.io.File;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.sirius.diagram.ui.business.api.image.ITreeImagesContentProvider;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageFiltersUtils;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ImageWorkspaceContentProvider
extends WorkbenchContentProvider
implements ITreeImagesContentProvider {
    public Object[] getChildren(Object element) {
        Object[] superResult = super.getChildren(element);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return String.CASE_INSENSITIVE_ORDER.compare(o1.toString(), o2.toString());
            }
        };
        TreeSet<Object> result = new TreeSet<Object>(comparator);
        Object[] objectArray = superResult;
        int n = superResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result.add(o);
            ++n2;
        }
        return result.toArray();
    }

    @Override
    public Optional<File> getImageFile(Object element) {
        IFile file;
        Optional<File> result = Optional.empty();
        if (element instanceof IFile && ImageFiltersUtils.isSupportedImageFile((file = (IFile)element).getName())) {
            result = Optional.of(file.getLocation().toFile());
        }
        return result;
    }

    @Override
    public Optional<String> getPath(Object element) {
        Optional<String> result = Optional.empty();
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            result = Optional.of(resource.getFullPath().toString().replaceFirst("/", ""));
        }
        return result;
    }

    @Override
    public boolean isImage(Object element) {
        return element instanceof IFile;
    }
}

