/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.ext.draw2d.figure.StyledFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.swt.graphics.Image;

public class AbstractDiagramNodeEditPartRefreshVisualsOperation {
    protected IAbstractDiagramNodeEditPart editPart;
    protected DNode node;

    protected AbstractDiagramNodeEditPartRefreshVisualsOperation(IAbstractDiagramNodeEditPart editPart) {
        this.editPart = editPart;
        EObject eObj = editPart.resolveSemanticElement();
        if (eObj instanceof DNode) {
            this.node = (DNode)eObj;
        }
    }

    public boolean canRefresh() {
        return this.node != null;
    }

    public void refreshSize() {
        SiriusWrapLabel nodeLabel;
        int width = this.refreshWidth();
        int height = this.computeHeight(width);
        Dimension d = new Dimension(width, height);
        DefaultSizeNodeFigure nodePlate = this.getNodePlate();
        int w = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int h = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension maxd = d.getCopy();
        if (w == -1) {
            maxd.width = -1;
        }
        if (h == -1) {
            maxd.height = -1;
        }
        this.setSizes(d, maxd, nodePlate);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        if (this.node.getStyle() != null && ((NodeStyle)this.node.getStyle()).getLabelPosition().getValue() == 1 && (nodeLabel = this.editPart.getNodeLabel()) != null) {
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(this.node.getDiagramElementMapping(), this.node.getStyle());
            if (new DNodeQuery(this.node).isAutoSize() && (w == -1 || h == -1)) {
                Dimension fitToText = styleConfiguration.fitToText(this.node, nodeLabel, nodePlate);
                if (w == -1 || w == 0) {
                    width = Math.max(width, fitToText.width);
                }
                if (h == -1 || h == 0) {
                    height = Math.max(height, fitToText.height);
                }
                d = new Dimension(width, height);
                this.setSizes(d, d, nodePlate);
            }
        }
        if (!AbstractDiagramNodeEditPartOperation.isBordered((EditPart)this.editPart) && !AbstractDiagramNodeEditPartOperation.isBordered(this.editPart.getParent())) {
            ((GraphicalEditPart)this.editPart.getParent()).setLayoutConstraint((EditPart)this.editPart, this.editPart.getFigure(), (Object)new Rectangle(x, y, width, height));
        } else if (this.editPart instanceof IBorderItemEditPart) {
            this.borderRefreshSizeAndLocation(x, y, width, height);
        }
    }

    private void setSizes(Dimension d, Dimension maxd, DefaultSizeNodeFigure nodePlate) {
        AbstractDiagramNodeEditPartOperation.setChildrenSize(this.editPart, d);
        StyledFigure styledFigure = DiagramElementEditPartOperation.getStyledFigure(this.editPart.getFigure());
        if (styledFigure != null) {
            styledFigure.setSize(d.width, d.height);
        }
        if (nodePlate != null) {
            nodePlate.setSize(d.width, d.height);
            nodePlate.setDefaultSize(d.width, d.height);
            nodePlate.getParent().setSize(d.width, d.height);
            nodePlate.setPreferredSize(d.width, d.height);
            nodePlate.setMinimumSize(d);
            nodePlate.setMaximumSize(maxd);
        }
        this.editPart.getFigure().setSize(d);
        this.editPart.getFigure().setMinimumSize(d);
        this.editPart.getFigure().setPreferredSize(d);
    }

    private void borderRefreshSizeAndLocation(int x, int y, int width, int height) {
        IBorderItemEditPart borderPart = (IBorderItemEditPart)this.editPart;
        IBorderItemLocator borderItemLocator = borderPart.getBorderItemLocator();
        if (borderItemLocator != null) {
            borderItemLocator.setConstraint(new Rectangle(x, y, width, height));
            if (new DDiagramElementQuery((DDiagramElement)this.node).isIndirectlyCollapsed()) {
                if (borderItemLocator instanceof DBorderItemLocator) {
                    ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                }
            } else if (borderItemLocator instanceof DBorderItemLocator) {
                ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            }
            ((GraphicalEditPart)this.editPart.getParent()).setLayoutConstraint((EditPart)this.editPart, this.editPart.getFigure(), (Object)borderItemLocator);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Dimension getWorkspaceImageFigureSize(Dimension d) {
        for (GraphicalEditPart child : this.editPart.getChildren()) {
            void shape;
            GraphicalEditPart graphicalEditPart = child;
            if (!(graphicalEditPart instanceof ShapeNodeEditPart)) continue;
            ShapeNodeEditPart cfr_ignored_0 = (ShapeNodeEditPart)graphicalEditPart;
            ShapeNodeEditPart cfr_ignored_1 = (ShapeNodeEditPart)graphicalEditPart;
            if (!(shape.getContentPane() instanceof IWorkspaceImageFigure)) continue;
            shape.getContentPane().setSize(d);
            return shape.getContentPane().getSize();
        }
        return d;
    }

    private int refreshWidth() {
        SiriusWrapLabel nodeLabel;
        int width = 10;
        width = 1;
        if (this.node.getWidth() != null) {
            width = this.node.getWidth();
        }
        if (width == 0) {
            width = 1;
        }
        if (width == -1 && this.node.getOwnedStyle() instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)this.node.getStyle();
            String path = workspaceImage.getWorkspacePath();
            Image image = WorkspaceImageFigure.getImageInstanceFromPath(path);
            width = image.getBounds().width;
        } else {
            width *= 10;
        }
        int tmpWidth = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)this.node);
        if (tmpWidth > 0 && (new DNodeQuery(this.node).allowsHorizontalResize() || query.isCollapsed())) {
            width = tmpWidth;
        }
        if (this.node.getStyle() != null && ((NodeStyle)this.node.getStyle()).getLabelPosition().getValue() == 1 && (nodeLabel = this.editPart.getNodeLabel()) != null) {
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(this.node.getDiagramElementMapping(), this.node.getStyle());
            width = styleConfiguration.adaptViewNodeSizeWithLabel(this.node, nodeLabel, width);
        }
        return width;
    }

    private int computeHeight(int width) {
        int tmpHeight;
        int height = 0;
        if (this.node.getHeight() != null) {
            height = this.node.getHeight() * 10;
        }
        DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)this.node);
        if (height == 0 && (new DNodeQuery(this.node).allowsVerticalResize() || query.isCollapsed()) && !new DNodeQuery(this.node).isAutoSize()) {
            height = width;
        }
        if ((tmpHeight = ((Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height())).intValue()) > 0) {
            height = tmpHeight;
        }
        if (this.node.getStyle() instanceof WorkspaceImage) {
            height = this.getWorkspaceImageFigureSize((Dimension)new Dimension((int)width, (int)height)).height;
        }
        return height;
    }

    private Object getStructuralFeatureValue(EStructuralFeature feature) {
        if (this.editPart.getNotationView() != null) {
            return ViewUtil.getPropertyValue((View)((View)this.editPart.getModel()), (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
        }
        return null;
    }

    protected DefaultSizeNodeFigure getNodePlate() {
        return AbstractDiagramNodeEditPartOperation.getNodePlate(this.editPart);
    }
}

