/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SnapCommand
extends AbstractTransactionalCommand {
    protected List<? extends IGraphicalEditPart> editparts;

    public SnapCommand(TransactionalEditingDomain editingDomain, List<? extends IGraphicalEditPart> editparts) {
        super(editingDomain, DiagramUIMessages.SnapToGrid_textLabel, null);
        this.editparts = editparts;
    }

    public List getAffectedFiles() {
        if (this.editparts != null) {
            IGraphicalEditPart parent = this.editparts.get(0);
            View view = parent.getPrimaryView();
            return SnapCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CompositeTransactionalCommand snapCommand = new CompositeTransactionalCommand(this.getEditingDomain(), this.getLabel());
        this.editparts.stream().forEach(newEditPart -> {
            if (newEditPart instanceof IDiagramBorderNodeEditPart) {
                this.handleBorderNode((IDiagramBorderNodeEditPart)newEditPart, snapCommand);
            } else if (newEditPart instanceof IAbstractDiagramNodeEditPart) {
                this.handleNodeAndContainer((IAbstractDiagramNodeEditPart)newEditPart, snapCommand);
            }
            newEditPart.getChildren().stream().filter(IDiagramBorderNodeEditPart.class::isInstance).forEach(borderNodeEditPart -> snapCommand.add((IUndoableOperation)new SnapCommand(this.getEditingDomain(), Collections.singletonList((IDiagramBorderNodeEditPart)borderNodeEditPart))));
            List editParts = newEditPart.getChildren().stream().filter(ep -> !(ep instanceof IDiagramBorderNodeEditPart) && ep instanceof IGraphicalEditPart).collect(Collectors.toList());
            if (!editParts.isEmpty()) {
                snapCommand.add((IUndoableOperation)new SnapCommand(this.getEditingDomain(), editParts));
            }
        });
        if (snapCommand != null && snapCommand.canExecute()) {
            snapCommand.execute(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    private void handleNodeAndContainer(IAbstractDiagramNodeEditPart newEditPart, CompositeTransactionalCommand snapCommand) {
        LayoutConstraint constraint;
        if (newEditPart.getModel() instanceof Node && (constraint = ((Node)newEditPart.getModel()).getLayoutConstraint()) instanceof Bounds) {
            Command gefMove;
            Bounds bounds = (Bounds)constraint;
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            request.setEditParts((EditPart)newEditPart);
            PrecisionDimension moveDeltaDim = new PrecisionDimension((double)(bounds.getX() - newEditPart.getFigure().getBounds().x), (double)(bounds.getY() - newEditPart.getFigure().getBounds().y));
            newEditPart.getFigure().translateToAbsolute((Translatable)moveDeltaDim);
            PrecisionPoint moveDelta = new PrecisionPoint(moveDeltaDim.preciseWidth(), moveDeltaDim.preciseHeight());
            request.getExtendedData().clear();
            request.setMoveDelta((Point)moveDelta);
            PrecisionRectangle figureBounds = null;
            IFigure figure = newEditPart.getFigure();
            figureBounds = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)figureBounds);
            Point newGMFAbsoluteLocation = GMFHelper.getAbsoluteLocation((Node)newEditPart.getModel(), true, true);
            GraphicalHelper.logical2screen((Point)newGMFAbsoluteLocation, (IGraphicalEditPart)newEditPart);
            SnapToHelper snapToHelper = (SnapToHelper)newEditPart.getAdapter(SnapToHelper.class);
            PrecisionRectangle baseRect = new PrecisionRectangle((Rectangle)figureBounds);
            baseRect.setLocation(newGMFAbsoluteLocation);
            if (snapToHelper != null) {
                PrecisionPoint result = new PrecisionPoint();
                snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, result);
                request.setMoveDelta(moveDelta.getTranslated((Point)result));
            }
            if ((gefMove = newEditPart.getCommand((Request)request)) != null) {
                snapCommand.add((IUndoableOperation)new CommandProxy(gefMove));
            }
        }
    }

    private void handleBorderNode(IDiagramBorderNodeEditPart newEditPart, CompositeTransactionalCommand snapCommand) {
        if (newEditPart.getModel() instanceof Node) {
            Node node = (Node)newEditPart.getModel();
            Node parentNode = (Node)node.eContainer();
            Dimension spacing = (Dimension)newEditPart.getViewer().getProperty("SnapToGrid.GridSpacing");
            CanonicalDBorderItemLocator itemLocator = this.initCDBIL(node, parentNode, spacing);
            Rectangle newGMFAbsoluteBounds = GMFHelper.getAbsoluteBounds(node, true, false, false, false);
            Point newValidLocation = itemLocator.getValidLocation(newGMFAbsoluteBounds, node, Collections.singleton(node));
            Point parentAbsoluteLocation = GMFHelper.getAbsoluteLocation(parentNode, true, false);
            Point newValidRelativeLocation = newValidLocation.getTranslated(parentAbsoluteLocation.getNegated());
            EditPartQuery editPartQuery = new EditPartQuery(newEditPart);
            IAbstractDiagramNodeEditPart parentEditPart = editPartQuery.getFirstAncestorOfType(IAbstractDiagramNodeEditPart.class);
            Rectangle currentFigureBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)newEditPart, (boolean)true);
            Point figureParentAbsoluteLocation = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)parentEditPart, (boolean)true).getLocation();
            Point currentRelativeFigureLocation = currentFigureBounds.getLocation().getTranslated(figureParentAbsoluteLocation.getNegated());
            Point moveDelta = newValidRelativeLocation.getTranslated(currentRelativeFigureLocation.getNegated());
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            request.setEditParts((EditPart)newEditPart);
            double scale = GraphicalHelper.getZoom((EditPart)newEditPart);
            moveDelta = new PrecisionPoint(moveDelta);
            moveDelta.scale(scale);
            request.setMoveDelta(moveDelta);
            Command gefMove = newEditPart.getCommand((Request)request);
            if (gefMove != null) {
                snapCommand.add((IUndoableOperation)new CommandProxy(gefMove));
            }
        }
    }

    private CanonicalDBorderItemLocator initCDBIL(Node node, Node parentNode, Dimension spacing) {
        CanonicalDBorderItemLocator itemLocator = new CanonicalDBorderItemLocator(parentNode, 29, true, spacing.height);
        if (new ViewQuery((View)node).isForNameEditPart()) {
            itemLocator.setBorderItemOffset(IBorderItemOffsets.NO_OFFSET);
        } else if (new DDiagramElementQuery((DDiagramElement)node.getElement()).isIndirectlyCollapsed()) {
            itemLocator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
        } else {
            itemLocator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
        }
        return itemLocator;
    }
}

