/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.routing;

import com.google.common.math.DoubleMath;
import java.util.Iterator;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.OrthogonalSelfLoopRouter;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;

public class PolylineSelfLoopRouter
extends OrthogonalSelfLoopRouter {
    private static final double CORNER_DISTANCE = 10.0;
    private static final double TOLERANCE = 0.01;

    @Override
    protected KVectorChain modifyBendPoints(SelfLoopEdge slEdge, OrthogonalSelfLoopRouter.EdgeRoutingDirection routingDirection, KVectorChain bendPoints) {
        LPort lSourcePort = slEdge.getSLSource().getLPort();
        bendPoints.add(0, (Object)lSourcePort.getPosition().clone().add(lSourcePort.getAnchor()));
        LPort lTargetPort = slEdge.getSLTarget().getLPort();
        bendPoints.add((Object)lTargetPort.getPosition().clone().add(lTargetPort.getAnchor()));
        return this.cutCorners(bendPoints, 10.0);
    }

    public KVectorChain cutCorners(KVectorChain bendPoints, double distance) {
        assert (bendPoints.size() > 2);
        KVectorChain result = new KVectorChain();
        Iterator bpIterator = bendPoints.iterator();
        KVector previous = null;
        KVector corner = (KVector)bpIterator.next();
        KVector next = (KVector)bpIterator.next();
        while (bpIterator.hasNext()) {
            previous = corner;
            corner = next;
            next = (KVector)bpIterator.next();
            assert (this.areOrthogonallyRouted(previous, corner, next));
            KVector offset1 = this.nearZeroToZero(previous.clone().sub(corner));
            KVector offset2 = this.nearZeroToZero(next.clone().sub(corner));
            double effectiveDistance = distance;
            effectiveDistance = Math.min(effectiveDistance, Math.abs(offset1.x + offset1.y) / 2.0);
            effectiveDistance = Math.min(effectiveDistance, Math.abs(offset2.x + offset2.y) / 2.0);
            offset1.x = Math.signum(offset1.x) * effectiveDistance;
            offset1.y = Math.signum(offset1.y) * effectiveDistance;
            offset2.x = Math.signum(offset2.x) * effectiveDistance;
            offset2.y = Math.signum(offset2.y) * effectiveDistance;
            result.add((Object)offset1.add(corner));
            result.add((Object)offset2.add(corner));
        }
        return result;
    }

    private boolean areOrthogonallyRouted(KVector previous, KVector corner, KVector next) {
        boolean horizontalVertical;
        boolean verticalHorizontal = DoubleMath.fuzzyEquals((double)previous.x, (double)corner.x, (double)0.01) && DoubleMath.fuzzyEquals((double)corner.y, (double)next.y, (double)0.01);
        boolean bl = horizontalVertical = DoubleMath.fuzzyEquals((double)previous.y, (double)corner.y, (double)0.01) && DoubleMath.fuzzyEquals((double)corner.x, (double)next.x, (double)0.01);
        return verticalHorizontal || horizontalVertical;
    }

    private KVector nearZeroToZero(KVector vector) {
        if (vector.x >= -0.01 && vector.x <= 0.01) {
            vector.x = 0.0;
        }
        if (vector.y >= -0.01 && vector.y <= 0.01) {
            vector.y = 0.0;
        }
        return vector;
    }
}

